/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.external.impl;

import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngineFactory;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.external.BaseExternalProjectImporter;
import com.silabs.ss.framework.project.api.core.external.IExternalImporter;
import com.silabs.ss.framework.project.api.core.external.IFlagParser;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.ImportProjectRecord;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MMacroDefinition;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.options.ConvertedOptionsUtils;
import com.silabs.ss.framework.project.api.core.model.options.GenericOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.internal.api.core.external.impl.KeilDirectOptionsMappings;
import com.silabs.ss.framework.project.internal.api.core.external.impl.KeilExternalOptions;
import com.silabs.ss.framework.project.internal.api.core.external.impl.KeilFlagParser;
import com.silabs.ss.framework.project.internal.api.core.external.impl.KeilGenericOptionsMappings;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.external.keilProject.BaseExtensibleType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.CommonPropertyType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.DocumentRoot;
import com.silabs.ss.framework.project.internal.core.external.keilProject.File51Type;
import com.silabs.ss.framework.project.internal.core.external.keilProject.FileArmType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.FileOptionType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.FileType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.Group51Type;
import com.silabs.ss.framework.project.internal.core.external.keilProject.GroupArmType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.GroupType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.ProjectType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.Target51Type;
import com.silabs.ss.framework.project.internal.core.external.keilProject.TargetArmType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.TargetCommonOptionType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.TargetType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.VariousControlsType;
import com.silabs.ss.framework.project.internal.core.external.keilProject.util.KeilModelResourceFactoryImpl;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class KeilExternalProjectImporter
extends BaseExternalProjectImporter
implements IExternalImporter {
    private static final IFlagParser KEIL_FLAG_PARSER = new KeilFlagParser();

    public KeilExternalProjectImporter(String superTypeId) {
        super(superTypeId);
    }

    @Override
    public ImportProjectRecord[] findProjects(File projectLocation) {
        File[] files = projectLocation.listFiles((d, n) -> "uvproj".equalsIgnoreCase(new Path(n).getFileExtension()));
        ArrayList<ImportProjectRecord> projectRecordsList = new ArrayList<ImportProjectRecord>();
        if (files != null) {
            File[] fileArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                File file = fileArray[n3];
                projectRecordsList.add(new ImportProjectRecord(new Path(file.getName()).removeFileExtension().toOSString(), file));
                ++n3;
            }
        }
        return (ImportProjectRecord[])projectRecordsList.toArray(ImportProjectRecord[]::new);
    }

    @Override
    public MProject createImportModel(IImportProjectDescriptor importDescr, IProgressMonitor monitor) throws CoreException {
        KeilModelResourceFactoryImpl factory = new KeilModelResourceFactoryImpl();
        File projectFile = importDescr.getInputLocation();
        Resource resource = factory.createResource(URI.createFileURI((String)projectFile.getAbsolutePath()));
        try {
            resource.load(null);
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("failed to load " + String.valueOf(projectFile), (Throwable)e);
        }
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        if (root == null) {
            throw Activator.reporter.newCoreException("no document root in " + String.valueOf(projectFile));
        }
        ProjectType proj = root.getProject();
        if (proj == null) {
            throw Activator.reporter.newCoreException("no <project> in " + String.valueOf(projectFile));
        }
        KeilProjectImporter importer = new KeilProjectImporter(importDescr);
        MProject mproject = importer.importProject(proj);
        return mproject;
    }

    protected static void appendOptionFlags(IProperty property, Object inputValue, MSettingsSite site) {
        MSpecificOption specOption = ConvertedOptionsUtils.findSpecificOption((MSettingsSite)site, (IProperty)property);
        if (specOption == null) {
            KeilExternalProjectImporter.addOption(property, inputValue, site);
        } else {
            Object option = specOption.getValue();
            if (option instanceof String) {
                Object value = (String)inputValue;
                value = (String)option + " " + (String)value;
                KeilExternalProjectImporter.addOption(property, ((String)value).trim(), site);
            } else if (option instanceof List) {
                List value = (List)inputValue;
                ((List)option).addAll(value);
                KeilExternalProjectImporter.addOption(property, option, site);
            }
        }
    }

    private static String convertOptions(BaseExtensibleType ext, Map<String, IProperty> properties) {
        StringBuilder sb = new StringBuilder();
        IProperty property = null;
        if (ext != null) {
            try {
                Object[] keys = properties.keySet().toArray(new String[properties.size()]);
                Arrays.sort(keys);
                Object[] objectArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object directive = objectArray[n2];
                    property = properties.get(((String)directive).trim());
                    Object value = ext.getClass().getMethod("get" + property.getName(), new Class[0]).invoke((Object)ext, new Object[0]);
                    if (value instanceof String && !"".equals(((String)value).trim())) {
                        int start;
                        if (((String)directive).endsWith("_SEGMENT") && (start = sb.indexOf((String)(directive = ((String)directive).replace("_SEGMENT", "")))) > -1) {
                            int end = sb.indexOf(")", start);
                            sb.insert(end, "," + String.valueOf(value));
                            value = null;
                        }
                        if (value != null) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append((String)directive);
                            sb.append("(");
                            sb.append((String)value);
                            sb.append(")");
                        }
                        GenericOptionMappingFactory.with((IProperty)property).is(EMappingStatus.PARTIALLY_MAPPED).addTo((IOptionMappingRegistry)KeilGenericOptionsMappings.genericRegistry);
                    }
                    ++n2;
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            catch (Exception e) {
                Activator.reporter.logError("Failed to map property " + property.getName(), (Throwable)e);
            }
        }
        return sb.toString().replaceAll("(\\r|\\n)", " ");
    }

    protected static void addOption(IProperty property, Object value, MSettingsSite site) {
        ConvertedOptionsUtils.findOrCreateSpecificOption((MSettingsSite)site, (IProperty)property, (Object)value);
    }

    private static class KeilProjectImporter {
        private IImportProjectDescriptor importDescr;
        private MProject project;
        private IProjectModel model;
        private File contentDir;
        private static final boolean Debug_Running = false;
        private Integer numBanks = 0;
        private Map<MEntry, Integer> bankMap;

        public KeilProjectImporter(IImportProjectDescriptor importDescr) {
            this.importDescr = importDescr;
            importDescr.getOptionMappingRegistries().add((IOptionMappingRegistry<?, ?, ?>)KEIL_FLAG_PARSER.getDirectRegistry());
            importDescr.getOptionMappingRegistries().add((IOptionMappingRegistry<?, ?, ?>)KEIL_FLAG_PARSER.getGenericRegistry());
            this.project = ProjectModelFactory.eINSTANCE.createMProject();
            this.project.setName(importDescr.getName());
            this.contentDir = importDescr.getImportProjectRecord().getProjectDirectory();
            this.project.setContentRoot(this.contentDir.toURI().toString());
            this.model = IProjectModelEngineFactory.INSTANCE.createProjectModel(this.project, null);
        }

        private MProject importProject(ProjectType proj) {
            if (!proj.getSchemaVersion().matches("1\\.0|1\\.1")) {
                this.importDescr.getReport().addMessage(2, "unexpected schema version (" + proj.getSchemaVersion() + "), conversion might not be accurate");
            }
            for (TargetType target : proj.getTargets().getTarget()) {
                for (GroupType group : target.getGroups().getGroup()) {
                    this.importGroup(group);
                }
            }
            for (TargetType target : proj.getTargets().getTarget()) {
                this.bankMap = new HashMap<MEntry, Integer>();
                MConfiguration config = this.importTargetConfigurationSettings(target);
                for (GroupType group : target.getGroups().getGroup()) {
                    MFolderEntry groupEntry = ProjectModelUtils.findOrCreateFolder(null, (MFolderEntry)this.project, group.getGroupName());
                    if (groupEntry == null) continue;
                    MSettingsSite groupConfig = this.importGroupSettings(group, (MEntry)groupEntry, config);
                    if (groupConfig != null) {
                        config.getEntrySettings().put((Object)groupEntry, (Object)groupConfig);
                    }
                    for (FileType file : group.getFiles().getFile()) {
                        MSettingsSite fileConfig;
                        MFileEntry fileEntry = ProjectModelUtils.findFile(this.model, groupEntry, file.getFileName());
                        if (fileEntry == null || (fileConfig = this.importFileSettings(file, fileEntry, config)) == null) continue;
                        config.getEntrySettings().put((Object)fileEntry, (Object)fileConfig);
                    }
                }
                if (config == null) continue;
                this.project.getConfigurations().add((Object)config);
            }
            return this.project;
        }

        private void importGroup(GroupType group) {
            MFolderEntry folder = ProjectModelUtils.findOrCreateFolder(this.model, (MFolderEntry)this.project, group.getGroupName());
            if (group.getFiles() != null) {
                for (FileType file : group.getFiles().getFile()) {
                    this.importFile(folder, file);
                }
            }
        }

        private void importFile(MFolderEntry folder, FileType filet) {
            IPath basePath = IPathUtils.createPath((String)filet.getFilePath());
            String desiredExt = basePath.getFileExtension();
            if ("C".equals(desiredExt)) {
                desiredExt = desiredExt.toLowerCase(Locale.ROOT);
            } else if ("a51".equals(desiredExt)) {
                desiredExt = desiredExt.toUpperCase(Locale.ROOT);
            }
            IPath folderPath = ProjectModelUtils.getProjectPathFor((MEntry)folder);
            IPath projPath = this.importDescr.getImportMode() != ImportMode.COPY ? folderPath.append(filet.getFileName()) : folderPath.append(basePath);
            projPath = projPath.removeFileExtension().addFileExtension(desiredExt);
            basePath = basePath.removeFileExtension().addFileExtension(desiredExt);
            File realFile = basePath.isAbsolute() ? basePath.toFile() : new File(this.contentDir, basePath.toOSString());
            MFileContent file = ProjectModelUtils.findOrCreateFileContent(this.model, this.project, projPath, realFile.toURI().toString());
            if (this.importDescr.getImportMode() == ImportMode.LINK || folder instanceof MFolderContent && ((MFolderContent)folder).isVirtual()) {
                file.setLinked(Boolean.valueOf(true));
            }
        }

        private MConfiguration importTargetConfigurationSettings(TargetType target) {
            MConfiguration config = ProjectModelFactory.eINSTANCE.createMConfiguration();
            if (target == null) {
                return config;
            }
            config.setName(target.getTargetName().replaceAll(" ", "_"));
            config.setLabel(target.getTargetName().replaceAll(" ", "_"));
            Target51Type target51 = target.getTargetOption().getTarget51();
            TargetArmType targetArm = target.getTargetOption().getTargetArm();
            if (target51 != null) {
                config.setPartCompatibility("mcu.8051.*");
                config.setToolchainCompatibility(".*keil.*");
                this.project.setToolchainCompatibility(".*keil.*");
                if (target51.getTarget51Misc() != null) {
                    if (target51.getTarget51Misc().getRTOS() == 1) {
                        KeilExternalProjectImporter.appendOptionFlags(KeilExternalOptions.L51_MISC_CONTROLS, "Rtx51Tiny", (MSettingsSite)config);
                    } else if (target51.getTarget51Misc().getRTOS() == 2) {
                        KeilExternalProjectImporter.appendOptionFlags(KeilExternalOptions.L51_MISC_CONTROLS, "Rtx51", (MSettingsSite)config);
                    }
                    if (Integer.valueOf(1).equals(target51.getTarget51Misc().getUseCB())) {
                        this.numBanks = (int)(target51.getTarget51Misc() == null ? 0.0 : Math.pow(2.0, 1 + target51.getTarget51Misc().getCBanks()));
                        int bank = target.getTargetOption().getCommonProperty().getBankNo();
                        this.bankMap.put((MEntry)this.project, bank < this.numBanks ? bank : 0);
                    } else {
                        this.bankMap.put((MEntry)this.project, 0);
                        this.numBanks = 0;
                    }
                }
                this.importToolOptions(target51.getTarget51Misc(), (MSettingsSite)config, KeilExternalOptions.target51OptionGroup);
                this.importToolOptions(target51.getLx51(), (MSettingsSite)config, KeilExternalOptions.linker51OptionGroup);
                this.importToolOptions(target51.getC51(), (MSettingsSite)config, KeilExternalOptions.compiler51OptionGroup);
                this.importToolOptions(target51.getAx51(), (MSettingsSite)config, KeilExternalOptions.assembler51OptionGroup);
                if (target51.getAx51() != null) {
                    this.importVariousOptions(target51.getAx51().getVariousControls(), (MSettingsSite)config, ImporterTool.ToolchainID.EIGHTYFIFTYONE, ImporterTool.ToolType.ASSEMBLER, ELanguage.ASM.toString());
                }
                if (target51.getC51() != null) {
                    this.importVariousOptions(target51.getC51().getVariousControls(), (MSettingsSite)config, ImporterTool.ToolchainID.EIGHTYFIFTYONE, ImporterTool.ToolType.COMPILER, ProjectImportUtils.getELanguageString(ELanguage.C, ELanguage.CPP));
                }
                if (target51.getLx51() != null) {
                    String convertedOptions = "";
                    convertedOptions = 1 == target51.getTarget51Misc().getUseL251() ? KeilExternalProjectImporter.convertOptions(target51.getLx51(), KeilDirectOptionsMappings.LXLinkerDirecitives) : KeilExternalProjectImporter.convertOptions(target51.getLx51(), KeilDirectOptionsMappings.BLLinkerDirecitives);
                    this.importMiscOptions((MSettingsSite)config, target51.getLx51().getMiscControls() + " " + convertedOptions, ImporterTool.ToolchainID.EIGHTYFIFTYONE, ImporterTool.ToolType.LINKER, ELanguage.OBJ.toString());
                }
            } else if (targetArm != null) {
                config.setPartCompatibility("mcu.arm.*");
                config.setToolchainCompatibility("-.*");
                this.project.setToolchainCompatibility("-.*");
                this.numBanks = null;
                this.importToolOptions(targetArm.getArmMisc(), (MSettingsSite)config, KeilExternalOptions.targetArmOptionGroup);
                this.importToolOptions(targetArm.getAarm(), (MSettingsSite)config, KeilExternalOptions.assemblerArmOptionGroup);
                this.importToolOptions(targetArm.getCarm(), (MSettingsSite)config, KeilExternalOptions.compilerArmOptionGroup);
                this.importToolOptions(targetArm.getLDarm(), (MSettingsSite)config, KeilExternalOptions.linkerArmOptionGroup);
                if (targetArm.getAarm() != null) {
                    this.importVariousOptions(targetArm.getAarm().getVariousControls(), (MSettingsSite)config, ImporterTool.ToolchainID.ARM, ImporterTool.ToolType.ASSEMBLER, ELanguage.ASM.toString());
                }
                if (targetArm.getCarm() != null) {
                    this.importVariousOptions(targetArm.getCarm().getVariousControls(), (MSettingsSite)config, ImporterTool.ToolchainID.ARM, ImporterTool.ToolType.COMPILER, ProjectImportUtils.getELanguageString(ELanguage.C, ELanguage.CPP));
                }
                if (targetArm.getLDarm() != null) {
                    this.importMiscOptions((MSettingsSite)config, targetArm.getLDarm().getMisc(), ImporterTool.ToolchainID.ARM, ImporterTool.ToolType.LINKER, ELanguage.OBJ.toString());
                }
            }
            this.importCommonOptions(target.getTargetOption().getTargetCommonOption(), (MSettingsSite)config);
            this.importIncludesOptions((MSettingsSite)config, target.getTargetOption().getTargetCommonOption().getIncludePath(), "ALL");
            return config;
        }

        private MSettingsSite importGroupSettings(GroupType group, MEntry entry, MConfiguration config) {
            if (group == null || group.getGroupOption() == null) {
                return null;
            }
            KeilProjectImporter.DebugPrint("\nImporting Folder/Group Options: " + group.getGroupName());
            MSettingsSite site = ProjectModelFactory.eINSTANCE.createMSettingsSite();
            this.importCommonProperty(config, site, entry, group.getGroupOption().getCommonProperty());
            Group51Type group51 = group.getGroupOption().getGroup51();
            GroupArmType groupArm = group.getGroupOption().getGroupArm();
            if (group51 != null) {
                this.importToolOptions(group51.getAx51(), site, KeilExternalOptions.assembler51OptionGroup);
                this.importToolOptions(group51.getC51(), site, KeilExternalOptions.compiler51OptionGroup);
                this.importVariousOptions(group51.getAx51() != null ? group51.getAx51().getVariousControls() : null, site, ImporterTool.ToolchainID.EIGHTYFIFTYONE, ImporterTool.ToolType.ASSEMBLER, ELanguage.ASM.toString());
                this.importVariousOptions(group51.getC51() != null ? group51.getC51().getVariousControls() : null, site, ImporterTool.ToolchainID.EIGHTYFIFTYONE, ImporterTool.ToolType.COMPILER, ProjectImportUtils.getELanguageString(ELanguage.C, ELanguage.CPP));
            } else if (groupArm != null) {
                this.importToolOptions(groupArm.getAarm(), site, KeilExternalOptions.assemblerArmOptionGroup);
                this.importToolOptions(groupArm, site, KeilExternalOptions.compilerArmOptionGroup);
                this.importVariousOptions(groupArm.getAarm() != null ? groupArm.getAarm().getVariousControls() : null, site, ImporterTool.ToolchainID.ARM, ImporterTool.ToolType.ASSEMBLER, ELanguage.ASM.toString());
                this.importVariousOptions(groupArm.getCarm() != null ? groupArm.getCarm().getVariousControls() : null, site, ImporterTool.ToolchainID.ARM, ImporterTool.ToolType.COMPILER, ProjectImportUtils.getELanguageString(ELanguage.C, ELanguage.CPP));
            }
            return site;
        }

        private MSettingsSite importFileSettings(FileType file, MFileEntry entry, MConfiguration config) {
            if (file == null || file.getFileOption().size() == 0) {
                return null;
            }
            KeilProjectImporter.DebugPrint("\nImporting File Options " + file.getFileName());
            MSettingsSite site = ProjectModelFactory.eINSTANCE.createMSettingsSite();
            for (FileOptionType filetype : file.getFileOption()) {
                this.importCommonProperty(config, site, (MEntry)entry, filetype.getCommonProperty());
                File51Type file51 = filetype.getFile51();
                FileArmType fileArm = filetype.getFileArm();
                if (file51 != null) {
                    this.importToolOptions(file51.getAx51(), site, KeilExternalOptions.assembler51OptionGroup);
                    this.importToolOptions(file51.getC51(), site, KeilExternalOptions.compiler51OptionGroup);
                    this.importVariousOptions(file51.getAx51() != null ? file51.getAx51().getVariousControls() : null, site, ImporterTool.ToolchainID.EIGHTYFIFTYONE, ImporterTool.ToolType.ASSEMBLER, ELanguage.ASM.toString());
                    this.importVariousOptions(file51.getC51() != null ? file51.getC51().getVariousControls() : null, site, ImporterTool.ToolchainID.EIGHTYFIFTYONE, ImporterTool.ToolType.COMPILER, ProjectImportUtils.getELanguageString(ELanguage.C, ELanguage.CPP));
                    continue;
                }
                if (fileArm == null) continue;
                this.importToolOptions(fileArm.getAarm(), site, KeilExternalOptions.assemblerArmOptionGroup);
                this.importToolOptions(fileArm.getCarm(), site, KeilExternalOptions.compiler51OptionGroup);
                this.importVariousOptions(fileArm.getAarm() != null ? fileArm.getAarm().getVariousControls() : null, site, ImporterTool.ToolchainID.ARM, ImporterTool.ToolType.ASSEMBLER, ELanguage.ASM.toString());
                this.importVariousOptions(fileArm.getCarm() != null ? fileArm.getCarm().getVariousControls() : null, site, ImporterTool.ToolchainID.ARM, ImporterTool.ToolType.COMPILER, ProjectImportUtils.getELanguageString(ELanguage.C, ELanguage.CPP));
            }
            return site;
        }

        private void importCommonProperty(MConfiguration config, MSettingsSite site, MEntry entry, CommonPropertyType common) {
            if (common == null) {
                return;
            }
            if (common.getIncludeInBuild() == 0) {
                config.getExcludedPaths().add((Object)ProjectModelUtils.getProjectPathFor(entry).toString());
            }
            if (this.numBanks != null) {
                int bank;
                int n = bank = common.getBankNo() <= 1 ? 0 : common.getBankNo() - 1;
                if (bank < this.numBanks) {
                    this.bankMap.put(entry, bank);
                } else {
                    this.bankMap.put(entry, this.bankMap.get(entry.eContainer()));
                }
                if (entry instanceof MFileEntry) {
                    MSpecificOption banks = ConvertedOptionsUtils.findSpecificOption((MSettingsSite)config, (IProperty)KeilExternalOptions.BANKNO);
                    if (banks == null) {
                        String newBankValue = this.getProjectPath(entry) + ":=" + String.valueOf(this.bankMap.get(entry));
                        banks = ProjectModelFactory.eINSTANCE.createMSpecificOption();
                        config.getConvertedOptions().add((Object)banks);
                        banks.updateFrom(KeilExternalOptions.BANKNO, (Object)newBankValue);
                    } else {
                        String newBankValue = (String)banks.getValue() + ";" + this.getProjectPath(entry) + ":=" + String.valueOf(this.bankMap.get(entry));
                        banks.setValue((Object)newBankValue);
                    }
                }
            }
        }

        private void importVariousOptions(VariousControlsType target, MSettingsSite site, ImporterTool.ToolchainID toolchainID, ImporterTool.ToolType tooltype, String lang) {
            if (target == null) {
                return;
            }
            this.importIncludesOptions(site, target.getIncludePath(), lang);
            List<String> setOptions = this.importMiscOptions(site, target.getMiscControls(), toolchainID, tooltype, lang);
            if (toolchainID.equals((Object)ImporterTool.ToolchainID.EIGHTYFIFTYONE)) {
                if (tooltype == ImporterTool.ToolType.ASSEMBLER) {
                    KeilExternalProjectImporter.addOption(KeilExternalOptions.A51_UNDEFINE, target.getUndefine(), site);
                    setOptions.addAll(Arrays.asList(target.getDefine().split(",")));
                    KeilExternalProjectImporter.addOption(KeilExternalOptions.A51_SET, setOptions, site);
                } else if (tooltype == ImporterTool.ToolType.COMPILER) {
                    KeilExternalProjectImporter.addOption(KeilExternalOptions.C51_UNDEFINE, target.getUndefine(), site);
                    this.importMacroOptions(site, target.getDefine(), lang);
                }
            } else if (toolchainID.equals((Object)ImporterTool.ToolchainID.ARM)) {
                this.importMacroOptions(site, target.getDefine(), lang);
                if (tooltype == ImporterTool.ToolType.COMPILER) {
                    KeilExternalProjectImporter.addOption(KeilExternalOptions.CARM_UNDEFINE, target.getUndefine(), site);
                } else if (tooltype == ImporterTool.ToolType.ASSEMBLER) {
                    KeilExternalProjectImporter.addOption(KeilExternalOptions.AARM_UNDEFINE, target.getUndefine(), site);
                }
            }
        }

        private List<String> importMiscOptions(MSettingsSite site, String inputFlags, ImporterTool.ToolchainID toolchainID, ImporterTool.ToolType tooltype, String lang) {
            ArrayList<String> setList = new ArrayList<String>();
            if (inputFlags == null || inputFlags.trim().length() == 0) {
                return setList;
            }
            List<String> flags = KEIL_FLAG_PARSER.splitCommandLineFlags(inputFlags);
            List<MBuildSetting> build = KEIL_FLAG_PARSER.getBuildSettingsFromFlagList(flags, toolchainID, tooltype, this.model.getContentRootURI(), this.importDescr, null);
            for (MBuildSetting setting : build) {
                setting.setLanguageCompatibility(lang);
            }
            Map<IProperty, Object> finalFlags = KEIL_FLAG_PARSER.getFlagProperties(flags, toolchainID, tooltype);
            for (IProperty property : finalFlags.keySet()) {
                if (property == KeilExternalOptions.A51_SET) {
                    setList.addAll((Collection)finalFlags.get(property));
                    continue;
                }
                if (this.isMiscControls(property)) {
                    KeilExternalProjectImporter.appendOptionFlags(property, finalFlags.get(property), site);
                    continue;
                }
                KeilExternalProjectImporter.addOption(property, finalFlags.get(property), site);
            }
            ProjectImportUtils.addBuildSettingsToSettingsSite(site, build);
            return setList;
        }

        private boolean isMiscControls(IProperty property) {
            return property == KeilExternalOptions.A51_MISC_CONTROLS || property == KeilExternalOptions.C51_MISC_CONTROLS || property == KeilExternalOptions.L51_MISC_CONTROLS || property == KeilExternalOptions.LX51_MISC_CONTROLS;
        }

        private void importIncludesOptions(MSettingsSite site, String includePath, String lang) {
            if (includePath == null || includePath.length() == 0) {
                return;
            }
            ArrayList<MIncludePath> pathList = new ArrayList<MIncludePath>();
            String[] stringArray = includePath.split(",|;");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String rawPath = stringArray[n2];
                MIncludePath singlePath = ProjectImportUtils.createMIncludePathFromString(rawPath, this.model.getContentRootURI(), lang);
                pathList.add(singlePath);
                ++n2;
            }
            site.getIncludePaths().addAll(pathList);
        }

        private void importMacroOptions(MSettingsSite site, String macros, String lang) {
            String[] stringList;
            if (macros == null || macros.trim().length() == 0) {
                return;
            }
            macros = macros.trim();
            ArrayList<MMacroDefinition> macroDefs = new ArrayList<MMacroDefinition>();
            KeilProjectImporter.DebugPrint("Importing Macros\nInput: " + macros);
            macros = ProjectImportUtils.replaceOnlyOutsideQuotes(macros, "=", " =", "= ");
            KeilProjectImporter.DebugPrint("Remove Space on =: " + macros);
            macros = ProjectImportUtils.replaceOnlyOutsideQuotes(macros, " ", "  ");
            KeilProjectImporter.DebugPrint("Replace Whites: " + macros);
            macros = ProjectImportUtils.replaceOnlyOutsideQuotes(macros, Character.toString('\u0000'), " ");
            KeilProjectImporter.DebugPrint("Change Space for Comma: " + macros);
            String[] stringArray = stringList = ProjectImportUtils.splitStringOnlyOutsideQuotes(macros, Character.valueOf('\u0000'), Character.valueOf(','));
            int n = stringList.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                MMacroDefinition macro = ProjectImportUtils.createMMacroDefinitionFromString(s, lang);
                macroDefs.add(macro);
                ++n2;
            }
            for (MMacroDefinition i : macroDefs) {
                KeilProjectImporter.DebugPrint("Macro Name: " + i.getName() + "->" + i.getValue());
            }
            site.getMacroDefinitions().addAll(macroDefs);
        }

        private void importToolOptions(BaseExtensibleType ext, MSettingsSite site, IPropertyGroup group) {
            if (ext == null) {
                return;
            }
            KeilProjectImporter.DebugPrint("Importing Tool Options: " + group.getName());
            IProperty[] iPropertyArray = group.getProperties();
            int n = iPropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProperty property = iPropertyArray[n2];
                try {
                    KeilExternalProjectImporter.addOption(property, ext.getClass().getMethod("get" + property.getName(), new Class[0]).invoke((Object)ext, new Object[0]), site);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
                catch (Exception e) {
                    Activator.reporter.logError("Failed to map property " + property.getName(), (Throwable)e);
                }
                ++n2;
            }
        }

        private void importCommonOptions(TargetCommonOptionType ext, MSettingsSite site) {
            KeilExternalProjectImporter.addOption(KeilExternalOptions.DEBUG_INFORMATION, ext.getDebugInformation(), site);
        }

        protected static void DebugPrint(String s) {
        }

        private String getProjectPath(MEntry entry) {
            MFolderEntry parent = (MFolderEntry)entry.eContainer();
            if (entry instanceof MProject) {
                return "./";
            }
            if (entry instanceof MFileEntry) {
                return this.getProjectPath((MEntry)parent) + entry.getName().substring(0, entry.getName().indexOf(".")) + ".OBJ";
            }
            return this.getProjectPath((MEntry)parent) + entry.getName() + "/";
        }
    }
}

