/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core;

import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.IParentable;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.engine.IStockVariableAdapter;
import com.silabs.java.utils.variables.engine.IStockVariableFactory;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.ProjectCommonProperties;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.content.board.core.Board;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import com.silabs.ss.platform.api.sdk.core.SDK;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Version;

public class ProjectStockVariableFactory
implements IStockVariableFactory {
    public Object[] getSubObjects(Object obj) {
        ArrayList<Object> newObjList = new ArrayList<Object>();
        if (obj instanceof IBuildConfiguration) {
            obj = ((IBuildConfiguration)obj).getDescriptor();
        }
        if (obj instanceof IBuildConfigurationDescriptor) {
            this.getDescFromProp((Collection<Object>)newObjList, ((IDescriptor)obj).getProperty(ProjectCommonProperties.PART_ID), (IRegistry)Part.manager());
            this.getDescFromProp((Collection<Object>)newObjList, ((IDescriptor)obj).getProperty(ProjectCommonProperties.BOARD_IDS), (IRegistry)Board.manager());
            this.getDescFromProp((Collection<Object>)newObjList, ((IDescriptor)obj).getProperty(ProjectCommonProperties.SDK_ID), (IRegistry)SDK.manager());
            this.getDescFromProp((Collection<Object>)newObjList, ((IDescriptor)obj).getProperty(ProjectCommonProperties.TOOLCHAIN_ID), (IRegistry)Toolchain.manager());
            if (((IParentable)obj).getParent() instanceof IProjectDescriptor) {
                newObjList.add(((IParentable)obj).getParent());
            }
        } else if (obj instanceof IProjectEntity) {
            newObjList.add(((IProjectEntity)obj).getDescriptor());
        }
        return newObjList.toArray();
    }

    private <T extends IDescriptor> void getDescFromProp(Collection<Object> coll, Object descId, IRegistry<T> reg) {
        if (descId instanceof String) {
            this.doGetDesc(coll, reg, (String)descId);
        } else if (descId instanceof List) {
            ((List)descId).forEach(id -> this.getDescFromProp(coll, id, reg));
        } else {
            throw new IllegalStateException("Unsupported property type!");
        }
    }

    private <T extends IDescriptor> void doGetDesc(Collection<Object> coll, IRegistry<T> reg, String descId) {
        if (TextUtils.isEmpty((String)descId)) {
            return;
        }
        IDescriptor subDesc = reg.findCompatibleDescriptor(descId);
        if (subDesc == null) {
            return;
        }
        coll.add(subDesc);
    }

    public IStockVariableAdapter[] getAdapters(Object obj) {
        if (obj instanceof IBuildConfigurationDescriptor || obj instanceof IBuildConfiguration) {
            return new IStockVariableAdapter[]{new SavedPropertyStockVariableSupplier((IDescriptor)obj)};
        }
        if (obj instanceof IProjectDescriptor) {
            return new IStockVariableAdapter[]{new ProjectStockVariableSupplier((IProjectDescriptor)obj), new SavedPropertyStockVariableSupplier((IDescriptor)obj)};
        }
        return null;
    }

    public static class ProjectStockVariableSupplier
    implements IStockVariableAdapter {
        private static Pattern baseNamePattern = Pattern.compile(".*?([a-zA-Z0-9\\-]+).*");
        private final IProjectDescriptor project;

        public ProjectStockVariableSupplier(IProjectDescriptor project) {
            this.project = project;
        }

        public void setVariables(IVariableStore variables) {
            String location;
            URI projectLocation = this.project.getProjectDescriptionLocationURI();
            String projName = this.project.getName();
            projName = projName != null ? projName.trim() : "";
            variables.setValue("projectName", (Object)projName);
            String baseName = this.getBaseProjectName(projName);
            variables.setValue("projectBaseName", (Object)baseName);
            if (variables.getValue("sourceDir") == null) {
                variables.setValue("sourceDir", (Object)"src");
            }
            URI locationUri = null;
            if (projectLocation != null) {
                locationUri = projectLocation;
            } else if (this.project != null && this.project.getDefaultProjectLocation() != null) {
                locationUri = this.project.getDefaultProjectLocation().toFile().toURI();
            }
            String string = location = locationUri == null ? null : locationUri.toString();
            if (locationUri != null) {
                try {
                    IPath projPath = URIUtils.resolveURIToPath((URI)locationUri);
                    if (projPath.getFileExtension() != null || projPath.toFile().isFile()) {
                        location = projPath.removeLastSegments(1).toFile().toURI().toString();
                    }
                }
                catch (IOException iOException) {}
            }
            variables.setValue("projectLocation", (Object)location);
            String versionString = (String)variables.getValue("version");
            if (versionString != null) {
                try {
                    Version version = new Version(versionString);
                    variables.setValue("version.major", (Object)("" + version.getMajor()));
                    variables.setValue("version.minor", (Object)("" + version.getMinor()));
                    variables.setValue("version.micro", (Object)("" + version.getMicro()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            boolean isCopySources = this.determineProjectSourcesCopy();
            variables.setValue("isCopySources", (Object)isCopySources);
        }

        private boolean determineProjectSourcesCopy() {
            String sourceCopyOrLinked;
            Object sourceCopyOrLinkedRaw = this.project.getProperty(ProjectProperties.IMPORT_MODE_ID);
            String string = sourceCopyOrLinked = sourceCopyOrLinkedRaw != null ? sourceCopyOrLinkedRaw.toString() : "";
            if (!TextUtils.isEmpty((String)sourceCopyOrLinked)) {
                try {
                    ImportMode mode = ImportMode.valueOf(sourceCopyOrLinked);
                    switch (mode) {
                        case COPY: {
                            return true;
                        }
                        case LINK: 
                        case LINK_LIBRARIES: 
                        case LINK_PROJECT: 
                        case IN_PLACE: {
                            return false;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String message = "Cannot accurately set isCopySources on " + this.project.getName() + " unknown import mode " + sourceCopyOrLinked + ". Defaulting to Linked sources.";
                    Activator.reporter.logError(message, (Throwable)ExceptionUtils.newMinimalStackException());
                    return false;
                }
                assert (false) : "constructed from valueOf; this should be impossible";
                return false;
            }
            return false;
        }

        public String getBaseProjectName(String name) {
            Matcher matcher;
            if (name != null && (matcher = baseNamePattern.matcher(name)).matches()) {
                return matcher.group(1);
            }
            return "project";
        }
    }

    public static class SavedPropertyStockVariableSupplier
    implements IStockVariableAdapter {
        private final IDescriptor desc;

        public SavedPropertyStockVariableSupplier(IDescriptor desc) {
            this.desc = desc;
        }

        public void setVariables(IVariableStore variables) {
            if (this.desc == null) {
                return;
            }
            Object varMap = this.desc.getProperty(ProjectProperties.SAVED_STOCK_VARIABLES);
            if (varMap instanceof Map) {
                ((Map)varMap).entrySet().stream().filter(e -> variables.getValue((String)e.getKey()) == null).forEachOrdered(e -> variables.setValue((String)e.getKey(), e.getValue()));
            }
        }
    }
}

