/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.google.common.collect.ImmutableMap;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.AddIncludePathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryFileSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryPathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddMacroDefinitionSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddToolOptionOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.BaseLanguageAwareProjectSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectLanguageSettingOperation;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProjectEngineOperationHolder {
    private Map<String, IProjectEngineOperation> operations = new LinkedHashMap<String, IProjectEngineOperation>();
    private int count = 0;

    public List<IProjectEngineOperation> toOperations() {
        return this.operations.values().stream().distinct().collect(Collectors.toList());
    }

    public void forEach(Consumer<IProjectEngineOperation> cons) {
        this.operations.values().forEach(cons);
    }

    public Stream<IProjectEngineOperation> stream() {
        return this.operations.values().stream();
    }

    public void add(IProjectEngineOperation op) {
        Map<ELanguage, String> ids = this.getOperationKey(op);
        for (Map.Entry<ELanguage, String> entry : ids.entrySet()) {
            String id = entry.getValue();
            IProjectEngineOperation oldOp = this.operations.get(id);
            if (oldOp instanceof IProjectLanguageSettingOperation && op instanceof IProjectLanguageSettingOperation) {
                IProjectLanguageSettingOperation newSet = (IProjectLanguageSettingOperation)op;
                IProjectLanguageSettingOperation oldSet = (IProjectLanguageSettingOperation)oldOp;
                if (newSet.isBuiltin() && !oldSet.isBuiltin()) {
                    this.removeCompatibility(entry.getKey(), op);
                    continue;
                }
            }
            this.removeCompatibility(entry.getKey(), oldOp);
            this.operations.put(id, op);
        }
    }

    private void removeCompatibility(ELanguage lang, IProjectEngineOperation operation) {
        if (!(operation instanceof BaseLanguageAwareProjectSettingOperation)) {
            return;
        }
        BaseLanguageAwareProjectSettingOperation oldSet = (BaseLanguageAwareProjectSettingOperation)operation;
        String newLanguages = ProjectModelUtils.getLanguagesFor(oldSet).stream().filter(l -> l != lang).map(Object::toString).collect(Collectors.joining(" "));
        oldSet.updateLanguageCompatibility(newLanguages);
    }

    private Map<ELanguage, String> getOperationKey(IProjectEngineOperation op) {
        if (!(op instanceof IProjectLanguageSettingOperation)) {
            return ImmutableMap.of((Object)ELanguage.C, (Object)(op.toString() + this.count++));
        }
        IProjectLanguageSettingOperation set = (IProjectLanguageSettingOperation)op;
        StringBuilder sb = new StringBuilder().append(set.getBuildConfiguration()).append(":").append(set.getProjectPath()).append(":");
        if (op instanceof AddIncludePathSettingOperation) {
            sb.append(((AddIncludePathSettingOperation)op).getUri());
        } else if (op instanceof AddMacroDefinitionSettingOperation) {
            sb.append(((AddMacroDefinitionSettingOperation)op).getName());
        } else if (op instanceof AddLibraryFileSettingOperation) {
            sb.append(((AddLibraryFileSettingOperation)op).getLibraryName()).append(":").append(((AddLibraryFileSettingOperation)op).getLibraryURI());
        } else if (op instanceof AddLibraryPathSettingOperation) {
            sb.append(((AddLibraryPathSettingOperation)op).getLibraryURI());
        } else if (op instanceof AddToolOptionOperation) {
            sb.append(((AddToolOptionOperation)op).getToolId()).append(":").append(((AddToolOptionOperation)op).getOptionId()).append(":").append(Arrays.toString(((AddToolOptionOperation)op).getListValues()));
        } else {
            throw new IllegalArgumentException("Operation not support for " + op.toString());
        }
        String baseSettingId = sb.toString();
        return ProjectModelUtils.getLanguagesFor(set).stream().collect(Collectors.toMap(l -> l, l -> baseSettingId + ":" + l.toString()));
    }
}

