/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.ObjectUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.MapVariableLookup;
import com.silabs.java.utils.variables.NullVariableLookup;
import com.silabs.java.utils.variables.engine.CoreOperatorHandler;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.StockVariables;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectFileContentVisitor;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelContentVisitor;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.StudioURLConverter;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MProjectResourceTree;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.URI;

public class ProjectModel
implements IProjectModel {
    private final MProject model;
    private final IVariableLookup lookup;
    private final VariableSubstitutionEngine substEngine = new VariableSubstitutionEngine('(');
    private String prevContentRoot;
    private java.net.URI contentRootURI;
    private MProjectResourceTree projectResourceTree;
    private IProjectModel rawModel;

    public ProjectModel(MProject model, IVariableLookup lookup) {
        this.model = model;
        this.lookup = lookup != null ? lookup : NullVariableLookup.INSTANCE;
        this.substEngine.allowRecursion(true);
        this.substEngine.setOperatorHandler((IOperatorHandler)CoreOperatorHandler.INSTANCE);
    }

    public ProjectModel(MProject model, IVariableLookup lookup, java.net.URI contentRootURI, MProjectResourceTree projectResourceTree) {
        this(model, lookup);
        this.contentRootURI = contentRootURI;
        this.projectResourceTree = projectResourceTree;
        this.prevContentRoot = model.getContentRoot();
    }

    @Override
    public MProject getModel() {
        return this.model;
    }

    @Override
    public IVariableLookup getVariableLookup() {
        return this.lookup;
    }

    @Override
    public MProjectResourceTree getProjectResourceTree() {
        return this.projectResourceTree;
    }

    @Override
    public String wrapReference(String var) {
        return this.substEngine.wrapVariable(var);
    }

    @Override
    public java.net.URI resolveURI(MEntry container, java.net.URI containerURI, MEntry entry) {
        Object suffix;
        java.net.URI entryParentURI;
        if (entry == null || container != null && container.equals(entry)) {
            return containerURI;
        }
        java.net.URI uRI = entryParentURI = container != null ? this.resolveURI(container, containerURI, (MEntry)entry.eContainer()) : null;
        if (entry instanceof MContent) {
            String contentURI = ((MContent)entry).getUri();
            suffix = contentURI == null ? this.resolveString(entry.getName()) : this.resolveString(contentURI.toString());
        } else if (entry.getName() != null) {
            suffix = this.resolveString(entry.getName());
        } else {
            return entryParentURI;
        }
        if (entry instanceof MFolderEntry && !((String)suffix).endsWith("/")) {
            suffix = (String)suffix + "/";
        }
        if (entryParentURI != null) {
            return URIUtil.append((java.net.URI)entryParentURI, (String)suffix);
        }
        return java.net.URI.create((String)suffix);
    }

    public File resolveFile(MEntry container, File containerFile, MEntry entry) {
        File resolved;
        if (entry == null || Objects.equals(container, entry) || entry instanceof MProject) {
            return containerFile;
        }
        if (entry instanceof MFolderContent && ((MFolderContent)entry).isVirtual()) {
            return containerFile;
        }
        File entryParentFile = this.resolveFile(container, containerFile, (MEntry)entry.eContainer());
        if (entry instanceof MContent) {
            File contentFile;
            if (((MContent)entry).getUri() == null) {
                Object suffix = this.resolveString(entry.getName());
                if (entry instanceof MFolderContent) {
                    suffix = (String)suffix + "/";
                }
                contentFile = new File(entryParentFile, (String)suffix);
            } else {
                java.net.URI entUri = this.doResolveURIFrom(URIUtils.toDirectoryURI((java.net.URI)entryParentFile.toURI()), ((MContent)entry).getUri(), entry instanceof MFolderContent);
                entUri = this.resolveAbsoluteUri(entUri);
                try {
                    IPath path = URIUtils.resolveURIToPath((java.net.URI)entUri);
                    contentFile = path.toFile();
                }
                catch (FileNotFoundException e) {
                    Activator.reporter.logException((Throwable)e);
                    return new File("");
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to resolve " + String.valueOf(entUri), e);
                }
            }
            resolved = contentFile;
        } else if (entry instanceof MProject) {
            resolved = entryParentFile;
        } else if (entry.getName() != null) {
            File file;
            Object segment = this.resolveString(entry.getName());
            if (entry instanceof MFolderEntry) {
                segment = (String)segment + "/";
            }
            resolved = file = new File(entryParentFile, (String)segment);
        } else {
            resolved = entryParentFile;
        }
        resolved = new Path(resolved.getAbsolutePath()).toFile();
        return resolved;
    }

    @Override
    public String resolveString(String string) {
        if (string == null) {
            return null;
        }
        if (this.lookup instanceof NullVariableLookup) {
            return string;
        }
        String res = this.substEngine.substitute(string, this.lookup);
        return res;
    }

    @Override
    public java.net.URI resolveURI(java.net.URI uri, boolean isWorkspaceRelative, boolean isDirectory) {
        return this.doResolveURIFrom(isWorkspaceRelative ? java.net.URI.create("studio:/project/") : this.getContentRootURI(), uri, isDirectory);
    }

    @Override
    public java.net.URI resolveURI(String uriStr, boolean isDirectory) {
        return this.doResolveURIFrom(this.getContentRootURI(), uriStr, isDirectory);
    }

    @Override
    public void setContentRootURI(java.net.URI contentRoot) {
        this.contentRootURI = contentRoot != null ? URIUtils.toDirectoryURI((java.net.URI)contentRoot) : null;
        this.prevContentRoot = this.model.getContentRoot();
    }

    @Override
    public java.net.URI getContentRootURI() {
        if (!ObjectUtils.equals((Object)this.model.getContentRoot(), (Object)this.prevContentRoot)) {
            this.contentRootURI = null;
        }
        if (this.contentRootURI != null) {
            return this.contentRootURI;
        }
        try {
            this.prevContentRoot = this.model.getContentRoot();
            Object dirContentRoot = this.model.getContentRoot();
            if (dirContentRoot == null) {
                dirContentRoot = "./";
            }
            if (!((String)(dirContentRoot = this.resolveString((String)dirContentRoot))).endsWith("/")) {
                dirContentRoot = (String)dirContentRoot + "/";
            }
            java.net.URI contentRoot = new java.net.URI((String)dirContentRoot);
            if (this.model.eResource() == null || contentRoot.isAbsolute()) {
                this.contentRootURI = contentRoot;
                return this.contentRootURI;
            }
            URI eUri = this.model.eResource().getURI();
            if (eUri != null && !eUri.hasTrailingPathSeparator()) {
                eUri = eUri.trimSegments(1);
            }
            java.net.URI modelRoot = eUri != null && !eUri.isEmpty() ? new java.net.URI(eUri.toString()) : new java.net.URI("./");
            this.contentRootURI = URIUtil.append((java.net.URI)modelRoot, (String)dirContentRoot);
            return this.contentRootURI;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("could not form content root URI", e);
        }
    }

    private java.net.URI doResolveURIFrom(java.net.URI base, java.net.URI uri, boolean isDirectory) {
        String uriStr = uri.toString();
        return this.doResolveURIFrom(base, uriStr, isDirectory);
    }

    private java.net.URI resolveAbsoluteUri(java.net.URI entUri) {
        if (entUri == null) {
            return null;
        }
        String entStr = StudioURLConverter.convertToVariable(entUri.toString());
        entStr = this.resolveString(entStr);
        return URIUtils.createAbsoluteURI((String)entStr);
    }

    private java.net.URI doResolveURIFrom(java.net.URI base, String uriStr_, boolean isDirectory) {
        Object uriStr = uriStr_;
        java.net.URI uri = null;
        if (uriStr == null) {
            return null;
        }
        if (((String)uriStr).contains("$" + this.substEngine.getVariableToken())) {
            String expStr = this.resolveString((String)uriStr);
            expStr = expStr.replace('\\', '/');
            uriStr = expStr;
        }
        if (isDirectory && !((String)uriStr).endsWith("/")) {
            uriStr = (String)uriStr + "/";
        }
        try {
            if (base != null) {
                uri = URIUtils.createAbsoluteURI((String)uriStr);
                uri = URIUtils.resolveURIFrom((java.net.URI)base, (java.net.URI)uri);
                uriStr = uri.toString();
            }
            if (!(uri = URIUtils.createAbsoluteURI((String)(uriStr = ProjectModelUtils.getProjectModelURI(this, null, null, (String)uriStr, false)))).isAbsolute()) {
                uri = java.net.URI.create("studio:/project/" + (String)uriStr);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    @Override
    public java.net.URI encodeProjectURI(java.net.URI uri) {
        if (uri == null) {
            return uri;
        }
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            String uriStr = uri.toString();
            uriStr = this.replaceVariables(uriStr);
            return java.net.URI.create(uriStr);
        }
        return uri;
    }

    private String replaceVariables(String uriStr) {
        String tcInstallPath;
        String sdkInstallPath;
        String emptyPathStr = new File("").toURI().toString();
        if (!Objects.equals(emptyPathStr, sdkInstallPath = String.valueOf(this.getVariableLookup().getValue("sdkInstallationPath")))) {
            uriStr = ProjectModelUtils.replaceUriWithStudioVariable(uriStr, sdkInstallPath, "sdk");
        }
        if (!Objects.equals(emptyPathStr, tcInstallPath = String.valueOf(this.getVariableLookup().getValue("toolchainInstallationPath")))) {
            uriStr = ProjectModelUtils.replaceUriWithStudioVariable(uriStr, tcInstallPath, "toolchain");
        }
        return uriStr;
    }

    @Override
    public String resolveOutputBaseFilename(String outputPattern, IBuildConfigurationDescriptor buildConfig) {
        MapVariableLookup newLookup = new MapVariableLookup();
        StockVariables.INSTANCE.setVariables((IVariableStore)newLookup, (Object)buildConfig);
        IVariableLookup configLookup = new IVariableLookup((IVariableStore)newLookup){
            private final /* synthetic */ IVariableStore val$newLookup;
            {
                this.val$newLookup = iVariableStore;
            }

            public Object getValue(String var) {
                Object val = this.val$newLookup.getValue(var);
                if (val == null) {
                    val = ProjectModel.this.lookup.getValue(var);
                }
                return val;
            }

            public Collection<String> getVariableNames() {
                ArrayList<String> all = new ArrayList<String>(this.val$newLookup.getVariableNames());
                all.addAll(ProjectModel.this.lookup.getVariableNames());
                return all;
            }
        };
        String resPath = this.substEngine.substitute(outputPattern, configLookup);
        return resPath;
    }

    @Override
    public void accept(IProjectModelContentVisitor visitor) {
        this.doVisitModelContent(null, (MEntry)this.model, visitor);
    }

    private boolean doVisitModelContent(MFolderEntry parent, MEntry entry, IProjectModelContentVisitor visitor) {
        if (entry instanceof MFolderEntry && !(entry instanceof MProject) && !visitor.preVisit(parent, (MFolderEntry)entry)) {
            return false;
        }
        if (entry instanceof MFileEntry) {
            visitor.visit(parent, (MFileEntry)entry);
        }
        boolean retValue = true;
        try {
            if (entry instanceof MFolderEntry) {
                MFolderEntry folderEntry = (MFolderEntry)entry;
                for (MEntry subEntry : folderEntry.getFolders()) {
                    this.doVisitModelContent(folderEntry, subEntry, visitor);
                }
                for (MEntry subEntry : folderEntry.getFiles()) {
                    this.doVisitModelContent(folderEntry, subEntry, visitor);
                }
            }
        }
        finally {
            if (entry instanceof MFolderEntry && !(entry instanceof MProject) && !visitor.postVisit((MEntry)parent, (MFolderEntry)entry)) {
                retValue = false;
            }
        }
        return retValue;
    }

    @Override
    public void accept(final IProjectFileContentVisitor visitor) {
        File rootFile;
        java.net.URI projectRootURI = this.getContentRootURI();
        try {
            rootFile = URIUtils.toFileWithRelative((java.net.URI)projectRootURI);
        }
        catch (IOException e) {
            visitor.visitFailed(null, null, null, null, null, null, e);
            return;
        }
        this.accept(new IProjectModelContentVisitor(rootFile){
            Deque<File> fsFileStack = new ArrayDeque<File>();
            Deque<IPath> fsPathStack = new ArrayDeque<IPath>();
            {
                this.fsFileStack.push(file);
                this.fsPathStack.push((IPath)Path.EMPTY);
            }

            @Override
            public boolean preVisit(MFolderEntry parent, MFolderEntry entry) {
                File fsDir = entry instanceof MFolderContent ? ProjectModel.this.resolveFile((MEntry)parent, this.fsFileStack.peek(), (MEntry)entry) : this.fsFileStack.peek();
                IPath projectPath = this.fsPathStack.peek().append(ProjectModel.this.resolveString(entry.getName())).addTrailingSeparator();
                if (entry instanceof MFolderContent && !((MFolderContent)entry).isLinked() && (((MFolderContent)entry).isIncludeAllFiles() || ((MFolderContent)entry).isIncludeAllFolders()) && !fsDir.isDirectory()) {
                    visitor.visitFailed(parent, this.fsFileStack.peek(), projectPath, (MEntry)entry, (MSelectable)entry, fsDir, new IOException("did not find directory for " + entry.getName() + " in " + String.valueOf(fsDir)));
                    return false;
                }
                if (!visitor.preVisit(entry, this.fsFileStack.peek(), projectPath, (MSelectable)entry, fsDir)) {
                    return false;
                }
                this.fsFileStack.push(fsDir);
                this.fsPathStack.push(projectPath);
                if (entry instanceof MContent && !((MContent)entry).isLinked()) {
                    return this.doVisitFolderContent(parent, projectPath, (MFolderContent)entry, fsDir);
                }
                return true;
            }

            @Override
            public void visit(MFolderEntry parent, MFileEntry entry) {
                File fsFile = ProjectModel.this.resolveFile((MEntry)parent, this.fsFileStack.peek(), (MEntry)entry);
                IPath projectPath = this.fsPathStack.peek().append(ProjectModel.this.resolveString(entry.getName()));
                if (entry instanceof MFileContent && !((MFileContent)entry).isLinked() && fsFile.isDirectory()) {
                    visitor.visitFailed(parent, this.fsFileStack.peek(), projectPath, (MEntry)entry, (MSelectable)entry, fsFile, new IOException("expected a file, found a directory for " + entry.getName() + " in " + String.valueOf(fsFile)));
                    return;
                }
                visitor.visit(parent, this.fsFileStack.peek(), projectPath, entry, (MSelectable)entry, fsFile);
            }

            private boolean doVisitFolderContent(MFolderEntry parent, IPath projectPath, MFolderContent folder, File fsDir) {
                String entryName;
                if (!fsDir.isDirectory() && (folder.isIncludeAllFiles() || folder.isIncludeAllFolders())) {
                    visitor.visitFailed(parent, this.fsFileStack.peek(), projectPath, (MEntry)folder, (MSelectable)folder, fsDir, new IOException("expected a directory, found a file for " + folder.getName() + " in " + String.valueOf(fsDir)));
                    return false;
                }
                HashSet<String> folderEntryNames = new HashSet<String>();
                for (MEntry entry : folder.getFolders()) {
                    entryName = ProjectModel.this.resolveString(entry.getName());
                    folderEntryNames.add(entryName);
                }
                for (MEntry entry : folder.getFiles()) {
                    entryName = ProjectModel.this.resolveString(entry.getName());
                    folderEntryNames.add(entryName);
                }
                LinkedHashMap matchedEntries = new LinkedHashMap();
                Function<File, BasicFileAttributes> attFunc = f -> {
                    try {
                        return Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                };
                if (folder.isIncludeAllFolders() || folder.isIncludeAllFiles()) {
                    File[] fsEntries = fsDir.listFiles();
                    if (fsEntries == null) {
                        visitor.visitFailed(parent, this.fsFileStack.peek(), projectPath, (MEntry)folder, (MSelectable)folder, fsDir, new IOException("could not read directory for " + folder.getName() + " in " + String.valueOf(fsDir)));
                        return false;
                    }
                    Map<File, BasicFileAttributes> fsEntryAttrs = ((Stream)Stream.of(fsEntries).parallel()).collect(Collectors.toMap(f -> f, attFunc));
                    for (Map.Entry<File, BasicFileAttributes> fsEntry : fsEntryAttrs.entrySet()) {
                        if (folderEntryNames.contains(fsEntry.getKey().getName())) continue;
                        if (folder.isIncludeAllFolders() && fsEntry.getValue().isDirectory()) {
                            matchedEntries.put(fsEntry.getKey(), null);
                            continue;
                        }
                        if (!folder.isIncludeAllFiles() || !fsEntry.getValue().isRegularFile()) continue;
                        matchedEntries.put(fsEntry.getKey(), null);
                    }
                }
                for (Map.Entry entry : matchedEntries.entrySet()) {
                    IPath entPath;
                    if (((File)entry.getKey()).isDirectory()) {
                        entPath = projectPath.append(((File)entry.getKey()).getName()).addTrailingSeparator();
                        if (!visitor.preVisit((MFolderEntry)folder, fsDir, entPath, (MSelectable)entry.getValue(), (File)entry.getKey())) continue;
                        try {
                            this.doVisitFolderRecursively(folder, entPath, fsDir, (File)entry.getKey());
                            continue;
                        }
                        finally {
                            visitor.postVisit((MFolderEntry)folder, entPath, (File)entry.getKey());
                        }
                    }
                    entPath = projectPath.append(((File)entry.getKey()).getName());
                    visitor.visit((MFolderEntry)folder, fsDir, entPath, null, (MSelectable)entry.getValue(), (File)entry.getKey());
                }
                return true;
            }

            private boolean doVisitFolderRecursively(MFolderContent container, IPath projectPath, File containerFile, File fsDir) {
                File[] fsEntries = fsDir.listFiles();
                if (fsEntries == null) {
                    return false;
                }
                File[] fileArray = fsEntries;
                int n = fsEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        entPath = projectPath.append(file.getName()).addTrailingSeparator();
                        if (visitor.preVisit((MFolderEntry)container, containerFile, entPath, null, file)) {
                            try {
                                this.doVisitFolderRecursively(container, entPath, containerFile, file);
                            }
                            finally {
                                visitor.postVisit((MFolderEntry)container, entPath, file);
                            }
                        }
                    } else {
                        entPath = projectPath.append(file.getName());
                        visitor.visit((MFolderEntry)container, containerFile, entPath, null, null, file);
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            public boolean postVisit(MEntry parent, MFolderEntry entry) {
                visitor.postVisit(entry, this.fsPathStack.peek(), this.fsFileStack.peek());
                this.fsFileStack.pop();
                this.fsPathStack.pop();
                return true;
            }
        });
    }

    public void setReportNullWarning(boolean report) {
        if (!report) {
            this.substEngine.setListener((code, message, cause) -> {
                if (code != VariableSubstitutionEngine.CODE_NULL_VARIABLE) {
                    Activator.reporter.log((IStatus)new Status(4, Activator.id(), code, message, cause));
                }
            });
        } else {
            this.substEngine.setListener(null);
        }
    }

    public void setRawModel(IProjectModel rawModel) {
        this.rawModel = rawModel;
    }

    @Override
    public IProjectModel getRawModel() {
        return this.rawModel;
    }
}

