/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.utils.ProjectCompatUtils;
import com.silabs.ss.platform.api.descriptor.core.hardware.IHardwareContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProjectModelCompatibility {
    private Map<IBuildConfigurationDescriptor, ConcurrentHashMap<MSelectable, Boolean>> configCache = new ConcurrentHashMap<IBuildConfigurationDescriptor, ConcurrentHashMap<MSelectable, Boolean>>();
    private Map<IBuildConfigurationDescriptor, IHardwareContext> contextCache = new ConcurrentHashMap<IBuildConfigurationDescriptor, IHardwareContext>();

    public ProjectModelCompatibility(IProjectModel model) {
    }

    public List<IBuildConfigurationDescriptor> calculateContentExclusion(IProjectDescriptor projectDesc, MSelectable selector) {
        List<IBuildConfigurationDescriptor> exclCfgs;
        IBuildConfigurationDescriptor[] configs = projectDesc.getBuildConfigurationDescriptors();
        if (configs.length == (exclCfgs = ((Stream)Stream.of(configs).parallel()).filter(config -> !this.isCompatibleForConfig(selector, (IBuildConfigurationDescriptor)config)).collect(Collectors.toList())).size()) {
            return null;
        }
        return exclCfgs;
    }

    public boolean isCompatibleForConfig(MSelectable selectable, IBuildConfigurationDescriptor config) {
        if (selectable == null) {
            return true;
        }
        if (selectable instanceof MProject) {
            return true;
        }
        if (!ProjectCompatUtils.hasCompatibility(selectable)) {
            return true;
        }
        ConcurrentHashMap selectableCompatMap = this.configCache.computeIfAbsent(config, k -> new ConcurrentHashMap());
        return selectableCompatMap.computeIfAbsent(selectable, k -> {
            IHardwareContext context = this.contextCache.computeIfAbsent(config, ProjectCompatUtils::getHardwareContext);
            return ProjectCompatUtils.isCompatible(context, selectable);
        });
    }
}

