/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.ChainedVariableLookup;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.MapVariableLookup;
import com.silabs.java.utils.variables.engine.StockVariables;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.MProjectCanonicalizer;
import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.engine.IProjectFileContentVisitor;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MCustomization;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MExclusion;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFileReference;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderReference;
import com.silabs.ss.framework.project.api.core.model.MInclusion;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MProjectReference;
import com.silabs.ss.framework.project.api.core.model.MProjectResourceTree;
import com.silabs.ss.framework.project.api.core.model.MReference;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.util.ProjectModelSwitch;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelSwitchRecurser;
import com.silabs.ss.framework.project.api.core.utils.ProjectModelObjFactory;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModel;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelCompatibility;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelMergeUtils;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModuleAccessor;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModuleExclusionHandler;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModuleHandlerUtils;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModuleUpdateUtils;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;

public class ProjectModelModuleHandler {
    private static boolean DEBUG = false;
    private IProjectModel userModel;
    private IProjectModel rawModel;
    private MProject expanded;
    private IProjectDescriptor projDesc;
    private ProjectModelCompatibility compat;
    private Map<Object, IPath> entryPaths = new HashMap<Object, IPath>();
    private Map<IBuildConfigurationDescriptor, MConfiguration> configMap;
    private MultiStatus multiStatus = new MultiStatus(Activator.id(), 0, "Problems applying modules", null);
    private MProjectResourceTree rsrcTree;
    private ProjectModuleAccessor modAccess;
    private ProjectModuleExclusionHandler exclHandler;
    private Collection<Runnable> moduleExclusions;
    private static Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    public ProjectModelModuleHandler(IProjectModel userModel, IProjectModel rawModel, IProjectDescriptor projDesc) {
        this.userModel = userModel;
        this.rawModel = rawModel;
        this.projDesc = projDesc;
        this.compat = new ProjectModelCompatibility(userModel);
    }

    public MProject getExpandedModel() {
        return this.expanded;
    }

    public MProjectResourceTree getProjectResourceTree() {
        return this.rsrcTree;
    }

    public Collection<IPath> getRemovedFiles() {
        return this.exclHandler.getRemovedFiles();
    }

    public Collection<IPath> getRemovedFolders() {
        return this.exclHandler.getRemovedFolders();
    }

    public Collection<IModuleReference> getVisitedModules(IDescriptor desc) {
        return this.modAccess.getVisitedModules(desc, this.exclHandler.getBuiltinSources(), this.exclHandler.getBuiltinExcludes());
    }

    public MultiStatus getStatus() {
        return this.multiStatus;
    }

    public void apply() {
        this.expanded = this.userModel.getModel().copy();
        this.moduleExclusions = new ArrayList<Runnable>();
        this.modAccess = new ProjectModuleAccessor(this.projDesc, this.userModel, this.multiStatus);
        if (!this.modAccess.isValid()) {
            return;
        }
        this.configMap = ProjectModuleHandlerUtils.createBConfToMConfMap(this.projDesc, this.expanded);
        new MProjectCanonicalizer(this.userModel, this.projDesc, false).doSwitch((EObject)this.expanded);
        ProjectModuleHandlerUtils.mergeDuplicateFolders((MFolderEntry)this.expanded);
        ProjectModuleExclusionHandler.standardizeExclusions(this.expanded);
        this.rsrcTree = ProjectModuleUpdateUtils.createProjectResourceTree(this.expanded, this.userModel.getVariableLookup(), this.userModel.getProjectResourceTree());
        ProjectModelMergeUtils.moveSettingsIntoConfigs(this.expanded);
        this.exclHandler = new ProjectModuleExclusionHandler(this.userModel, this.expanded, this.configMap, this.rsrcTree);
        this.updateRemovedModules();
        this.mergeModules();
        this.manageToolOptions();
    }

    private void manageToolOptions() {
        if (this.userModel.getRawModel() == null) {
            return;
        }
        new ProjectModelSwitchRecurser<Object>(){

            public Object caseMToolOption(MToolOption opt) {
                if (opt.getToolListOptions().isEmpty()) {
                    return null;
                }
                EObject parentObj = opt.eContainer();
                MProject userParent = null;
                if (parentObj instanceof MProject) {
                    userParent = ProjectModelModuleHandler.this.expanded;
                } else if (parentObj instanceof MConfiguration) {
                    userParent = ProjectModelModuleHandler.this.expanded.findConfigurationByName(((MConfiguration)parentObj).getName());
                } else {
                    Activator.reporter.logError("Unknown MToolOption parent type " + String.valueOf(parentObj.getClass()), (Throwable)ExceptionUtils.newMinimalStackException());
                    return null;
                }
                if (userParent == null) {
                    return null;
                }
                ProjectModelObjFactory.forMToolOption(opt.getToolId(), opt.getOptionId()).findOrApply((MSettingsSite)userParent);
                return null;
            }
        }.doSwitch((EObject)this.userModel.getRawModel().getModel());
    }

    protected MProject mergeModules() {
        boolean changed;
        while (changed = this.applyModules()) {
        }
        this.exclHandler.finalizeExclusions(this.modAccess, this.rawModel != null ? this.rawModel.getProjectResourceTree() : this.userModel.getProjectResourceTree());
        this.expanded.getProjectDefinedModules().removeIf(p -> !this.modAccess.getVisitedPdmIds().contains(p.getPdmId()));
        this.moduleExclusions.forEach(Runnable::run);
        if (DEBUG) {
            try {
                ProjectModuleHandlerUtils.dumpExpandedProject(this.expanded, this.rsrcTree, this.multiStatus);
            }
            catch (CoreException coreException) {}
        }
        return this.expanded;
    }

    protected boolean applyModules() {
        boolean changed = false;
        Map<Pair<String, MModule>, Set<IBuildConfigurationDescriptor>> moduleConfigMap = ProjectModuleHandlerUtils.buildModuleToConfigMap(this.userModel, this.expanded, this.configMap);
        for (Map.Entry<Pair<String, MModule>, Set<IBuildConfigurationDescriptor>> mcmEnt : moduleConfigMap.entrySet()) {
            Pair<String, MModule> minfo = mcmEnt.getKey();
            for (IBuildConfigurationDescriptor buildConf : mcmEnt.getValue()) {
                changed |= this.applyModuleToConfig(buildConf, (String)minfo.first, (MModule)minfo.second, true);
            }
        }
        return changed |= this.exclHandler.cleanModuleSources(this.projDesc, moduleConfigMap);
    }

    protected boolean applyModuleToConfig(IBuildConfigurationDescriptor bconf, String moduleId, MModule mmodule, boolean moduleInConfig) {
        IProjectModel clientModel = this.modAccess.getClientModule(bconf, moduleId, mmodule);
        if (clientModel == null) {
            return false;
        }
        String moduleKey = ProjectModuleAccessor.getModuleKey((IDescriptor)bconf, mmodule);
        Set<String> builtinSources = this.exclHandler.getSourcesFor(moduleKey);
        Set<String> builtinExcludes = this.exclHandler.getExcludesFor(moduleKey);
        IVariableStore confLookup = this.createConfigVariableLookup(bconf, clientModel);
        IProjectModel configModel = this.createConfigModel(this.userModel, this.expanded, confLookup, false);
        IProjectModel clientConfigModel = this.createConfigModel(clientModel, null, confLookup, true);
        this.canonicalizeModel(clientConfigModel, bconf);
        this.mergeModuleSources(bconf, configModel, clientConfigModel, mmodule, builtinSources, builtinExcludes);
        MProjectReference projRef = (MProjectReference)this.rsrcTree.getConfigurations().get((Object)bconf.getName());
        if (moduleInConfig) {
            this.mergeResourceReferences(bconf, mmodule, builtinSources, (MFolderEntry)this.expanded, (MFolderReference)projRef, projRef.getEntryToReferenceMap());
        } else {
            for (String path : builtinSources) {
                MReference ref = ProjectModelUtils.findReference((MFolderReference)projRef, (IPath)new Path(path));
                if (ref == null) {
                    CoreException except = Activator.reporter.newCoreException("Reference was null for path " + path);
                    this.multiStatus.add(except.getStatus());
                    Activator.reporter.logException((Throwable)except);
                    continue;
                }
                ref.setExcluded(true);
            }
        }
        MProject clientConfigProj = clientConfigModel.getModel();
        builtinExcludes.addAll((Collection<String>)clientConfigProj.getExcludedPaths());
        try {
            MConfiguration config = ProjectModuleHandlerUtils.mergeConfig(this.expanded, bconf, clientConfigProj);
            this.moduleExclusions.add(() -> {
                boolean bl = config.getExcludedPaths().addAll((Collection)clientConfigProj.getExcludedPaths());
            });
        }
        catch (CoreException e) {
            this.multiStatus.add(e.getStatus());
        }
        MConfiguration clientConf = ProjectModuleHandlerUtils.findMatchingStockConfig(clientConfigProj, bconf);
        if (clientConf != null) {
            try {
                ProjectModuleHandlerUtils.mergeConfig(this.expanded, bconf, clientConf);
            }
            catch (CoreException e) {
                this.multiStatus.add(e.getStatus());
            }
        }
        return true;
    }

    private IVariableStore createConfigVariableLookup(IBuildConfigurationDescriptor bconf, IProjectModel clientModel) {
        MapVariableLookup confLookup = new MapVariableLookup();
        StockVariables.INSTANCE.setVariables((IVariableStore)confLookup, (Object)(bconf != null ? bconf : this.configMap.keySet().iterator().next()));
        return confLookup;
    }

    private IProjectModel createConfigModel(IProjectModel baseModel, MProject project, IVariableStore confLookup, boolean shouldCopy) {
        MProject model;
        ChainedVariableLookup chainedLookup = new ChainedVariableLookup((IVariableLookup)confLookup, baseModel.getVariableLookup());
        MProject mProject = model = project == null ? baseModel.getModel() : project;
        if (shouldCopy) {
            model = model.copy();
        }
        ProjectModel configModel = new ProjectModel(model, (IVariableLookup)chainedLookup, baseModel.getContentRootURI(), baseModel.getProjectResourceTree());
        return configModel;
    }

    private void canonicalizeModel(IProjectModel model, IBuildConfigurationDescriptor bconf) {
        MProjectCanonicalizer canon = new MProjectCanonicalizer(model, bconf, false);
        canon.doSwitch((EObject)model.getModel());
        for (MConfiguration conf : model.getModel().getConfigurations()) {
            canon.doSwitch((EObject)conf);
        }
    }

    private void mergeModuleSources(final IBuildConfigurationDescriptor conf, final IProjectModel configModel, IProjectModel clientConfigModel, final MModule mmodule, final Set<String> builtinSources, Set<String> builtinExcludes) {
        final ProjectModelCompatibility configCompat = new ProjectModelCompatibility(configModel);
        ((ProjectModel)clientConfigModel).setReportNullWarning(false);
        clientConfigModel.accept(new IProjectFileContentVisitor(){
            final Deque<Boolean> excluding = new ArrayDeque<Boolean>();

            @Override
            public void visitFailed(MFolderEntry container, File containerFile, IPath projectPath, MEntry entry, MSelectable selectable, File entryFile, IOException e) {
            }

            @Override
            public boolean preVisit(MFolderEntry entry, File containerFile, IPath projectPath, MSelectable selector, File contentFolder) {
                boolean isIncluded;
                List<IBuildConfigurationDescriptor> exclCfgs = ProjectModuleExclusionHandler.determineIfExcluded(ProjectModelModuleHandler.this.projDesc, ProjectModelModuleHandler.this.rawModel, ProjectModelModuleHandler.this.expanded, selector, configCompat, projectPath, configModel);
                if (exclCfgs == null) {
                    return false;
                }
                ResourceInfo folderCustomization = ProjectModelModuleHandler.this.applyCustomizations(mmodule, projectPath);
                if (!folderCustomization.include) {
                    this.excluding.push(true);
                    return true;
                }
                boolean bl = isIncluded = this.excluding.isEmpty() || this.excluding.peek() == false;
                if (isIncluded) {
                    boolean isNew;
                    MFolderEntry to = ProjectModelUtils.findFolder(configModel, (MFolderEntry)ProjectModelModuleHandler.this.expanded, folderCustomization.projectPath);
                    boolean bl2 = isNew = to == null;
                    if (to == null) {
                        to = ProjectModelUtils.findOrCreateFolder(configModel, (MFolderEntry)ProjectModelModuleHandler.this.expanded, folderCustomization.projectPath);
                    }
                    if (isNew || entry.getFiles().isEmpty() && entry.getFolders().isEmpty()) {
                        to.setBuiltin(true);
                    }
                    ProjectModelModuleHandler.this.ensureResourceReferences(mmodule, (MEntry)to, ProjectModelModuleHandler.this.configMap.get(conf));
                    ProjectModelMergeUtils.copySettingsSite((MSettingsSite)to, (MSettingsSite)entry);
                    to.setBoardCompatibility(entry.getBoardCompatibility());
                    to.setPartCompatibility(entry.getPartCompatibility());
                    to.setSdkCompatibility(entry.getSdkCompatibility());
                    to.setToolchainCompatibility(entry.getToolchainCompatibility());
                    to.setCompatibility(entry.getCompatibility());
                    this.excluding.push(false);
                } else {
                    this.excluding.push(true);
                }
                return true;
            }

            @Override
            public void visit(MFolderEntry container, File containerFile, IPath projectPath, MFileEntry entry, MSelectable selector, File contentFile) {
                boolean isIncluded;
                List<IBuildConfigurationDescriptor> exclCfgs = ProjectModuleExclusionHandler.determineIfExcluded(ProjectModelModuleHandler.this.projDesc, ProjectModelModuleHandler.this.rawModel, ProjectModelModuleHandler.this.expanded, selector, configCompat, projectPath, configModel);
                if (exclCfgs == null) {
                    return;
                }
                ResourceInfo fileCustomization = ProjectModelModuleHandler.this.applyCustomizations(mmodule, projectPath);
                boolean bl = isIncluded = this.excluding.isEmpty() || this.excluding.peek() == false;
                if (fileCustomization.include && isIncluded) {
                    boolean isNew;
                    MFileEntry toFile = ProjectModelUtils.findFile(configModel, (MFolderEntry)ProjectModelModuleHandler.this.expanded, fileCustomization.projectPath);
                    boolean bl2 = isNew = toFile == null;
                    if (entry instanceof MFileContent) {
                        MFileContent fromContent = (MFileContent)entry;
                        MFileContent toContent = ProjectModelUtils.findOrCreateFileContent(configModel, ProjectModelModuleHandler.this.expanded, fileCustomization.projectPath, contentFile.toURI().toString());
                        if (toContent.getLinked() == null) {
                            toContent.setLinked(fromContent.getLinked());
                        }
                        if (!isNew && ProjectModelModuleHandler.this.exclHandler.isExcludedInAll((MEntry)toContent)) {
                            toContent.setUri(contentFile.toURI().toString());
                        }
                        toFile = toContent;
                    } else if (entry == null) {
                        MFileContent toContent = ProjectModelUtils.findOrCreateFileContent(configModel, ProjectModelModuleHandler.this.expanded, fileCustomization.projectPath, contentFile.toURI().toString());
                        toFile = toContent;
                    } else if (fileCustomization.projectPath != null) {
                        toFile = ProjectModelUtils.findOrCreateFile(configModel, ProjectModelModuleHandler.this.expanded, fileCustomization.projectPath);
                    } else {
                        toFile = ProjectModelUtils.findFile(configModel, container, entry.getName());
                        if (toFile == null) {
                            toFile = (MFileEntry)EcoreTypeUtils.copy((EObject)entry);
                            container.getFiles().add((Object)toFile);
                        }
                    }
                    if (isNew) {
                        toFile.setBuiltin(true);
                    }
                    if (entry != null) {
                        ProjectModelMergeUtils.copySettingsSite((MSettingsSite)toFile, (MSettingsSite)entry);
                        toFile.setBoardCompatibility(entry.getBoardCompatibility());
                        toFile.setPartCompatibility(entry.getPartCompatibility());
                        toFile.setSdkCompatibility(entry.getSdkCompatibility());
                        toFile.setToolchainCompatibility(entry.getToolchainCompatibility());
                        toFile.setCompatibility(entry.getCompatibility());
                        toFile.setGenerated(entry.isGenerated());
                        if (TextUtils.isEmpty((String)toFile.getFileContent())) {
                            toFile.setFileContent(entry.getFileContent());
                        }
                    }
                    MReference fileRef = ProjectModelModuleHandler.this.ensureResourceReferences(mmodule, (MEntry)toFile, ProjectModelModuleHandler.this.configMap.get(conf));
                    ProjectModelModuleHandler.this.exclHandler.excludeFromConfigs((MEntry)toFile, exclCfgs, mmodule);
                    if (fileRef != null && fileRef.isBuiltin()) {
                        builtinSources.add(projectPath.makeRelative().toPortableString());
                    }
                }
            }

            @Override
            public boolean postVisit(MFolderEntry entry, IPath projectPath, File contentFolder) {
                this.excluding.pop();
                return true;
            }
        });
    }

    private MReference ensureResourceReferences(MModule module, MEntry to, MConfiguration config) {
        if (to == null) {
            return null;
        }
        MReference ref = null;
        for (Map.Entry entry : this.rsrcTree.getConfigurations().entrySet()) {
            MProjectReference projRef = (MProjectReference)entry.getValue();
            boolean isConfig = config == null ? false : ((String)entry.getKey()).equals(config.getName());
            projRef.getEntryToReferenceMap().put(this.expanded, projRef);
            MReference curRef = this.ensureResourceReferences(module, to, projRef.getEntryToReferenceMap(), isConfig);
            if (!isConfig) continue;
            ref = curRef;
        }
        return ref;
    }

    private MReference ensureResourceReferences(MModule module, MEntry to, Map<MEntry, MReference> entToRef, boolean isAddedToConf) {
        if (to == null) {
            return null;
        }
        Object ref = entToRef.get(to);
        if (ref == null && entToRef.get(to.eContainer()) instanceof MFolderReference) {
            MFolderReference parent = (MFolderReference)entToRef.get(to.eContainer());
            ref = ProjectModelUtils.findReference(parent, to.getName());
        }
        if (ref == null) {
            if (to instanceof MFolderEntry) {
                ref = to instanceof MProject ? ProjectModelFactory.eINSTANCE.createMProjectReference() : ProjectModelFactory.eINSTANCE.createMFolderReference();
                ((MFolderReference)ref).setRef((MFolderEntry)to);
                entToRef.put(to, (MReference)ref);
            } else {
                ref = ProjectModelFactory.eINSTANCE.createMFileReference();
                ((MFileReference)ref).setRef((MFileEntry)to);
                entToRef.put(to, (MReference)ref);
            }
            ref.setExcluded(!isAddedToConf);
            ref.setBuiltin(true);
        }
        if (ref.eContainer() == null && to.eContainer() != null) {
            MReference parentRef = entToRef.get(to.eContainer());
            if (parentRef == null) {
                parentRef = this.ensureResourceReferences(module, (MEntry)to.eContainer(), entToRef, isAddedToConf);
            }
            if (ref instanceof MFolderReference) {
                ((MFolderReference)parentRef).getFolders().add((Object)((MFolderReference)ref));
            } else if (ref instanceof MFileReference) {
                ((MFolderReference)parentRef).getFiles().add((Object)((MFileReference)ref));
            }
        }
        if (isAddedToConf) {
            ref.setProvidingModule(module);
            boolean wasExcluded = ref.isExcluded();
            ref.setExcluded(false);
            if (wasExcluded && ref instanceof MFolderReference) {
                ((MFolderReference)ref).getFiles().forEach(r -> r.setExcluded(wasExcluded));
                ((MFolderReference)ref).getFolders().forEach(r -> r.setExcluded(wasExcluded));
            }
        } else if (ref.isBuiltin() && ref.getProvidingModule() == null) {
            ref.setProvidingModule(module);
        }
        return ref;
    }

    protected IPath getProjectPath(MEntry entry) {
        MEntry key = entry;
        Object projPath = this.entryPaths.get(key);
        if (projPath == null) {
            if (entry == null || entry instanceof MProject) {
                return Path.ROOT;
            }
            String entName = this.userModel.resolveString(entry.getName());
            projPath = entry.eContainer() instanceof MProject ? new Path(entName) : this.getProjectPath((MEntry)entry.eContainer()).append(entName);
            if (entry instanceof MFolderEntry) {
                projPath = projPath.addTrailingSeparator();
            }
            projPath = projPath.makeAbsolute();
            this.entryPaths.put(key, (IPath)projPath);
        }
        return projPath;
    }

    protected Pattern getPattern(String pattStr) {
        Pattern pattern = patternCache.get(pattStr);
        if (pattern == null || pattStr == null) {
            pattern = Pattern.compile(pattStr);
            patternCache.put(pattStr, pattern);
        }
        return pattern;
    }

    private ResourceInfo applyCustomizations(MModule mmodule, MEntry entry) {
        IPath projectPath = this.getProjectPath(entry);
        return this.applyCustomizations(mmodule, projectPath);
    }

    private ResourceInfo applyCustomizations(MModule mmodule, IPath projectPath) {
        if (!mmodule.getCustomizationsGroup().isEmpty()) {
            boolean isFolder = projectPath.hasTrailingSeparator() || projectPath == Path.ROOT;
            boolean first = true;
            boolean included = true;
            for (MCustomization cust : mmodule.getCustomizations()) {
                String projectPathStr;
                Matcher m;
                Pattern p;
                List<IBuildConfigurationDescriptor> exclCfgs;
                if (first) {
                    if (!isFolder && cust instanceof MInclusion) {
                        included = false;
                    }
                    first = false;
                }
                if ((exclCfgs = this.compat.calculateContentExclusion(this.projDesc, (MSelectable)cust)) == null || (p = this.getPattern(cust.getPattern())) == null || !(m = p.matcher(projectPathStr = projectPath.makeRelative().toPortableString())).matches()) continue;
                if (cust instanceof MInclusion) {
                    included = true;
                    if (TextUtils.isEmpty((String)((MInclusion)cust).getReplacement())) continue;
                    projectPath = new Path(m.replaceAll(((MInclusion)cust).getReplacement()));
                    continue;
                }
                if (!(cust instanceof MExclusion)) continue;
                included = false;
            }
            if (!included) {
                return new ResourceInfo(false, projectPath);
            }
        }
        return new ResourceInfo(true, projectPath);
    }

    private boolean mergeResourceReferences(IBuildConfigurationDescriptor conf, MModule mmodule, Collection<String> moduleBuiltins, MFolderEntry from, MFolderReference toRef, Map<MEntry, MReference> entToRef) {
        assert (toRef != null);
        ResourceInfo folderCustomization = this.applyCustomizations(mmodule, (MEntry)from);
        MFolderEntry to = ProjectModelUtils.findFolder(this.userModel, (MFolderEntry)this.expanded, folderCustomization.projectPath);
        assert (to != null);
        for (MFolderEntry fromFolder : from.getFolders()) {
            if (fromFolder == null) continue;
            MFolderEntry toFolder = ProjectModelUtils.findFolder(this.userModel, to, fromFolder.getName());
            assert (toFolder != null);
            MFolderReference ref = (MFolderReference)entToRef.get(toFolder);
            assert (ref != null);
            if (toFolder == null) {
                Activator.reporter.logWarning("Model folder was null for path " + String.valueOf(ProjectModelUtils.getProjectPathFor((MEntry)fromFolder)), (Throwable)ExceptionUtils.newMinimalStackException());
                continue;
            }
            if (ref == null) {
                Activator.reporter.logWarning("Folder reference was null for file " + fromFolder.getName() + " path " + String.valueOf(ProjectModelUtils.getProjectPathFor((MEntry)fromFolder)), (Throwable)ExceptionUtils.newMinimalStackException());
                continue;
            }
            boolean isApplicable = this.mergeResourceReferences(conf, mmodule, moduleBuiltins, fromFolder, ref, entToRef);
            if (!ref.isBuiltinTree() || !isApplicable) continue;
            boolean exclude = !folderCustomization.include || !this.compat.isCompatibleForConfig((MSelectable)toFolder, conf);
            ref.setExcluded(exclude);
        }
        boolean applicable = false;
        for (MFileEntry fromFile : from.getFiles()) {
            ResourceInfo fileCustomization = this.applyCustomizations(mmodule, (MEntry)fromFile);
            String filePath = fileCustomization.projectPath.makeRelative().toPortableString();
            if (!moduleBuiltins.contains(filePath)) continue;
            applicable = true;
            MFileEntry toFile = (MFileEntry)ProjectModelUtils.findEntry(this.userModel, (MFolderEntry)this.expanded, fileCustomization.projectPath);
            assert (toFile != null);
            MFileReference ref = (MFileReference)entToRef.get(toFile);
            assert (ref != null);
            if (toFile == null) {
                Activator.reporter.logWarning("Model file was null for path " + String.valueOf(fileCustomization.projectPath), (Throwable)ExceptionUtils.newMinimalStackException());
                continue;
            }
            if (ref == null) {
                Activator.reporter.logWarning("File reference was null for file " + toFile.getName() + " path " + String.valueOf(fileCustomization.projectPath), (Throwable)ExceptionUtils.newMinimalStackException());
                continue;
            }
            boolean exclude = !fileCustomization.include || !this.compat.isCompatibleForConfig((MSelectable)toFile, conf);
            ref.setExcluded(exclude);
        }
        return applicable;
    }

    protected void updateRemovedModules() {
        MProjectResourceTree resourceTree;
        MProjectResourceTree mProjectResourceTree = resourceTree = this.rawModel != null ? this.rawModel.getProjectResourceTree() : this.userModel.getProjectResourceTree();
        if (resourceTree == null) {
            return;
        }
        final HashSet newModules = new HashSet(this.userModel.getModel().getModules());
        for (MConfiguration conf : this.userModel.getModel().getConfigurations()) {
            newModules.addAll(conf.getModules());
        }
        new ProjectModelSwitch<Object>(){

            public Object caseMReference(MReference ref) {
                if (ref.getProvidingModule() != null && !ref.isExcluded() && !newModules.contains(ref.getProvidingModule())) {
                    IPath prjPath = ProjectModelUtils.getProjectPathFor(ref.getRef());
                    String path = prjPath.toPortableString();
                    for (MConfiguration config : ProjectModelModuleHandler.this.expanded.getConfigurations()) {
                        if (config.getExcludedPaths().contains((Object)path)) continue;
                        config.getExcludedPaths().add((Object)path);
                        for (MConfiguration conf : ProjectModelModuleHandler.this.userModel.getModel().getConfigurations()) {
                            MReference modRef = ProjectModelUtils.findReference((MFolderReference)ProjectModelModuleHandler.this.rsrcTree.getConfigurations().get((Object)conf.getName()), prjPath);
                            if (modRef == null || !(modRef.eContainer() instanceof MFolderReference)) continue;
                            MFolderReference container = (MFolderReference)modRef.eContainer();
                            container.getFolders().remove((Object)modRef);
                            container.getFiles().remove((Object)modRef);
                        }
                    }
                }
                return null;
            }

            public Object defaultCase(EObject object) {
                Object[] objectArray = object.eContents().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    this.doSwitch((EObject)obj);
                    ++n2;
                }
                return this;
            }
        }.doSwitch((EObject)resourceTree);
    }

    static class ResourceInfo {
        boolean include;
        IPath projectPath;

        public ResourceInfo(boolean include, IPath projectPath) {
            this.include = include;
            this.projectPath = projectPath;
        }
    }
}

