/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type;

import com.silabs.java.utils.ITypedFilter;
import com.silabs.java.utils.extension.ExtensionManager;
import com.silabs.java.utils.extension.IExtensionInformation;
import com.silabs.java.utils.extension.IExtensionManager;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.core.type.IProjectTypeRegistry;
import com.silabs.ss.framework.project.api.core.type.NoneProjectType;
import com.silabs.ss.framework.project.internal.api.core.external.impl.NoneExternalProjectType;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericIDEProvider;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescribable;
import com.silabs.ss.platform.api.idemanager.core.AbstractIDEProvider;
import com.silabs.ss.platform.api.idemanager.core.IDEPreferenceManager;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IPath;

public class ProjectTypeRegistry
implements IProjectTypeRegistry {
    private static final String PROJECT_TYPE_EXTENSION_NAME = "projectTypeSupport";
    private final ITypedFilter<IExtensionInformation> filter;
    private IExtensionManager extMgr;
    private Map<String, IExtensionInformation> projectTypeExtensionMap = new LinkedHashMap<String, IExtensionInformation>();
    private Map<String, IProjectType> projectTypeMap = new ConcurrentHashMap<String, IProjectType>();
    private Map<String, IExtensionInformation> extProjectTypeExtensionMap = new LinkedHashMap<String, IExtensionInformation>();
    private Map<String, IExternalType> extProjectTypeMap = new ConcurrentHashMap<String, IExternalType>();

    public static ProjectTypeRegistry create() {
        return new ProjectTypeRegistry(null);
    }

    private ProjectTypeRegistry(ITypedFilter<IExtensionInformation> filter) {
        this.filter = filter;
    }

    @Override
    public void reset() {
        this.projectTypeExtensionMap.clear();
        this.projectTypeMap.clear();
        this.extProjectTypeExtensionMap.clear();
        this.extProjectTypeMap.clear();
        this.extMgr.dispose();
        this.postInit();
        this.getExtensionManager().startup();
        this.postStartup();
    }

    public void postInit() {
        this.loadExtensions(this.filter);
    }

    private void loadExtensions(ITypedFilter<IExtensionInformation> filter) {
        this.extMgr = new ExtensionManager(Activator.id(), PROJECT_TYPE_EXTENSION_NAME, filter);
        this.projectTypeMap.put(NoneProjectType.ID, new NoneProjectType());
        this.extMgr.addHandler("projectType", (el, added, context) -> {
            ProjectTypeRegistry projectTypeRegistry = this;
            synchronized (projectTypeRegistry) {
                String id = el.getAttribute("id");
                if (added) {
                    this.projectTypeExtensionMap.put(id, el);
                } else {
                    this.projectTypeExtensionMap.remove(id);
                    this.projectTypeMap.remove(id);
                }
            }
        });
        this.extMgr.addHandler("externalProjectType", (el, added, context) -> {
            ProjectTypeRegistry projectTypeRegistry = this;
            synchronized (projectTypeRegistry) {
                String id = el.getAttribute("id");
                if (added) {
                    this.extProjectTypeExtensionMap.put(id, el);
                } else {
                    this.extProjectTypeExtensionMap.remove(id);
                    this.extProjectTypeMap.remove(id);
                }
            }
        });
        this.extMgr.startup();
    }

    public void postStartup() {
        this.realizeGenericTemplateProjectTypes();
    }

    private void realizeGenericTemplateProjectTypes() {
        IDEPreferenceManager.providerFor(GenericIDEProvider.class).ifPresent(AbstractIDEProvider::getIDEs);
    }

    @Override
    public void loadFromExternalFolder(File externalIdes) {
        IDEPreferenceManager.providerFor(GenericIDEProvider.class).ifPresent(p -> p.detectIDEs(externalIdes));
    }

    public IExtensionManager getExtensionManager() {
        return this.extMgr;
    }

    @Override
    public IProjectType findProjectType(String id) {
        IProjectType projectType = this.realizeProjectType(id);
        return projectType;
    }

    protected synchronized IProjectType realizeProjectType(String id) {
        IExtensionInformation el;
        IProjectType projectType = this.projectTypeMap.get(id);
        if (projectType == null && (el = this.projectTypeExtensionMap.get(id)) != null) {
            try {
                projectType = (IProjectType)el.createExecutableExtension("class");
            }
            catch (Exception e) {
                Activator.reporter.logError("cannot create projectType " + id, (Throwable)e);
                projectType = new NoneProjectType();
            }
            this.projectTypeMap.put(id, projectType);
            if (projectType.getName() == null) {
                ((IWriteableDescribable)projectType).setName(id);
            }
            if (projectType.getLabel() == null) {
                ((IWriteableDescribable)projectType).setLabel(el.getAttribute("label"));
            }
            if (projectType.getDescription() == null) {
                ((IWriteableDescribable)projectType).setDescription(el.getAttribute("description"));
            }
        }
        return projectType;
    }

    protected synchronized IExternalType realizeExternalProjectType(String id) {
        IExtensionInformation el;
        IExternalType projectType = this.extProjectTypeMap.get(id);
        if (projectType == null && (el = this.extProjectTypeExtensionMap.get(id)) != null) {
            try {
                projectType = (IExternalType)el.createExecutableExtension("class");
            }
            catch (Exception e) {
                Activator.reporter.logError("cannot create externalProjectType " + id, (Throwable)e);
                projectType = new NoneExternalProjectType();
            }
            this.extProjectTypeMap.put(id, projectType);
            if (projectType.getName() == null) {
                ((IWriteableDescribable)projectType).setName(id);
            }
            if (projectType.getLabel() == null) {
                ((IWriteableDescribable)projectType).setLabel(el.getAttribute("label"));
            }
            if (projectType.getDescription() == null) {
                ((IWriteableDescribable)projectType).setDescription(el.getAttribute("description"));
            }
        }
        return projectType;
    }

    private <T, U> SortedMap<Double, T> measureApplicability(T[] elements, U projectOrLocation, IApplicabilityCalculator<T, U> calculator) {
        TreeMap<Double, T> matches = new TreeMap<Double, T>((o1, o2) -> (int)Math.signum(o2 - o1));
        if (projectOrLocation != null) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T element = TArray[n2];
                try {
                    double applicability = calculator.getApplicability(element, projectOrLocation);
                    if (applicability > 0.0) {
                        matches.put(applicability, element);
                    }
                }
                catch (Exception e) {
                    Activator.reporter.logError("error checking project type", (Throwable)e);
                }
                ++n2;
            }
        }
        return matches;
    }

    @Override
    public IProjectType[] getProjectTypes(IPath projPath) {
        SortedMap<Double, IProjectType> matches = this.measureApplicability(this.getAllProjectTypes(), projPath, IProjectType::getApplicability);
        return matches.values().toArray(new IProjectType[0]);
    }

    @Override
    public IProjectType getProjectType(IPath projPath) {
        IProjectType[] types = this.getProjectTypes(projPath);
        if (types.length == 0) {
            return null;
        }
        return types[0];
    }

    @Override
    public synchronized IProjectType[] getAllProjectTypes() {
        for (String id : this.projectTypeExtensionMap.keySet()) {
            this.realizeProjectType(id);
        }
        return (IProjectType[])this.projectTypeMap.values().stream().filter(t -> !t.getId().equals(NoneProjectType.ID)).toArray(IProjectType[]::new);
    }

    @Override
    public IExternalType findExternalType(String id) {
        IExternalType projectType = this.realizeExternalProjectType(id);
        return projectType;
    }

    @Override
    public synchronized IExternalType[] getAllExternalTypes() {
        for (String id : this.extProjectTypeExtensionMap.keySet()) {
            this.realizeExternalProjectType(id);
        }
        return (IExternalType[])this.extProjectTypeMap.values().toArray(IExternalType[]::new);
    }

    @Override
    public void registerProjectType(IProjectType projectType) {
        this.projectTypeMap.put(projectType.getId(), projectType);
    }

    @Override
    public void registerExternalType(IExternalType projectType) {
        this.extProjectTypeMap.put(projectType.getId(), projectType);
    }

    static interface IApplicabilityCalculator<T, U> {
        public double getApplicability(T var1, U var2) throws Exception;
    }
}

