/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;

public class GenericProjectRootMetadata
implements IExternalProjectMetadata<MProject> {
    private static final String KEY_PROJECT_SOURCES = "PROJECT_ROOT";
    private static final String VAR_REL_PROJECT_ROOT = "RELATIVE_PROJECT_ROOT";
    private Map<String, String> storageProject = new TreeMap<String, String>();

    public void registerRoot(Path projectFile, Path generationDir) {
        this.storageProject.put(VAR_REL_PROJECT_ROOT, projectFile.getParent().relativize(generationDir).toString());
    }

    public void clearContent() {
        this.storageProject.clear();
    }

    @Override
    public void apply(MProject project) {
        String contentRoot = project.getContentRoot();
        String relProjRoot = this.storageProject.get(VAR_REL_PROJECT_ROOT);
        if (TextUtils.hasContent((String)contentRoot) && TextUtils.hasContent((String)relProjRoot)) {
            String newContentRoot = URI.create(contentRoot).resolve(relProjRoot).toString();
            project.setContentRoot(newContentRoot);
        }
    }

    @Override
    public void write(ExternalProjectMetadataHandler<MProject, ?> handler) {
        String mapStr = CoreTypes.STRING_TO_STRING_MAP.stringize(this.storageProject);
        handler.put(KEY_PROJECT_SOURCES, mapStr);
    }

    @Override
    public void load(ExternalProjectMetadataHandler<MProject, ?> handler) {
        String mapContent = handler.get(KEY_PROJECT_SOURCES);
        if (TextUtils.isEmpty((String)mapContent)) {
            return;
        }
        this.storageProject = new TreeMap<String, String>((Map)CoreTypes.STRING_TO_STRING_MAP.convert(mapContent));
    }
}

