/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ISelectableDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.solution.ISolutionDescriptor;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.type.ExternalProjectType;
import com.silabs.ss.framework.project.api.core.type.IProjectToolOptionHandler;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.core.type.IProjectTypeInfo;
import com.silabs.ss.framework.project.api.core.type.ProjectType;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.internal.core.entity.ExternalProjectEntity;
import com.silabs.ss.framework.project.internal.core.entity.IProjectPathResolver;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericExternalProjectType;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericOperationHandler;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericSolutionOperationHandler;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericTemplates;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEGenerator;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEMetadata;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class GenericProjectType
extends ExternalProjectType {
    public static final String IDE_COMPATIBILITY_ID = "generic-template";
    private Collection<String> keywordsList;
    private IExternalType externalType;
    private List<String> projFileExtensions;
    private GeneralGenericProjectTypeInfo projTypeInfo;
    private String ideName;
    private GenericTemplates templates;
    private List<IDEGenerator> generators;
    private GenericTemplates solutionTemplates;
    private List<IDEGenerator> solutionGenerators;

    public GenericProjectType(IDEMetadata aIDE) {
        this.setId(aIDE.getId());
        this.setLabel(aIDE.getIdeName());
        this.setDescription(aIDE.getIdeDescription());
        this.ideName = aIDE.getIdeName();
        this.keywordsList = List.copyOf(aIDE.getKeywords());
        this.externalType = new GenericExternalProjectType(aIDE);
        this.projFileExtensions = List.copyOf(aIDE.getProjectFileExtensions());
        this.projTypeInfo = new GeneralGenericProjectTypeInfo(aIDE);
        this.templates = new GenericTemplates(aIDE, aIDE.getTemplates());
        this.generators = aIDE.getGenerators();
        this.solutionTemplates = new GenericTemplates(aIDE, aIDE.getSolutionTemplates());
        this.solutionGenerators = aIDE.getSolutionGenerators();
    }

    @Override
    public Collection<String> matchingKeywords() {
        return this.keywordsList;
    }

    @Override
    public ISolutionEngineOperationHandler createSolutionEngineOperationHandler(ISolutionEntity solution) {
        return new GenericSolutionOperationHandler(solution, this.solutionTemplates, this.solutionGenerators);
    }

    @Override
    public IProjectEngineOperationHandler createProjectEngineOperationHandler(IProjectEntity projectEntity) {
        if (!(projectEntity instanceof IExternalProjectEntity)) {
            throw new IllegalArgumentException(this.ideName + " resource generation requires an IExternalProjectEntity");
        }
        return new GenericOperationHandler((IExternalProjectEntity)projectEntity, this.templates, this.generators);
    }

    @Override
    public boolean toolchainSupportsProject(IToolchainDescriptor toolchain, IProjectDescriptor desc) {
        return false;
    }

    @Override
    public IExternalType getExternalType() {
        return this.externalType;
    }

    @Override
    public IProjectEntity createProjectEntity(IProjectDescriptor desc, File filePath) {
        return new ExternalProjectEntity(desc, this);
    }

    @Override
    public double getApplicability(IPath projectLocation) throws CoreException {
        String ext = projectLocation.getFileExtension();
        if (!TextUtils.isBlank((String)ext) && this.projFileExtensions.contains(ext)) {
            return 1.0;
        }
        return -1.0;
    }

    @Override
    public Collection<File> getSupportedFiles(IProjectDescriptor projDesc, File directory, String baseName) {
        IVariableLookup lookup = this.templates.createTargetPathLookup(projDesc);
        List<File> supportedFiles = this.templates.getAllAllowedTemplates(projDesc).sorted(this::templatePathSorting).flatMap(t -> this.templates.getTargetPath((File)t, lookup).stream()).map(e -> new File(directory, (String)e)).map(File::getAbsoluteFile).collect(Collectors.toList());
        return supportedFiles;
    }

    @Override
    public Collection<File> getSupportedSolutions(ISolutionDescriptor slnDesc, File directory, String baseName) {
        Optional<File> anySlnTemplate = this.solutionTemplates.getAllAllowedTemplates(slnDesc).findAny();
        if (anySlnTemplate.isPresent()) {
            return List.of(new File(directory, baseName));
        }
        return List.of();
    }

    private int templatePathSorting(File t1, File t2) {
        boolean studioMetadata1 = this.templates.isStudioMetadataFile(t1);
        boolean studioMetadata2 = this.templates.isStudioMetadataFile(t2);
        if (studioMetadata1 && !studioMetadata2) {
            return -1;
        }
        if (!studioMetadata1 && studioMetadata2) {
            return 1;
        }
        String ext1 = FileUtils.getExtension((File)t1);
        String ext2 = FileUtils.getExtension((File)t2);
        if (this.projFileExtensions.contains(ext1) && this.projFileExtensions.contains(ext2)) {
            return t1.compareTo(t2);
        }
        if (this.projFileExtensions.contains(ext1)) {
            return -1;
        }
        if (this.projFileExtensions.contains(ext2)) {
            return 1;
        }
        return t1.compareTo(t2);
    }

    public IPath loadGenerationDirectory(IProjectDescriptor entity) {
        try {
            if (this.templates == null) {
                return entity.getInstallationPath().removeLastSegments(1);
            }
            File projectFile = entity.getInstallationPath().toFile();
            String projectPath = projectFile.getAbsolutePath().replace("\\", "/");
            String extension = FileUtils.getExtension((File)projectFile);
            List tmplPaths = this.getTemplateTargetPaths(entity).map(p -> p.replace("\\", "/")).collect(Collectors.toList());
            int bestTmplLen = 1;
            for (String tmplPath : tmplPaths) {
                if (projectPath.endsWith(tmplPath)) {
                    bestTmplLen = IPathUtils.create((String)tmplPath).segmentCount();
                    break;
                }
                if (!tmplPath.endsWith("." + extension)) continue;
                bestTmplLen = IPathUtils.create((String)tmplPath).segmentCount();
            }
            return entity.getInstallationPath().removeLastSegments(bestTmplLen);
        }
        catch (IOException iOException) {
            return IPathUtils.empty();
        }
    }

    private Stream<String> getTemplateTargetPaths(IDescriptor desc) {
        IVariableLookup lookup = this.templates.createTargetPathLookup(desc);
        return this.templates.getAllAllowedTemplates(desc).map(File::getAbsoluteFile).flatMap(t -> this.templates.getTargetPath((File)t, lookup).stream());
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (GenericTemplates.class.equals(clazz)) {
            return clazz.cast(this.templates);
        }
        if (IProjectToolOptionHandler.class.equals(clazz)) {
            return clazz.cast(new GeneralGenericToolOptionHandler());
        }
        if (IProjectTypeInfo.class.equals(clazz)) {
            return clazz.cast(this.projTypeInfo);
        }
        if (IProjectPathResolver.class.equals(clazz)) {
            return clazz.cast(new GenericProjectPathResolver());
        }
        return super.getAdapter(clazz);
    }

    private class GeneralGenericProjectTypeInfo
    implements IProjectTypeInfo {
        private String ideCompat;

        public GeneralGenericProjectTypeInfo(IDEMetadata aIDE) {
            this.ideCompat = aIDE.getIdeCompatibility();
        }

        @Override
        public String ideCompatibilityId() {
            return this.ideCompat;
        }
    }

    private class GeneralGenericToolOptionHandler
    implements IProjectToolOptionHandler {
        private GeneralGenericToolOptionHandler() {
        }

        @Override
        public Collection<IGenericOptionMappingRegistry> getGenericOptionMappingRegistry(IProjectDescriptor proj, ISelectableDescriptor context) {
            IProjectType[] iProjectTypeArray = ProjectType.manager().getAllProjectTypes();
            int n = iProjectTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectType projType = iProjectTypeArray[n2];
                if (projType instanceof GenericProjectType && projType.getId().equalsIgnoreCase(proj.getProjectType().getId())) {
                    GenericTemplates templates = ((GenericProjectType)projType).getAdapter(GenericTemplates.class);
                    return templates.getMappingRegistries(proj);
                }
                ++n2;
            }
            return ImmutableList.of();
        }
    }

    private class GenericProjectPathResolver
    implements IProjectPathResolver {
        private GenericProjectPathResolver() {
        }

        @Override
        public IPath resolveProjectPath(IDescriptor proj) {
            IProjectDescriptor projDesc = proj instanceof IProjectEntity ? (IProjectDescriptor)((IProjectEntity)proj).getDescriptor() : (IProjectDescriptor)proj;
            return GenericProjectType.this.loadGenerationDirectory(projDesc);
        }
    }
}

