/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic.metadata;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEMetadata;
import com.silabs.ss.platform.api.rcp.core.BundleUtils;
import com.silabs.ss.platform.api.rcp.core.DevUtils;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Bundle;

public final class IDEMetadataLoader {
    private static final String IDE_METADATA_EXTENSION = ".imd";
    public static final String EXTERNAL_FILES = "exporter_templates/ide_metadata/";
    private static final String INTERNAL_FILES = "data/ide_metadata/";
    private File internalFilesLocation = IDEMetadataLoader.getInternalFilesLocation();
    private File externalFilesLocation = IDEMetadataLoader.getExternalFilesLocation();
    private static IDEMetadataLoader INSTANCE = new IDEMetadataLoader();

    private IDEMetadataLoader() {
    }

    public static IDEMetadataLoader instance() {
        return INSTANCE;
    }

    public File internalFiles() {
        return this.internalFilesLocation;
    }

    public List<IDEMetadata> loadFiles(File fileLocation) {
        ArrayList<IDEMetadata> ides = new ArrayList<IDEMetadata>();
        try {
            this.loadFilesFromDir(ides, fileLocation);
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
        }
        return ides;
    }

    private void loadFilesFromDir(List<IDEMetadata> ides, File dirWithFiles) {
        if (dirWithFiles.isDirectory()) {
            File[] metadataFiles;
            File[] fileArray = metadataFiles = dirWithFiles.listFiles((dir, name) -> name.endsWith(IDE_METADATA_EXTENSION));
            int n = metadataFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File metadataFile = fileArray[n2];
                IDEMetadata ide = this.load(metadataFile);
                if (ide != null && !this.doesIdeExist(ide, ides)) {
                    ides.add(ide);
                }
                ++n2;
            }
        }
    }

    private boolean doesIdeExist(IDEMetadata ide, List<IDEMetadata> ides) {
        if (ide == null) {
            return false;
        }
        return ides.stream().anyMatch(i -> i.getId().equalsIgnoreCase(ide.getId()));
    }

    private IDEMetadata load(File ideMetadata) {
        if (ideMetadata.isFile()) {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            try {
                IDEMetadata ide = (IDEMetadata)mapper.readValue(ideMetadata, IDEMetadata.class);
                return ide;
            }
            catch (IOException e) {
                Activator.reporter.logError("Error loading IDEMetadata metadata", (Throwable)e);
            }
        }
        return null;
    }

    public static File getInternalFilesLocation() {
        try {
            return BundleUtils.getBundleContentPath((Bundle)Activator.getContext().getBundle(), (IPath)IPathUtils.createPath((String)INTERNAL_FILES), Collections.emptyMap()).toFile();
        }
        catch (IOException e) {
            Activator.reporter.logError("Error getting internal IDE metadata files location", (Throwable)e);
            return null;
        }
    }

    public static File getExternalFilesLocation() {
        if (RuntimeUtils.isPlatformPDELaunch() || RuntimeUtils.isJUnitRunning()) {
            return DevUtils.getWorkspaceLocation().append(EXTERNAL_FILES).toFile();
        }
        return DevUtils.getInstallPath().append("developer").append(EXTERNAL_FILES).toFile();
    }

    public File copyInternalFilesToExternalFilesLocation() throws Exception {
        try {
            File externalDir = this.externalFilesLocation;
            if (!externalDir.exists()) {
                externalDir.mkdirs();
            }
            if (!externalDir.canWrite()) {
                return externalDir;
            }
            FileUtils.copyTreeNoParent((File)this.internalFilesLocation, (File)externalDir, null);
            if (RuntimeUtils.isJUnitRunning()) {
                this.renameExternalIdeMetadataTemplateFiles(externalDir);
            }
            return externalDir;
        }
        catch (Throwable t) {
            Activator.reporter.logException(t);
            return this.externalFilesLocation;
        }
    }

    private void renameExternalIdeMetadataTemplateFiles(File metadataDir) throws IOException {
        Collection imdTemplateFiles = FileUtils.findMatchingFiles((File)metadataDir, (int)1, (String[])new String[]{"*.template"});
        imdTemplateFiles.stream().forEach(i -> {
            File imdFile = FileUtils.removeFileExtension((File)i.getAbsoluteFile());
            if (!imdFile.isFile()) {
                try {
                    FileUtils.copyFile((File)i, (File)imdFile);
                }
                catch (IOException e) {
                    Activator.reporter.logError("Failed to create IDE metadata file", (Throwable)e);
                }
            }
        });
    }
}

