/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.function.ThrowableRunnable;
import com.silabs.java.utils.function.ThrowableSupplier;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.StudioExporterUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.DocumentRoot;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.impl.IarProjectConnectionTypeImpl;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.util.IarProjectConnectionResourceFactoryImpl;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARElement;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARProject;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwwWorkspace;
import com.silabs.ss.platform.api.rcp.core.BundleUtils;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class IarEwProjectUtils {
    public static final String BUILD_STEP_PREBUILD_CONFIG = "Solution_PreBuild";
    public static final String BUILD_STEP_POSTBUILD_CONFIG = "Solution_PostBuild";
    public static final String VAR_PROJ_DIR = "$PROJ_DIR$";
    public static final String VAR_WS_DIR = "$WS_DIR$";
    public static final String IAR_PATH_SEP = "\\";
    private static final String TEMPLATE_DATA_DIR = "data/iar_ew_templates/arm/";
    private static final String TEMPLATE_DATA_PATH = "data/iar_ew_templates/arm/arm.";
    private static final String IAR_XML_FORMATTER_PATH = "data/iar_ew_templates/iarPrettyPrint.xsl";
    public static final String EXTENSION_EWP = "ewp";
    public static final String EXTENSION_EWW = "eww";
    public static final String EXTENSION_IPCF = "ipcf";
    public static final String EXTENSION_IWCF = "iwcf";
    public static final String SLN_CONNECTION_FILENAME = "slnConnection.txt";
    public static final String BUILD_STEP_TEMPLATE = "data/iar_ew_templates/arm/build_step.ewp";
    private static final String STUDIO_GENERATED_COMMENT = "<!-- Automatically generated by Silicon Labs. -->";
    private static final Map<File, Object> file_lock = new ConcurrentHashMap<File, Object>();

    private IarEwProjectUtils() {
    }

    public static File loadEwpTemplate() throws CoreException {
        return IarEwProjectUtils.loadTemplate(EXTENSION_EWP);
    }

    public static File loadEwwTemplate() throws CoreException {
        return IarEwProjectUtils.loadTemplate(EXTENSION_EWW);
    }

    public static File loadEwpBuildStepTemplate() throws CoreException {
        return IarEwProjectUtils.loadFile(BUILD_STEP_TEMPLATE, "Failed to load IAR Solution build step project template!");
    }

    private static File loadTemplate(String ext) throws CoreException {
        return IarEwProjectUtils.loadFile(TEMPLATE_DATA_PATH + ext, "Failed to load IAR *." + ext + " template file!");
    }

    private static File loadIarXmlFormatter() throws CoreException {
        return IarEwProjectUtils.loadFile(IAR_XML_FORMATTER_PATH, "Failed to load IAR xml formatter file!");
    }

    private static File loadFile(String path, String errorMsg) throws CoreException {
        try {
            return BundleUtils.getBundleContentPath((Bundle)Activator.getContext().getBundle(), (IPath)IPathUtils.createPath((String)path), Collections.emptyMap()).toFile();
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException(errorMsg, (Throwable)e);
        }
    }

    public static String buildStepProjName(String projectName) {
        return projectName + "_BuildStep";
    }

    public static IARProject loadIarProject(File projectFile) throws CoreException {
        Element root = IarEwProjectUtils.loadXml(projectFile);
        return new IARProject(root, projectFile);
    }

    public static IarEwwWorkspace loadIarSolution(File slnFile) throws CoreException {
        Element root = IarEwProjectUtils.loadXml(slnFile);
        return new IarEwwWorkspace(root, slnFile);
    }

    private static <E extends Throwable> void lockFileAccess(File file, ThrowableRunnable<E> runner) throws E {
        IarEwProjectUtils.lockFileAccess(file, () -> {
            runner.run();
            return null;
        });
    }

    private static <T, E extends Throwable> T lockFileAccess(File file, ThrowableSupplier<T, E> supp) throws E {
        Object[] valueExcept = new Object[2];
        file_lock.compute(file, (f, o) -> {
            try {
                objectArray[0] = supp.get();
            }
            catch (Throwable e) {
                objectArray[1] = e;
            }
            return null;
        });
        if (valueExcept[1] != null) {
            throw (Throwable)valueExcept[1];
        }
        return (T)valueExcept[0];
    }

    public static Element loadXml(File projectFile) throws CoreException {
        return (Element)IarEwProjectUtils.lockFileAccess(projectFile, () -> {
            Document document;
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileInputStream in = new FileInputStream(projectFile);){
                    document = IarEwProjectUtils.parse(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw Activator.reporter.newCoreException("Could not parse file", (Throwable)e);
            }
            Element root = document.getDocumentElement();
            return root;
        });
    }

    public static void writeIarXml(IARElement project, File output) {
        output.getParentFile().mkdirs();
        String iarExtension = FileUtils.getExtension((File)output);
        boolean isEww = EXTENSION_EWW.equals(iarExtension);
        Node node = project.getNode();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                factory.setAttribute("indent-number", 4);
                File iarXmlFormatFile = IarEwProjectUtils.loadIarXmlFormatter();
                Templates templates = factory.newTemplates(new StreamSource(new FileInputStream(iarXmlFormatFile.getAbsolutePath())));
                Transformer transformer = templates.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(new DOMSource(node), new StreamResult(os));
                os.flush();
                String iarContent = new String(os.toByteArray());
                String formattedContent = isEww ? IarEwProjectUtils.formatEwwContents(iarContent) : IarEwProjectUtils.formatEwpContents(iarContent);
                IarEwProjectUtils.lockFileAccess(output, () -> FileUtils.writeFileContents((File)output, (String)formattedContent));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | TransformerException | CoreException e) {
            Activator.reporter.logError("Failed to write iar project to file", e);
        }
    }

    public static String formatEwpContents(String ewpContent) {
        return ewpContent.replace("<state/>", "<state></state>").replace("<extensions/>", "<extensions></extensions>").replace("<cmdline/>", "<cmdline></cmdline>").replace("<prebuild/>", "<prebuild></prebuild>").replace("<postbuild/>", "<postbuild></postbuild>").replace("<data/>", "<data />").replace("?><project>", "?>\n<project>");
    }

    public static String formatEwwContents(String ewwContent) {
        return ewwContent.replace("<workspace>", HostUtils.getNewline() + "<workspace>").replace("?><project>", "?>\n<project>").replace("<batchBuild/>", "<batchBuild />").replace(HostUtils.getNewline(), "\r\n");
    }

    public static void writeSolutionConnectionFile(Path projectPath, Path solutionPath) {
        Path projectDirPath = projectPath.normalize().toFile().getParentFile().toPath();
        if (!projectDirPath.toFile().exists()) {
            return;
        }
        File slnConnectionFile = Paths.get(projectDirPath.toString(), SLN_CONNECTION_FILENAME).toFile();
        try {
            IarEwProjectUtils.lockFileAccess(slnConnectionFile, () -> FileUtils.writeFileContents((File)slnConnectionFile, (String)solutionPath.toAbsolutePath().toString()));
        }
        catch (IOException e) {
            Activator.reporter.logError("Failed to write project's solution connection file at " + slnConnectionFile.toString(), (Throwable)e);
        }
    }

    public static Optional<File> findSolutionConnectionFile(Path projectPath) {
        File projectDir = projectPath.normalize().toFile().getParentFile();
        List<File> projectFiles = Arrays.asList(projectDir.listFiles());
        return projectFiles.stream().filter(projectFile -> projectFile.getName().equals(SLN_CONNECTION_FILENAME)).findFirst();
    }

    private static Document parse(InputStream in) throws IOException {
        InputSource input = new InputSource(in);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setIgnoringComments(false);
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(input);
            return doc;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Failed to parse input", e);
        }
    }

    public static IarProjectConnectionType loadProjectConnection(File ipcfFile) {
        IarProjectConnectionResourceFactoryImpl factory = new IarProjectConnectionResourceFactoryImpl();
        Resource resource = factory.createResource(URI.createFileURI((String)ipcfFile.getAbsolutePath()));
        try {
            IarEwProjectUtils.lockFileAccess(ipcfFile, () -> resource.load(null));
        }
        catch (IOException e) {
            Activator.reporter.logError("failed to load " + String.valueOf(ipcfFile), (Throwable)e);
            return null;
        }
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        if (root == null) {
            return null;
        }
        IarProjectConnectionType ipcf = root.getIarProjectConnection();
        if (ipcf instanceof IarProjectConnectionTypeImpl) {
            ((IarProjectConnectionTypeImpl)ipcf).setLoadedFile(ipcfFile);
        }
        return ipcf;
    }

    public static void writeIpcfFile(IarProjectConnectionType model, File ipcfFile) {
        String ipcfStr = IarEwProjectUtils.serializeProjectConnection(model);
        if (TextUtils.isEmpty((String)ipcfStr)) {
            return;
        }
        IarEwProjectUtils.lockFileAccess(ipcfFile, () -> {
            try {
                ipcfFile.getParentFile().mkdirs();
                FileUtils.writeFileContents((File)ipcfFile, (String)ipcfStr);
            }
            catch (IOException e) {
                Activator.reporter.logError("Failed to write IAR ipcf file to disk!", (Throwable)e);
            }
        });
    }

    public static String serializeProjectConnection(IarProjectConnectionType model) {
        IarProjectConnectionResourceFactoryImpl factory = new IarProjectConnectionResourceFactoryImpl();
        Resource rsrc = factory.createResource(null);
        rsrc.getContents().add((Object)model);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            rsrc.save((OutputStream)bos, null);
        }
        catch (IOException e) {
            Activator.reporter.logError("failed to convert ipcf model to string", (Throwable)e);
            return "";
        }
        return new String(bos.toByteArray());
    }

    public static Path getAbsoluteProjectPath(String relProjPath, Path wsDirPath) {
        Path resultProjPath;
        String resultProjPathStr = relProjPath.replace(IAR_PATH_SEP, File.separator);
        if (resultProjPathStr.contains(VAR_WS_DIR)) {
            resultProjPathStr = resultProjPathStr.replace(VAR_WS_DIR, wsDirPath.toString());
        }
        if (!(resultProjPath = Path.of(resultProjPathStr, new String[0])).toFile().isFile()) {
            Activator.reporter.logException((Throwable)new Exception("Invalid project path created in getProjectPathInWs: " + resultProjPath.toString()));
        }
        return resultProjPath.normalize();
    }

    public static String getRelativeWsProjectPath(File projectFile, Path slnPath) {
        String relProjPath = StudioExporterUtils.getRelativePath(projectFile, false, slnPath);
        relProjPath = relProjPath.replace("/", IAR_PATH_SEP);
        relProjPath = relProjPath.replace("$0$", "$WS_DIR$\\");
        return relProjPath;
    }

    public static IarProjectConnectionType getSlnIwcf(Path slnPath) {
        File slnIwcfFile = FileUtils.replaceFileExtension((File)slnPath.toFile(), (String)EXTENSION_IWCF);
        if (slnIwcfFile.isFile()) {
            IarProjectConnectionType slnIpcf = IarEwProjectUtils.loadProjectConnection(slnIwcfFile);
            return slnIpcf;
        }
        return null;
    }

    public static boolean isEwwStudioGenerated(File ewwFile) {
        try {
            String ewwContents = FileUtils.readFileContents((Path)ewwFile.toPath(), (Charset)StandardCharsets.UTF_8);
            return ewwContents.contains(STUDIO_GENERATED_COMMENT);
        }
        catch (IOException e) {
            Activator.reporter.logError("Failed to read eww file " + ewwFile.toPath().toString(), (Throwable)e);
            return false;
        }
    }

    public static String getStudioBatchDefName(String solutionName) {
        return "StudioBatchDef_" + solutionName;
    }
}

