/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.ExternalSolutionModelHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwProjectUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwwBuildActionsController;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwwBuiltinController;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwwProjectCacheController;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarIpcfModelUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionFactory;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.StudioMetadata;
import java.io.File;
import java.util.List;

public class IarEwwMetadataHandler
extends ExternalProjectMetadataHandler<MSolution, IarEwwMetadataHandler> {
    private IarProjectConnectionType ipcf;
    private ExternalSolutionModelHandler modules;
    private IarEwwBuiltinController builtins;
    private IarEwwBuildActionsController buildActions;
    private IarEwwProjectCacheController projectCache;

    public static IarEwwMetadataHandler load(IarProjectConnectionType loadFrom, IarProjectConnectionType writeTo) {
        return ((IarEwwMetadataHandler)new IarEwwMetadataHandler(loadFrom).load()).updateIpcf(writeTo);
    }

    public static IarEwwMetadataHandler load(File slnFile) {
        IarProjectConnectionType slnIwcf = IarEwProjectUtils.getSlnIwcf(slnFile.toPath());
        if (slnIwcf == null) {
            return new IarEwwMetadataHandler(IarIpcfModelUtils.createStudioIpcf());
        }
        IarEwwMetadataHandler slnMetadata = (IarEwwMetadataHandler)new IarEwwMetadataHandler(slnIwcf).load();
        return slnMetadata;
    }

    public IarEwwMetadataHandler(IarProjectConnectionType ipcf) {
        this.ipcf = ipcf;
    }

    public ExternalSolutionModelHandler solution() {
        return this.modules;
    }

    public IarEwwBuiltinController builtins() {
        return this.builtins;
    }

    public IarEwwBuildActionsController slnBuildActions() {
        return this.buildActions;
    }

    public IarEwwProjectCacheController projectsCache() {
        return this.projectCache;
    }

    public IarProjectConnectionType getIpcfWithMetadata() {
        return this.ipcf;
    }

    public IarEwwMetadataHandler updateIpcf(IarProjectConnectionType newIpcf) {
        newIpcf.setStudioMetadata(IarEwwMetadataHandler.getMetadata(this.ipcf));
        this.ipcf = newIpcf;
        return this;
    }

    public void reloadCurrentIpcf() {
        if (this.ipcf != null) {
            this.ipcf = IarEwProjectUtils.loadProjectConnection(this.ipcf.loadedFile());
        }
    }

    @Override
    protected void loadMetadataHandlers(List<IExternalProjectMetadata<MSolution>> handlers) {
        this.modules = new ExternalSolutionModelHandler();
        this.builtins = new IarEwwBuiltinController();
        this.buildActions = new IarEwwBuildActionsController();
        this.projectCache = new IarEwwProjectCacheController();
        handlers.add(this.modules);
        handlers.add(this.builtins);
        handlers.add(this.buildActions);
        handlers.add(this.projectCache);
    }

    @Override
    protected void writeStringContent(String metadata) {
        IarEwwMetadataHandler.getMetadata(this.ipcf).setMetadata(metadata);
    }

    @Override
    protected String getStringContent() {
        StudioMetadata metadata = IarEwwMetadataHandler.getMetadata(this.ipcf);
        if (TextUtils.isEmpty((String)metadata.getMetadata())) {
            return "";
        }
        return metadata.getMetadata();
    }

    private static StudioMetadata getMetadata(IarProjectConnectionType ipcf) {
        if (ipcf == null) {
            return IarProjectConnectionFactory.eINSTANCE.createStudioMetadata();
        }
        StudioMetadata metadata = ipcf.getStudioMetadata();
        if (metadata == null) {
            metadata = IarProjectConnectionFactory.eINSTANCE.createStudioMetadata();
        }
        ipcf.setStudioMetadata(metadata);
        return metadata;
    }
}

