/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.CollectionUtils;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectConfiguration;
import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectEntry;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.api.core.utils.ProjectFileUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARExternalProjectImporter;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARElement;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwpModelUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Node;

public class IAREntry
extends IARElement
implements IExternalProjectEntry {
    private static final String ELEMENT_CONFIGURATION = "configuration";
    private static final String ELEMENT_EXCLUDED = "excluded";
    private List<IARConfiguration> configurations;
    private ImmutableList<String> excludedConfigurations;
    private File file;
    private IPath projectFolder;
    private Map<String, String> variableReplacements;
    private ImporterTool.ToolchainID projectToolchainID;

    public IAREntry(Node entryNode, IPath projectFolder, ImporterTool.ToolchainID projectToolchainID) {
        super(entryNode);
        this.projectFolder = projectFolder;
        this.configurations = new ArrayList<IARConfiguration>();
        this.file = null;
        this.projectToolchainID = projectToolchainID;
        ImmutableList.Builder exclusions = ImmutableList.builder();
        for (Node excludedNode : this.childNodes().get((Object)ELEMENT_EXCLUDED)) {
            List excludedConfigs = IarEwpModelUtils.getChildNodes(excludedNode).get((Object)ELEMENT_CONFIGURATION);
            for (Node excludedConfigNode : excludedConfigs) {
                exclusions.add((Object)excludedConfigNode.getTextContent());
            }
        }
        this.excludedConfigurations = exclusions.build();
    }

    protected void addConfigurations(Map<String, String> replacements) {
        for (Node configNode : this.childNodes().get((Object)ELEMENT_CONFIGURATION)) {
            this.configurations.add(new IARConfiguration(configNode, this.projectFolder, replacements, this.projectToolchainID));
        }
    }

    protected void checkForLibraries() {
        if (ProjectFileUtils.isLibraryFile(this.file())) {
            for (IARConfiguration config : this.configurations) {
                if (this.excludedConfigurations.contains((Object)config.getName())) continue;
                MLibraryPath mLibraryPath = ProjectImportUtils.createMLibraryPathFromString(this.file().getAbsolutePath(), config.projectFolder().toFile().toURI(), config.variableReplacements, IARExternalProjectImporter.VARIABLE_PATTERN, config.getUnconvertedVariables());
                config.getBuildSettings().add(mLibraryPath);
            }
        }
    }

    @Override
    public IExternalProjectConfiguration getTargetConfiguration() {
        return null;
    }

    public void setExcludedConfigurationNames(Collection<String> newExclusions) {
        this.excludedConfigurations = ImmutableList.copyOf(newExclusions);
        this.childNodes().removeAll((Object)ELEMENT_EXCLUDED);
        if (this.excludedConfigurations.isEmpty()) {
            return;
        }
        LinkedHashMap nameKeyMap = (LinkedHashMap)newExclusions.stream().collect(CollectionUtils.toMap(c -> ELEMENT_CONFIGURATION, c -> c, LinkedHashMap::new));
        this.createSubNode(nameKeyMap, ELEMENT_EXCLUDED);
    }

    public ImmutableList<String> getExcludedConfigurationNames() {
        return this.excludedConfigurations;
    }

    public File file() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public ImporterTool.ToolchainID projectToolchainID() {
        return this.projectToolchainID;
    }

    public IPath projectFolder() {
        return this.projectFolder;
    }

    @Override
    public String getAbsPath() {
        return this.file.getAbsolutePath();
    }

    public List<IARConfiguration> getConfigurations() {
        return this.configurations;
    }

    public Map<String, String> getVariableReplacements() {
        return this.variableReplacements;
    }

    public void setVariableReplacements(Map<String, String> variableReplacements) {
        this.variableReplacements = variableReplacements;
    }

    public String toString() {
        return this.getName();
    }
}

