/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.internal.api.core.external.impl.PropertyInfo;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.BaseIAROption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.BooleanOption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.CCAllowListOption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARChipSelect;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IAROutputFile;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IAROutputName;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IIARConfigurationInfo;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.StringListOption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.StringOption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.URIListOption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.URIOption;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Node;

public class IAROptionFactory {
    public static List<BaseIAROption<?>> makeOptions(Node optionNode, ImporterTool.ToolType toolType, IPath projectFolder, IIARConfigurationInfo configInfo) {
        String type;
        ImporterTool.ToolchainID toolchainID = configInfo.toolchain();
        ArrayList options = new ArrayList();
        BaseIAROption baseOpt = new BaseIAROption(optionNode);
        String optionId = baseOpt.getId();
        PropertyInfo propertyInfo = configInfo.property(optionId, toolType);
        String optionName = baseOpt.getName();
        if (propertyInfo == null) {
            type = "stringList";
        } else {
            IProperty iProperty = propertyInfo.getProperty();
            type = iProperty.getType().getName();
        }
        if (CCAllowListOption.isApplicable(optionName)) {
            options.addAll(CCAllowListOption.options(optionNode, toolchainID));
        } else if ("string".equals(type) || IAROptionFactory.isOtherStringOption(configInfo, optionName)) {
            options.add(new StringOption(optionNode));
        } else if ("stringList".equals(type)) {
            options.add(new StringListOption(optionNode));
        } else if ("uri".equals(type)) {
            options.add(new URIOption(optionNode));
        } else if ("uriList".equals(type)) {
            options.add(new URIListOption(optionNode, projectFolder));
        } else if ("boolean".equals(type)) {
            options.add(new BooleanOption(optionNode));
        }
        for (BaseIAROption baseIAROption : options) {
            String optId = baseIAROption.getId();
            PropertyInfo optPropertyInfo = configInfo.property(optId, toolType);
            if (optPropertyInfo == null) continue;
            baseIAROption.setProperty(optPropertyInfo.getProperty());
        }
        return options;
    }

    private static boolean isOtherStringOption(IIARConfigurationInfo configInfo, String optionName) {
        return IARChipSelect.isManaged(optionName) || IAROutputName.isManaged(optionName) || IAROutputFile.isManaged(optionName);
    }
}

