/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile.options;

import com.google.common.collect.ImmutableMap;
import com.silabs.ss.framework.project.api.core.external.options.GenericAssemblerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCCompilerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCLinkerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCppCompilerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericToolchainOptions;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.options.BaseOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.GenericOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.OptionMappingRegistryFactory;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileArmGccExternalOptions;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileCommonGccGenericOptionMappings;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileOptionMappingUtils;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.util.Map;

public class MakefileArmGccGenericOptionMapper {
    private static final Map<String, String> mapReplacements = ImmutableMap.of((Object)"", (Object)"$project/");
    private static final MakefileOptionMappingUtils<MakefileArmGccExternalOptions.GccCompilerBase> mapper = new MakefileOptionMappingUtils<MakefileArmGccExternalOptions.GccCppCompiler>((MakefileArmGccExternalOptions.GccCppCompiler)((Object)MakefileArmGccExternalOptions.C_COMPILER), MakefileArmGccExternalOptions.CPP_COMPILER);

    public static IGenericOptionMappingRegistry gccRegistry() {
        IGenericOptionMappingRegistry makefileGccOptionMappingRegistry = OptionMappingRegistryFactory.INSTANCE.createGenericOptionMappingRegistry();
        MakefileArmGccGenericOptionMapper.setupToolchainOptions(makefileGccOptionMappingRegistry);
        MakefileArmGccGenericOptionMapper.setupCompilerOptions(makefileGccOptionMappingRegistry);
        MakefileArmGccGenericOptionMapper.setupAssemblerOptions(makefileGccOptionMappingRegistry);
        MakefileArmGccGenericOptionMapper.setupLinkerOptions(makefileGccOptionMappingRegistry);
        return makefileGccOptionMappingRegistry;
    }

    private static void setupToolchainOptions(IGenericOptionMappingRegistry makefileGccOptionMappingRegistry) {
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_CPU).mapFromTo(GenericToolchainOptions.Target.CPU, new Object[]{"-mcpu=cortex-m0plus", "cortex-m0+", "-mcpu=cortex-m3", "cortex-m3", "-mcpu=cortex-m4", "cortex-m4", "-mcpu=cortex-m7", "cortex-m7", "-mcpu=cortex-m23", "cortex-m23", "-mcpu=cortex-m33", "cortex-m33", "-mcpu=cortex-m35p", "cortex-m35p", "-mcpu=cortex-m55", "cortex-m55"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_THUMB).mapFromTo(GenericToolchainOptions.Target.THUMB_MODE, new Object[]{"-mthumb", true, "-marm", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_FPU).mapFromTo(GenericToolchainOptions.Target.FPU, new Object[]{"-mfpu=fpv4-sp-d16", "fpv4-sp", "-mfpu=fpv5-sp-d16", "fpv5-sp"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_FLOAT_ABI).mapFromTo(GenericToolchainOptions.Target.FLOAT_ABI, new Object[]{"-mfloat-abi=soft", "soft", "-mfloat-abi=softfp", "softfp", "-mfloat-abi=hard", "hard"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
    }

    private static void setupCompilerOptions(IGenericOptionMappingRegistry makefileGccOptionMappingRegistry) {
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.C_COMPILER.GCC_COMPILER_C_STANDARD).mapFromTo(GenericCCompilerOptions.Language.C_STANDARD, new Object[]{"-std=c90", "c90", "-std=c99", "c99", "-std=c11", "c11", "-std=c18", "c18"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.CPP_COMPILER.GCC_COMPILER_CXX_STANDARD).mapFromTo(GenericCppCompilerOptions.Language.CXX_STANDARD, new Object[]{"-std=c++98", "c++98", "-std=c++11", "c++11", "-std=c++14", "c++14", "-std=c++17", "c++17", "-std=gnu++17", "gnu++17", "-std=c++20", "c++20", "-std=gnu++20", "gnu++20"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.CPP_COMPILER.GCC_COMPILER_CXX_NO_RTTI).forSpecific((Object)"-fno-rtti").mapFalse(new IProperty[]{GenericCppCompilerOptions.Language.CXX_RTTI}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.CPP_COMPILER.GCC_COMPILER_CXX_NO_EXCEPTIONS).forSpecific((Object)"-fno-exceptions").mapFalse(new IProperty[]{GenericCppCompilerOptions.Language.CXX_EXCEPTIONS}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        mapper.mapCxxOptions(o -> o.GCC_GENERATE_SECURE_CODE, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.forSpecific((Object)"-mcmse").mapTrue(new IProperty[]{g.Output().GENERATE_SECURE_CODE}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        new MakefileCommonGccGenericOptionMappings<MakefileArmGccExternalOptions.GccCompilerBase>(makefileGccOptionMappingRegistry, mapper).mapCommonWarnings(o -> o.GCC_COMPILER_WARNINGS_ALL, o -> o.GCC_COMPILER_WARNINGS_EXTRA, o -> o.GCC_COMPILER_WARNINGS_PEDANTIC, o -> o.GCC_COMPILER_WARNINGS_ARE_ERRORS);
        mapper.mapCxxOptions(o -> o.GCC_COMPILER_STACK_PROTECTION, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.forSpecific((Object)"-fstack-protector").mapTrue(new IProperty[]{g.Warnings().STACK_PROTECTION}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        mapper.mapCxxOptions(o -> o.GCC_COMPILER_OPTIMIZATION, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.mapFromTo(g.Optimizer().OPTIMIZATION, new Object[]{"-O0", "none", "-Og", "debug", "-O1", "low", "-O2", "medium", "-O3", "speed", "-Os", "size"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        mapper.mapCxxOptions(o -> o.GCC_DATA_SECTIONS, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.forSpecific((Object)"-fdata-sections").mapTrue(new IProperty[]{g.Optimizer().DATA_SECTIONS}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        mapper.mapCxxOptions(o -> o.GCC_FUNCTION_SECTIONS, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.forSpecific((Object)"-ffunction-sections").mapTrue(new IProperty[]{g.Optimizer().FUNCTION_SECTIONS}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        mapper.mapCxxOptions(o -> o.GCC_OMIT_FRAME_POINTER, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.forSpecific((Object)"-fomit-frame-pointer").mapTrue(new IProperty[]{g.Optimizer().OMIT_FRAME_POINTER}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        mapper.mapCxxOptions(o -> o.GCC_COMPILER_DEBUG_LEVEL, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.mapFromTo(g.Debug().DEBUG_LEVEL, new Object[]{"-g0", "none", "-g1", "minimal", "-g", "default", "-g3", "maximum"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        mapper.mapCxxOptions(o -> o.GCC_COMPILER_NO_BUILTIN, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.forSpecific((Object)"-fno-builtin").mapTrue(new IProperty[]{g.Debug().NO_BUILTIN}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        mapper.mapCxxOptions(o -> o.GCC_NANO_C_LIBS, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.forSpecific((Object)"--specs=nano.specs").mapTrue(new IProperty[]{g.Libraries().NANO_C_LIBRARIES}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        mapper.mapCxxOptions(o -> o.GCC_COMPILER_PREINCLUDE, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.mapTo(g.Preprocessor().PREINCLUDE).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
        mapper.mapCxxOptions(o -> o.GCC_COMPILER_MISC, (f, g) -> {
            BaseOptionMappingFactory baseOptionMappingFactory = f.mapTo(g.MISC).mapToReplacing(g.VARIABLE_MISC, mapReplacements).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        });
    }

    private static void setupAssemblerOptions(IGenericOptionMappingRegistry makefileGccOptionMappingRegistry) {
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_ASSEMBLER_WARNINGS_ALL).forSpecific((Object)"-Wall").mapTrue(new IProperty[]{GenericAssemblerOptions.Warnings.INCORRECT_CODE}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_ASSEMBLER_WARNINGS_EXTRA).forSpecific((Object)"-Wextra").mapTrue(new IProperty[]{GenericAssemblerOptions.Warnings.EXTRA}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_ASSEMBLER_WARNINGS_ARE_ERRORS).forSpecific((Object)"-Werror").mapTrue(new IProperty[]{GenericAssemblerOptions.Warnings.WARNINGS_ARE_ERRORS}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_ASSEMBLER_PREINCLUDE).mapTo(GenericAssemblerOptions.Preprocessor.PREINCLUDE).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_ASSEMBLER_MISC).mapTo(GenericAssemblerOptions.MISC).mapToReplacing(GenericAssemblerOptions.VARIABLE_MISC, mapReplacements).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
    }

    private static void setupLinkerOptions(IGenericOptionMappingRegistry makefileGccOptionMappingRegistry) {
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_LINKER_SCRIPT).mapToReplacing(GenericCLinkerOptions.Output.LINKER_SCRIPT, mapReplacements).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_NANO_C_LIBS).forSpecific((Object)"--specs=nano.specs").mapTrue(new IProperty[]{GenericCLinkerOptions.Libraries.NANO_C_LIBRARIES}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_REMOVED_UNUSED_SECTIONS).forSpecific((Object)"-Wl,--gc-sections").mapTrue(new IProperty[]{GenericCLinkerOptions.Optimizing.REMOVED_UNUSED_SECTIONS}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_GENERATE_LINKER_MAP).forSpecific((Object)"-Xlinker -Map=$(OUTPUT_DIR)/$(PROJECTNAME).map").mapTrue(new IProperty[]{GenericCLinkerOptions.Output.GENERATE_LINK_MAP}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_LINKER_MISC).mapTo(GenericCLinkerOptions.instance.MISC).mapToReplacing(GenericCLinkerOptions.instance.VARIABLE_MISC, mapReplacements).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_ENABLE_TRUSTZONE_GENERATE).forSpecific((Object)"-Xlinker --cmse-implib").mapTrue(new IProperty[]{GenericCLinkerOptions.Output.ENABLE_TRUSTZONE_GENERATE}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)MakefileArmGccExternalOptions.GCC_TRUSTZONE_LIB_NAME).mapToReplacing(GenericCLinkerOptions.Output.TRUSTZONE_LIB_NAME, (Map)ImmutableMap.of((Object)"$(OUTPUT_DIR)/%1", (Object)"")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)makefileGccOptionMappingRegistry);
    }
}

