/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.ses;

import com.google.common.collect.ImmutableMap;
import com.silabs.ss.framework.project.api.core.external.options.GenericAssemblerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCCompilerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCLinkerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCppCompilerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericCppLinkerOptions;
import com.silabs.ss.framework.project.api.core.external.options.GenericToolchainOptions;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.options.GenericOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.OptionMappingRegistryFactory;
import com.silabs.ss.framework.project.internal.core.type.ses.SESArmExternalOptions;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.util.Map;

public class SESGenericOptionsMapper {
    private static IGenericOptionMappingRegistry sesOptionMappingRegistry;
    private static final Map<String, String> REPLACEMENT_MAP;

    static {
        REPLACEMENT_MAP = ImmutableMap.of((Object)"", (Object)"$project/");
    }

    private SESGenericOptionsMapper() {
    }

    public static IGenericOptionMappingRegistry sesOptionRegistry() {
        if (sesOptionMappingRegistry == null) {
            IGenericOptionMappingRegistry setupOptionRegistry = OptionMappingRegistryFactory.INSTANCE.createGenericOptionMappingRegistry();
            SESGenericOptionsMapper.setupToolchainOptions(setupOptionRegistry);
            SESGenericOptionsMapper.setupCompilerOptions(setupOptionRegistry);
            SESGenericOptionsMapper.setupAssemblerOptions(setupOptionRegistry);
            SESGenericOptionsMapper.setupLinkerOptions(setupOptionRegistry);
            sesOptionMappingRegistry = setupOptionRegistry;
        }
        return sesOptionMappingRegistry;
    }

    private static void setupToolchainOptions(IGenericOptionMappingRegistry sesOptionMappingRegistry) {
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.ARM_CORE_TYPE).mapFromTo(GenericToolchainOptions.Target.CPU, new Object[]{"Cortex-M0+", "cortex-m0+", "Cortex-M3", "cortex-m3", "Cortex-M4", "cortex-m4", "Cortex-M7", "cortex-m7", "Cortex-M23", "cortex-m23", "Cortex-M33", "cortex-m33", "Cortex-M35P", "cortex-m35p", "Cortex-M55", "cortex-m55"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.ARM_INTERWORK).mapFromTo(GenericToolchainOptions.Target.THUMB_MODE, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.ARM_FPU_TYPE).mapFromTo(GenericToolchainOptions.Target.FPU, new Object[]{"None", "none", "FPv4-SP-D16", "fpv4-sp", "FPv5-SP-D16", "fpv5-sp"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.ARM_FP_ABI).mapFromTo(GenericToolchainOptions.Target.FLOAT_ABI, new Object[]{"Soft", "soft", "SoftFP", "softfp", "Hard", "hard"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.TOOLCHAIN_TREAT_WARNINGS_AS_ERRORS).mapFromTo(GenericAssemblerOptions.Warnings.WARNINGS_ARE_ERRORS, new Object[]{"Yes", true, "No", false}).mapFromTo(GenericCCompilerOptions.Warnings.WARNINGS_ARE_ERRORS, new Object[]{"Yes", true, "No", false}).mapFromTo(GenericCppCompilerOptions.Warnings.WARNINGS_ARE_ERRORS, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
    }

    private static void setupCompilerOptions(IGenericOptionMappingRegistry sesOptionMappingRegistry) {
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_C_STANDARD).mapFromTo(GenericCCompilerOptions.Language.C_STANDARD, new Object[]{"c90", "c90", "c99", "c99", "c11", "c11", "c18", "c18"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_CXX_STANDARD).mapFromTo(GenericCppCompilerOptions.Language.CXX_STANDARD, new Object[]{"c++98", "c++98", "c++11", "c++11", "c++14", "c++14", "c++17", "c++17", "gnu++17", "gnu++17", "c++20", "c++20", "gnu++20", "gnu++20"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_CXX_ENABLE_RTTI).mapFromTo(GenericCppCompilerOptions.Language.CXX_RTTI, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_CXX_ENABLE_EXCEPTIONS).mapFromTo(GenericCppCompilerOptions.Language.CXX_EXCEPTIONS, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_WARNINGS_ALL).mapFromTo(GenericCCompilerOptions.Warnings.INCORRECT_CODE, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_SUPPRESS_WARNINGS).mapFromTo(GenericCCompilerOptions.Warnings.SUPPRESS_WARNINGS, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_OPTIMIZATION).mapFromTo(GenericCCompilerOptions.Optimizer.OPTIMIZATION, new Object[]{"None", "none", "Level 0", "debug", "Level 1", "low", "Level 2 for speed", "speed", "Level 2 balanced", "medium", "Level 3", "size"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_OMIT_FRAME_POINTER).mapFromTo(GenericCCompilerOptions.Optimizer.OMIT_FRAME_POINTER, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_DEBUGGING_LEVEL).mapFromTo(GenericCCompilerOptions.Debug.DEBUG_LEVEL, new Object[]{"None", "none", "Level 1", "minimal", "Level 2", "default", "Level 3", "maximum"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_USE_BUILTINS).mapFromTo(GenericCCompilerOptions.Debug.NO_BUILTIN, new Object[]{"No", true, "Yes", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_BUILD_DEBUG_INFO).mapFromTo(GenericCCompilerOptions.Debug.GENERATE_SYMBOLS, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_KEEP_ASSEMBLY).mapFromTo(GenericCCompilerOptions.Output.GENERATE_ASSEMBLY, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_KEEP_PREPROCESSED_OUTPUT).mapFromTo(GenericCCompilerOptions.Output.GENERATE_PREPROCESSED, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_SYSTEM_INCLUDE_DIRS).mapTo(GenericCCompilerOptions.Preprocessor.SYSTEM_INCLUDE_PATHS).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_PREPROCESSOR_DEFINES).mapTo(GenericCCompilerOptions.Preprocessor.DEFINE_MACROS).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_PREPROCESSOR_UNDEFINES).mapTo(GenericCCompilerOptions.Preprocessor.UNDEFINE_MACROS).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_PREPROCESSOR_UNDEFINE_ALL).mapFromTo(GenericCCompilerOptions.Preprocessor.NO_SYSTEM_MACROS, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_IGNORE_INCLUDES).mapFromTo(GenericCCompilerOptions.Preprocessor.NO_STANDARD_INCLUDES, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_C_ONLY_ADDITIONAL).mapTo(GenericCCompilerOptions.instance.MISC).mapToReplacing(GenericCCompilerOptions.instance.VARIABLE_MISC, REPLACEMENT_MAP).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_CPP_ONLY_ADDITIONAL).mapTo(GenericCppCompilerOptions.instance.MISC).mapToReplacing(GenericCppCompilerOptions.instance.VARIABLE_MISC, REPLACEMENT_MAP).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_ADDITIONAL).mapFromTo(GenericCCompilerOptions.Output.GENERATE_SECURE_CODE, new Object[]{"-mcmse", true}).mapTo(GenericCCompilerOptions.instance.MISC).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
    }

    private static void setupAssemblerOptions(IGenericOptionMappingRegistry sesOptionMappingRegistry) {
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.ASSEMBLER_ADDITIONAL).mapTo(GenericAssemblerOptions.MISC).mapToReplacing(GenericAssemblerOptions.VARIABLE_MISC, REPLACEMENT_MAP).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_SUPPRESS_WARNINGS).mapFromTo(GenericAssemblerOptions.Warnings.SUPPRESS_WARNINGS, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.COMPILER_BUILD_DEBUG_INFO).mapFromTo(GenericAssemblerOptions.Debug.ENABLED, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
    }

    private static void setupLinkerOptions(IGenericOptionMappingRegistry sesOptionMappingRegistry) {
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.LINKER_SCRIPT_FILE).mapToReplacing(GenericCLinkerOptions.Output.LINKER_SCRIPT, REPLACEMENT_MAP).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.USE_LINKER_SCRIPT_FILE).mapFromTo(GenericCLinkerOptions.Output.USE_LINKER_SCRIPT, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.GENERATE_LINKER_MAP_FILE).mapFromTo(GenericCLinkerOptions.Output.GENERATE_LINK_MAP, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.GENERATE_LINKER_MAP_FILE).mapFromTo(GenericCppLinkerOptions.Output.GENERATE_LINK_MAP, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.LINKER_SYMBOL_DEFINITIONS).mapTo(GenericCLinkerOptions.Symbols.EXPORT_SYMBOLS).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.LINKER_REMOVE_UNUSED_SYMBOLS).mapFromTo(GenericCLinkerOptions.Optimizing.REMOVED_UNUSED_SECTIONS, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.LINKER_STRIP_SYMBOLS).mapFromTo(GenericCLinkerOptions.Symbols.STRIP_SYMBOLS, new Object[]{"Yes", true, "No", false}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
        GenericOptionMappingFactory.with((IProperty)SESArmExternalOptions.LINKER_ADDITIONAL).mapTo(GenericCLinkerOptions.instance.MISC).mapToReplacing(GenericCLinkerOptions.instance.VARIABLE_MISC, REPLACEMENT_MAP).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)sesOptionMappingRegistry);
    }
}

