/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.ses;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.KeyedVariableLookup;
import com.silabs.java.utils.variables.engine.CoreOperatorHandler;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.IVariableSubstitutionEngine;
import com.silabs.java.utils.variables.engine.StockVariables;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.BaseExternalProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.ICopiedFileReference;
import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.AddIncludePathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryFileSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryPathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddMacroDefinitionSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectResourceFilterOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddSourceFolderToConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddToolOptionOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ExcludeResourceFromConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IHandleFileProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IHandleFolderProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectLanguageSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IncludeResourceIntoConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.RemoveProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.RemoveProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ResetModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationOutputBaseNameOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPrebuildStepOperation;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.StudioExporterUtils;
import com.silabs.ss.framework.project.internal.core.type.ses.SESArmExternalOptions;
import com.silabs.ss.framework.project.internal.core.type.ses.SESMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.ses.SESModelUtils;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESConfiguration;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESConfigurationContainer;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESEntry;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESFile;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESFolder;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESModelFactory;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESModelPackage;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESProject;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESSolution;
import com.silabs.ss.platform.api.content.part.core.IPart;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import com.silabs.ss.support.mcu.api.part.core.si32.EARMCore;
import com.silabs.ss.support.mcu.api.part.core.si32.EFPUIdentifier;
import com.silabs.ss.support.mcu.api.part.core.si32.Si32PartUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class SESProjectOperationHandler
extends BaseExternalProjectEngineOperationHandler
implements IProjectEngineOperationHandler {
    public static final String STUDIO_CONFIG_NAME = "Simplicity_Configuration_Content";
    private final EClass sesConfigClass;
    private File sesProjFile;
    private SESSolution sesModel;
    private SESProject sesProject;
    private SESConfiguration studioSolutionConfig;
    private SESConfiguration studioProjectConfig;
    private SESConfiguration userConfig;
    private IProjectDescriptor projDesc;
    private SESMetadataHandler sesMetadata;
    private Collection<String> removedFilePaths;
    private Collection<String> removedFolderPaths;
    private Collection<Pair<String, String>> addedFilePaths;
    private Collection<String> addedFolderPaths;
    private final IVariableSubstitutionEngine standardEngine;
    private IVariableStore projectVariables;
    private Path generationDir;
    private Multimap<SESConfiguration, String> addedLibraryFiles;
    private Multimap<SESConfiguration, String> addedLibraryNames;
    private Multimap<SESConfiguration, String> addedUserIncludePaths;
    private Map<SESConfiguration, Map<ELanguage, Map<String, String>>> configMacros;
    private Multimap<IPath, String> filesToExclude;
    public static final Map<IProperty, String> DEFAULT_ARM_CORE_SETTINGS = Map.of(SESArmExternalOptions.ARM_TARGET_INTERFACE_TYPE, "SWD", SESArmExternalOptions.DEBUG_START_FROM_ENTRY_POINT_SYMBOL, "No", SESArmExternalOptions.DEBUG_TARGET_CONNECTION, "J-Link", SESArmExternalOptions.BUILD_OPTIONS, "ARM GNU", SESArmExternalOptions.USE_COMPILER_DRIVER, "No", SESArmExternalOptions.BUILD_GENERIC_OPTIONS_FILE_NAME, "$(StudioDir)/targets/ARMGNU_build_options.xml");
    public static final Set<IProperty> PART_SELECTION_CONFIG_OPTIONS = Set.of(SESArmExternalOptions.ARM_ARCHITECTURE, SESArmExternalOptions.ARM_FPU_TYPE, SESArmExternalOptions.ARM_CORE_TYPE, SESArmExternalOptions.ARM_ENDIAN, SESArmExternalOptions.ARM_TARGET_DEVICE_NAME);
    private static final String DEFAULT_CORE = "Cortex-M33";

    public SESProjectOperationHandler(IProjectDescriptor projDesc) {
        this(null, projDesc);
    }

    public SESProjectOperationHandler(IExternalProjectEntity projEnt) {
        this(projEnt, (IProjectDescriptor)projEnt.getDescriptor());
    }

    private SESProjectOperationHandler(IExternalProjectEntity projEnt, IProjectDescriptor projDesc) {
        super(projEnt);
        this.projDesc = projDesc;
        this.standardEngine = VariableSubstitutionEngine.create((char)'(', (IOperatorHandler)CoreOperatorHandler.INSTANCE, (boolean)false);
        this.removedFilePaths = new HashSet<String>();
        this.addedFilePaths = new HashSet<Pair<String, String>>();
        this.removedFolderPaths = new HashSet<String>();
        this.addedFolderPaths = new HashSet<String>();
        this.addedLibraryFiles = LinkedHashMultimap.create();
        this.addedLibraryNames = LinkedHashMultimap.create();
        this.addedUserIncludePaths = LinkedHashMultimap.create();
        this.configMacros = new HashMap<SESConfiguration, Map<ELanguage, Map<String, String>>>();
        this.sesConfigClass = SESModelPackage.eINSTANCE.getSESConfiguration();
        this.filesToExclude = LinkedHashMultimap.create();
    }

    public SESProject getProject() {
        return this.sesProject;
    }

    @Override
    public IProjectDescriptor getProjectDescriptor() {
        return this.projDesc;
    }

    @Override
    public void load() throws CoreException {
        IBuildConfiguration bConf = this.getTargetConfig();
        this.projectVariables = new KeyedVariableLookup();
        StockVariables.INSTANCE.setVariables(this.projectVariables, (Object)bConf);
        this.generationDir = this.getProjectEntity().getInstallationFile().getParentFile().toPath();
        this.projectVariables.setValue("projectLocation", (Object)this.generationDir);
        this.sesProjFile = FileUtils.replaceFileExtension((File)this.getProjectEntity().getInstallationFile(), (String)"emProject");
        if (this.sesProjFile.isFile()) {
            this.sesModel = SESModelUtils.loadSESSolution(this.sesProjFile);
        }
        if (this.sesModel == null) {
            this.sesModel = SESModelFactory.eINSTANCE.createSESSolution();
        }
        this.sesModel.setName(this.projDesc.getName());
        this.sesProject = SESModelUtils.findOrCreateProject(this.sesModel, this.projDesc.getName());
        this.userConfig = SESModelUtils.findOrCreateConfiguration(this.getTargetConfig().getName(), this.sesModel);
        this.userConfig.setInherited_configurations(STUDIO_CONFIG_NAME);
        this.sesMetadata = (SESMetadataHandler)new SESMetadataHandler(this.sesProject).load();
        this.sesMetadata.modules().resetPdms();
        this.sesMetadata.modules().resetRefs();
        this.sesMetadata.properties().add(bConf);
        this.getVariableAsStringInMetadata("sdkInstallationPath").ifPresent(this.sesMetadata.variables()::addSdkPath);
        this.getVariableAsStringInMetadata("toolchainInstallationPath").ifPresent(this.sesMetadata.variables()::addToolchainPath);
        this.studioSolutionConfig = this.resetStudioConfig(this.sesModel);
        this.studioProjectConfig = this.resetStudioConfig(this.sesProject);
    }

    private Optional<String> getVariableAsStringInMetadata(String variableName) {
        Path dir = StudioExporterUtils.loadFromVariables(this.projectVariables, variableName);
        return Optional.ofNullable(dir).map(Path::toUri).map(URI::toString);
    }

    private SESConfiguration resetStudioConfig(SESConfigurationContainer container) {
        SESConfiguration config = SESModelUtils.findConfiguration(STUDIO_CONFIG_NAME, container);
        if (config != null) {
            container.getConfigurations().remove((Object)config);
        }
        return SESModelUtils.findOrCreateConfiguration(STUDIO_CONFIG_NAME, container);
    }

    @Override
    public void commit() throws CoreException {
        IPath path;
        for (Pair<String, String> pair : this.addedFilePaths) {
            path = IPathUtils.createPath((String)((String)pair.first));
            if (!this.removedFilePaths.contains(pair.first)) {
                SESFile newFile = SESModelUtils.findOrCreateFile(this.sesProject, path, (String)pair.second);
                String uriFileName = IPathUtils.createPath((String)((String)pair.second)).lastSegment();
                if (!path.lastSegment().equals(uriFileName)) {
                    newFile.setName(path.lastSegment());
                }
                this.clearExclusions(newFile);
                continue;
            }
            this.removedFilePaths.remove(pair.first);
        }
        for (String string : this.addedFolderPaths) {
            path = IPathUtils.createPath((String)string);
            if (!this.removedFilePaths.contains(string)) {
                SESFolder folder = SESModelUtils.findOrCreateFolder(this.sesProject, path);
                this.clearExclusions(folder);
                continue;
            }
            this.removedFolderPaths.remove(string);
        }
        for (String string : this.removedFilePaths) {
            IPath filePath = IPathUtils.createPath((String)string);
            SESFile fileToRemove = SESModelUtils.findFile((SESFolder)this.sesProject, filePath, null);
            if (fileToRemove == null || !(fileToRemove.eContainer() instanceof SESFolder)) continue;
            ((SESFolder)fileToRemove.eContainer()).getFiles().remove((Object)fileToRemove);
        }
        for (String string : this.removedFolderPaths) {
            IPath folderPath = IPathUtils.createPath((String)string);
            SESFolder folderToRemove = SESModelUtils.findFolder((SESFolder)this.sesProject, folderPath);
            if (folderToRemove == null || !(folderToRemove.eContainer() instanceof SESFolder)) continue;
            ((SESFolder)folderToRemove.eContainer()).getFolders().remove((Object)folderToRemove);
        }
        for (Map.Entry entry : this.filesToExclude.entries()) {
            IPath exclusion = (IPath)entry.getKey();
            String config = (String)entry.getValue();
            SESEntry entry2 = SESModelUtils.findFile((SESFolder)this.sesProject, exclusion, null);
            if (entry2 == null) {
                entry2 = SESModelUtils.findFolder((SESFolder)this.sesProject, exclusion);
            }
            if (entry2 == null) continue;
            SESModelUtils.findOrCreateConfiguration(config, entry2).setBuild_exclude_from_build("Yes");
        }
        for (Map.Entry entry : this.configMacros.entrySet()) {
            SESConfiguration sesConfig = (SESConfiguration)entry.getKey();
            Map currentConfigMacros = (Map)entry.getValue();
            for (ELanguage language : currentConfigMacros.keySet()) {
                Map macrosToLanguage = (Map)currentConfigMacros.get(language);
                String updatedMacros = SESModelUtils.stringifySESMacros(macrosToLanguage);
                int languageVal = language.getValue();
                switch (languageVal) {
                    case 1: {
                        sesConfig.setC_preprocessor_definitions(updatedMacros);
                        break;
                    }
                }
            }
        }
        this.commitSpecificOptionListValues(this.addedLibraryFiles, "linker_additional_files");
        this.commitSpecificOptionListValues(this.addedLibraryNames, "linker_additional_system_libraries");
        this.commitSpecificOptionListValues(this.addedUserIncludePaths, "c_user_include_directories");
        this.setToolchainDirectory(this.studioSolutionConfig);
        this.setArmCoreSettings(this.studioSolutionConfig);
        this.setPartSelectionOptionValues(this.studioSolutionConfig);
        this.sesMetadata.write();
        SESModelUtils.writeSESFile(this.sesModel, this.sesProjFile);
    }

    private void clearExclusions(SESEntry entry) {
        entry.getConfigurations().forEach(c -> c.setBuild_exclude_from_build("No"));
    }

    private String getRelativePath(File fileLoc, boolean absolute) {
        String path = StudioExporterUtils.getRelativePath(fileLoc, false, this.generationDir);
        return this.formatPath(path, absolute);
    }

    private String formatPath(String path, boolean absolute) {
        String projRepl = absolute ? "$(ProjectDir)\\" : "";
        String sdkRepl = "";
        return path.replace("\\", "/").replace(StudioExporterUtils.getVariableCounter(0), projRepl).replace(StudioExporterUtils.getVariableCounter(1), sdkRepl);
    }

    @Override
    public void handleRemoveProjectFileOperation(RemoveProjectFileOperation operation, IProgressMonitor monitor) throws CoreException {
        super.handleRemoveProjectFileOperation(operation, monitor);
        this.removedFilePaths.add(operation.getProjectPath().toPortableString());
    }

    @Override
    public void handleRemoveProjectFolderOperation(RemoveProjectFolderOperation operation, IProgressMonitor monitor) throws CoreException {
        super.handleRemoveProjectFolderOperation(operation, monitor);
        this.removedFolderPaths.add(operation.getProjectPath().toPortableString());
    }

    @Override
    public void handleSetConfigurationPrebuildStepOperation(SetConfigurationPrebuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        this.studioSolutionConfig.setPre_build_command(this.substitutePostBuildVariables(operation.getPrebuildStep()));
    }

    @Override
    public void handleSetConfigurationPostbuildStepOperation(SetConfigurationPostbuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        this.studioSolutionConfig.setPost_build_command(this.substitutePostBuildVariables(operation.getPostbuildStep()));
    }

    @Override
    public void handleAddIncludePathSettingOperation(AddIncludePathSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        SESConfiguration sesConfig = this.getConfigToModify(operation);
        File includeDir = StudioExporterUtils.resolvePath(this.standardEngine, this.projectVariables, operation.getUri());
        String includePath = this.getRelativePath(includeDir, false) + "/";
        this.addedUserIncludePaths.put((Object)sesConfig, (Object)includePath);
    }

    @Override
    public void handleAddMacroDefinitionSettingOperation(AddMacroDefinitionSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        SESConfiguration sesConfig = this.getConfigToModify(operation);
        HashSet<ELanguage> languageCompats = new HashSet<ELanguage>(ProjectModelUtils.getLanguagesFor(operation));
        if (languageCompats.remove(ELanguage.CPP)) {
            languageCompats.add(ELanguage.C);
        }
        if (!this.configMacros.containsKey(sesConfig)) {
            this.configMacros.put(sesConfig, new HashMap());
        }
        for (ELanguage language : languageCompats) {
            if (!this.configMacros.get(sesConfig).containsKey(language)) {
                HashMap newMap = new HashMap();
                this.configMacros.get(sesConfig).put(language, newMap);
            }
            this.configMacros.get(sesConfig).get(language).put(operation.getName(), operation.getValue());
        }
    }

    @Override
    protected void registerProjectFile(IAddToProjectEngineOperation operation, IPath prjPath, File fileLoc) {
        String filePath = this.getRelativePath(fileLoc, false);
        if (operation instanceof IHandleFileProjectEngineOperation) {
            this.addedFilePaths.add((Pair<String, String>)new Pair((Object)prjPath.toString(), (Object)filePath));
        } else if (operation instanceof IHandleFolderProjectEngineOperation) {
            this.addedFolderPaths.add(prjPath.toOSString());
        }
    }

    @Override
    public void handleExcludeResourceFromConfigurationOperation(ExcludeResourceFromConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
        this.filesToExclude.put((Object)operation.getProjectPath(), (Object)operation.getBuildConfiguration());
    }

    @Override
    public void handleAddLibraryFileSettingOperation(AddLibraryFileSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        SESConfiguration sesConfig = this.getConfigToModify(operation);
        URI libUri = operation.getLibraryURI();
        if (libUri == null) {
            String libName = operation.getLibraryName();
            this.addedLibraryNames.put((Object)sesConfig, (Object)libName);
            return;
        }
        File libFile = StudioExporterUtils.resolvePath(this.standardEngine, this.projectVariables, libUri);
        String libFilePath = this.getRelativePath(libFile, false);
        this.addedLibraryFiles.put((Object)sesConfig, (Object)libFilePath);
    }

    @Override
    public void handleAddToolOptionOperation(AddToolOptionOperation operation, IProgressMonitor monitor) throws CoreException {
        IProperty prop = StudioExporterUtils.findProperty(operation);
        if (prop == null || !prop.getId().startsWith("ses")) {
            return;
        }
        boolean isListValue = CoreTypes.STRING_LIST.getType() == prop.getType();
        ArrayList<String> userValues = new ArrayList<String>();
        ArrayList<String> builtinValues = new ArrayList<String>();
        if (!TextUtils.isEmpty((String)operation.getValue())) {
            ArrayList<String> baseValues;
            ArrayList<String> arrayList = baseValues = operation.isBuiltin() ? builtinValues : userValues;
            if (isListValue) {
                baseValues.addAll((Collection)CoreTypes.STRING_LIST.convert(operation.getValue()));
            } else {
                baseValues.add(operation.getValue());
            }
        }
        operation.getListOperatons().stream().forEachOrdered(o -> {
            boolean bl = (o.isBuiltin() ? builtinValues : userValues).add(o.getValue());
        });
        String userStr = SESModelUtils.stringifySESList(userValues);
        String builtinStr = SESModelUtils.stringifySESList(builtinValues);
        SESConfiguration userConfig = this.getConfigToModify(operation.getBuildConfiguration(), operation.getProjectPath(), false);
        SESConfiguration builtinConfig = this.getConfigToModify(operation.getBuildConfiguration(), operation.getProjectPath(), true);
        EStructuralFeature optionFeature = this.sesConfigClass.getEStructuralFeature(prop.getName());
        if (optionFeature == null) {
            Activator.reporter.logError("Unknown property in EMF model. Property: " + prop.getName());
            return;
        }
        if (userConfig != null) {
            userConfig.eSet(optionFeature, userStr);
        }
        builtinConfig.eSet(optionFeature, builtinStr);
    }

    @Override
    public void handleResetModuleReferencesOperation(ResetModuleReferencesOperation operation, IProgressMonitor monitor) throws CoreException {
        this.sesMetadata.modules().resetRefs();
    }

    @Override
    public void handleAddModuleReferenceOperation(AddModuleReferenceOperation operation, IProgressMonitor monitor) throws CoreException {
        IModuleReference modRef = operation.getModuleReference();
        this.sesMetadata.modules().add(modRef);
    }

    @Override
    public void handleAddProjectDefinedModuleOperation(AddProjectDefinedModuleOperation operation, IProgressMonitor monitor) throws CoreException {
        MProject modDef = operation.getModuleDefinition();
        this.sesMetadata.modules().add(modDef);
    }

    @Override
    protected void handleAddCopiedFileReference(ICopiedFileReference reference) {
        this.sesMetadata.copiedFiles().add(reference);
    }

    @Override
    protected Collection<ICopiedFileReference> copiedFiles() {
        return this.sesMetadata.copiedFiles().copiedFileRefs();
    }

    private SESConfiguration getConfigToModify(IProjectLanguageSettingOperation operation) {
        return this.getConfigToModify(operation.getBuildConfiguration(), operation.getProjectPath(), operation.isBuiltin());
    }

    private SESConfiguration getConfigToModify(String configName, IPath path, boolean builtin) {
        SESConfigurationContainer container;
        SESConfiguration userConfig = null;
        if (TextUtils.hasContent((String)configName) && (container = SESModelUtils.findContainer(this.sesModel, (SESFolder)this.sesProject, path)) != null) {
            userConfig = SESModelUtils.findOrCreateConfiguration(configName, container);
            userConfig.setInherited_configurations(STUDIO_CONFIG_NAME);
        }
        if (builtin) {
            return this.studioProjectConfig;
        }
        return userConfig;
    }

    private void commitSpecificOptionListValues(Multimap<SESConfiguration, String> configOptionToVals, String optionName) {
        for (SESConfiguration sesConfig : configOptionToVals.keys()) {
            String newValues = SESModelUtils.stringifySESList(configOptionToVals.get((Object)sesConfig));
            EStructuralFeature optionFeature = this.sesConfigClass.getEStructuralFeature(optionName);
            sesConfig.eSet(optionFeature, newValues);
        }
    }

    private void setToolchainDirectory(SESConfiguration sesConfig) {
        IToolchainDescriptor toolchain = StudioExporterUtils.findToolchain(this.getProjectEntity());
        if (StudioExporterUtils.isEmptyToolchain(toolchain)) {
            return;
        }
        try {
            sesConfig.setBuild_toolchain_directory(toolchain.getInstallationPath().toString() + "bin");
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
        }
    }

    private void setArmCoreSettings(SESConfiguration sesConfig) {
        sesConfig.setArm_target_interface_type(DEFAULT_ARM_CORE_SETTINGS.get(SESArmExternalOptions.ARM_TARGET_INTERFACE_TYPE));
        sesConfig.setDebug_start_from_entry_point_symbol(DEFAULT_ARM_CORE_SETTINGS.get(SESArmExternalOptions.DEBUG_START_FROM_ENTRY_POINT_SYMBOL));
        sesConfig.setDebug_target_connection(DEFAULT_ARM_CORE_SETTINGS.get(SESArmExternalOptions.DEBUG_TARGET_CONNECTION));
        sesConfig.setBUILD_OPTIONS(DEFAULT_ARM_CORE_SETTINGS.get(SESArmExternalOptions.BUILD_OPTIONS));
        sesConfig.setUse_compiler_driver(DEFAULT_ARM_CORE_SETTINGS.get(SESArmExternalOptions.USE_COMPILER_DRIVER));
        sesConfig.setBuild_generic_options_file_name(DEFAULT_ARM_CORE_SETTINGS.get(SESArmExternalOptions.BUILD_GENERIC_OPTIONS_FILE_NAME));
    }

    private Map<String, String> setPartSelectionOptionValues(SESConfiguration sesConfig) {
        String partId = (String)this.getProjectEntity().getProperty(ProjectProperties.PART_ID);
        IPart part = (IPart)Part.manager().find(partId);
        String armCoreType = this.getCoreOptionValueForSES(part);
        String armFpuType = this.getFpuOptionValueForSES(part);
        String armArch = "ARM";
        String armEndian = "Little";
        String armTargetDeviceName = part == null ? "EFR32MG22C224F512IM32" : ((IPartDescriptor)part.getDescriptor()).getName();
        sesConfig.setArm_core_type(armCoreType);
        sesConfig.setArm_fpu_type(armFpuType);
        sesConfig.setArm_architecture(armArch);
        sesConfig.setArm_endian(armEndian);
        sesConfig.setArm_target_device_name(armTargetDeviceName);
        return null;
    }

    private String getFpuOptionValueForSES(IPart part) {
        if (part == null) {
            return "";
        }
        EFPUIdentifier fpu_type = null;
        try {
            fpu_type = Si32PartUtils.getFPU((IPart)part);
        }
        catch (CoreException e) {
            Activator.reporter.logException((Throwable)e);
        }
        if (fpu_type == null) {
            return "";
        }
        switch (fpu_type) {
            case VFP_V4: {
                return "VFPv4-D32";
            }
            case VFP_V5_SP: {
                return "VFP";
            }
        }
        throw new IllegalStateException("Unknown fpu type for " + String.valueOf(fpu_type));
    }

    private String getCoreOptionValueForSES(IPart part) {
        if (part == null) {
            return DEFAULT_CORE;
        }
        EARMCore arm_core_type = null;
        try {
            arm_core_type = Si32PartUtils.getARMCore((IPart)part);
        }
        catch (CoreException e) {
            Activator.reporter.logException((Throwable)e);
        }
        if (arm_core_type == null) {
            return DEFAULT_CORE;
        }
        switch (arm_core_type) {
            case CORTEX_M0: {
                return "Cortex-M0";
            }
            case CORTEX_M0_PLUS: {
                return "Cortex-M0+";
            }
            case CORTEX_M1: {
                return "Cortex-M1";
            }
            case CORTEX_M3: {
                return "Cortex-M3";
            }
            case CORTEX_M4: {
                return "Cortex-M4";
            }
            case CORTEX_M4F: {
                return "Cortex-M4";
            }
            case CORTEX_M33: {
                return DEFAULT_CORE;
            }
            case CORTEX_M55: {
                return "Cortex-M55";
            }
        }
        throw new IllegalStateException("Unknown core type for " + String.valueOf(arm_core_type));
    }

    @Override
    public void handleAddProjectResourceFilterOperation(AddProjectResourceFilterOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleAddSourceFolderToConfigurationOperation(AddSourceFolderToConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleSetConfigurationOutputBaseNameOperation(SetConfigurationOutputBaseNameOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleAddLibraryPathSettingOperation(AddLibraryPathSettingOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleIncludeResourceIntoConfigurationOperation(IncludeResourceIntoConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
    }
}

