/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.assertj.DoubleGaugeAssert;
import io.opentelemetry.sdk.testing.assertj.DoubleSumAssert;
import io.opentelemetry.sdk.testing.assertj.HistogramAssert;
import io.opentelemetry.sdk.testing.assertj.LongGaugeAssert;
import io.opentelemetry.sdk.testing.assertj.LongSumAssert;
import io.opentelemetry.sdk.testing.assertj.SummaryAssert;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;

public final class MetricAssert
extends AbstractAssert<MetricAssert, MetricData> {
    MetricAssert(@Nullable MetricData actual) {
        super((Object)actual, MetricAssert.class);
    }

    public MetricAssert hasResource(Resource resource) {
        this.isNotNull();
        if (!((MetricData)this.actual).getResource().equals(resource)) {
            this.failWithActualExpectedAndMessage(this.actual, "resource: " + resource, "Expected MetricData to have resource <%s> but found <%s>", new Object[]{resource, ((MetricData)this.actual).getResource()});
        }
        return this;
    }

    public MetricAssert hasInstrumentationScope(InstrumentationScopeInfo instrumentationScopeInfo) {
        this.isNotNull();
        if (!((MetricData)this.actual).getInstrumentationScopeInfo().equals(instrumentationScopeInfo)) {
            this.failWithActualExpectedAndMessage(this.actual, "instrumentation scope: " + instrumentationScopeInfo, "Expected MetricData to have resource <%s> but found <%s>", new Object[]{instrumentationScopeInfo, ((MetricData)this.actual).getInstrumentationScopeInfo()});
        }
        return this;
    }

    public MetricAssert hasName(String name) {
        this.isNotNull();
        if (!((MetricData)this.actual).getName().equals(name)) {
            this.failWithActualExpectedAndMessage(this.actual, "name: " + name, "Expected MetricData to have name <%s> but found <%s>", new Object[]{name, ((MetricData)this.actual).getName()});
        }
        return this;
    }

    public MetricAssert hasDescription(String description) {
        this.isNotNull();
        if (!((MetricData)this.actual).getDescription().equals(description)) {
            this.failWithActualExpectedAndMessage(this.actual, "description: " + description, "Expected MetricData to have description <%s> but found <%s>", new Object[]{description, ((MetricData)this.actual).getDescription()});
        }
        return this;
    }

    public MetricAssert hasUnit(String unit) {
        this.isNotNull();
        if (!((MetricData)this.actual).getUnit().equals(unit)) {
            this.failWithActualExpectedAndMessage(this.actual, "unit: " + unit, "Expected MetricData to have unit <%s> but found <%s>", new Object[]{unit, ((MetricData)this.actual).getUnit()});
        }
        return this;
    }

    public MetricAssert hasDoubleGaugeSatisfying(Consumer<DoubleGaugeAssert> assertion) {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.DOUBLE_GAUGE) {
            this.failWithActualExpectedAndMessage(this.actual, "type: DOUBLE_GAUGE", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.DOUBLE_GAUGE, ((MetricData)this.actual).getType()});
        }
        assertion.accept(new DoubleGaugeAssert(((MetricData)this.actual).getDoubleGaugeData()));
        return this;
    }

    public MetricAssert hasLongGaugeSatisfying(Consumer<LongGaugeAssert> assertion) {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.LONG_GAUGE) {
            this.failWithActualExpectedAndMessage(this.actual, "type: LONG_GAUGE", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.LONG_GAUGE, ((MetricData)this.actual).getType()});
        }
        assertion.accept(new LongGaugeAssert(((MetricData)this.actual).getLongGaugeData()));
        return this;
    }

    public MetricAssert hasDoubleSumSatisfying(Consumer<DoubleSumAssert> assertion) {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.DOUBLE_SUM) {
            this.failWithActualExpectedAndMessage(this.actual, "type: DOULE_SUM", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.DOUBLE_SUM, ((MetricData)this.actual).getType()});
        }
        assertion.accept(new DoubleSumAssert(((MetricData)this.actual).getDoubleSumData()));
        return this;
    }

    public MetricAssert hasLongSumSatisfying(Consumer<LongSumAssert> assertion) {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.LONG_SUM) {
            this.failWithActualExpectedAndMessage(this.actual, "type: LONG_SUM", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.LONG_SUM, ((MetricData)this.actual).getType()});
        }
        assertion.accept(new LongSumAssert(((MetricData)this.actual).getLongSumData()));
        return this;
    }

    public MetricAssert hasHistogramSatisfying(Consumer<HistogramAssert> assertion) {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.HISTOGRAM) {
            this.failWithActualExpectedAndMessage(this.actual, "type: HISTOGRAM", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.HISTOGRAM, ((MetricData)this.actual).getType()});
        }
        assertion.accept(new HistogramAssert(((MetricData)this.actual).getHistogramData()));
        return this;
    }

    public MetricAssert hasSummarySatisfying(Consumer<SummaryAssert> assertion) {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.SUMMARY) {
            this.failWithActualExpectedAndMessage(this.actual, "type: SUMMARY", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.SUMMARY, ((MetricData)this.actual).getType()});
        }
        assertion.accept(new SummaryAssert(((MetricData)this.actual).getSummaryData()));
        return this;
    }
}

