/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.meta.IMetaSource;
import com.silabs.ss.framework.uc.core.internal.cache.ComponentProtoUtilities;
import com.silabs.ss.framework.uc.core.internal.cache.RawComponentCache;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.ComponentRender;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="cache-test", description={"Test cache loading integrity. Will load every component in an sdk ensure they all come out of the cache the same way they entered. This should be run automatically on every new build."})
public final class UcCliCacheTest
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.ParentCommand
    private CliRoot root;
    private static final Function<IUcComponent, IUcComponent> PRIMARY_CACHE_CONVERT = comp -> {
        try {
            return ComponentProtoUtilities.toComponent((RawComponentCache.Component)ComponentProtoUtilities.toCacheComponent((IUcComponent)comp), (IMetaSource)comp.metaSource());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    };
    private Function<IUcComponent, IUcComponent> instanceCacheConvert = PRIMARY_CACHE_CONVERT;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(sdk -> this.runCacheTest((IUcSdkContent)sdk, feedback)).orElseThrow(SdkRequiredException::new);
    }

    public void setCacheFunction(Function<IUcComponent, IUcComponent> cacheFunction) {
        this.instanceCacheConvert = cacheFunction;
    }

    public int runCacheTest(IUcSdkContent sdk, ICliOutput feedback) {
        int status = IApplication.EXIT_OK;
        ComponentRender.PrintOptions options = new ComponentRender.PrintOptions();
        options.useColour(true);
        IUcFramework framework = sdk.framework();
        Iterator compIter = framework.allComponents().iterator();
        while (compIter.hasNext()) {
            IUcComponent compFromCache;
            IUcComponent comp = (IUcComponent)compIter.next();
            if (comp.equals(compFromCache = this.instanceCacheConvert.apply(comp))) continue;
            status = -1;
            feedback.out().println("Integrity issue! Two unequal components: ");
            feedback.out().println("-- Component from disk:");
            ComponentRender.renderComponent(comp, framework, options, feedback.out());
            feedback.out().println("-- Component from cache:");
            ComponentRender.renderComponent(compFromCache, framework, options, feedback.out());
            break;
        }
        if (status == IApplication.EXIT_OK) {
            feedback.out().println("No cache integrity issues detected.");
        }
        return status;
    }
}

