/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.SdkSemanticVersion;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.ILibrary;
import com.silabs.ss.framework.uc.core.api.IUcBackingStore;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.LibrarySdk;
import com.silabs.ss.framework.uc.core.api.ResolvedInclude;
import com.silabs.ss.framework.uc.core.api.comp.ConfigFile;
import com.silabs.ss.framework.uc.core.api.comp.Customisation;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcTemplateFile;
import com.silabs.ss.framework.uc.core.api.comp.Overrider;
import com.silabs.ss.framework.uc.core.api.comp.UcComponent;
import com.silabs.ss.framework.uc.core.api.comp.UcSdkReference;
import com.silabs.ss.framework.uc.core.api.comp.ValidationScript;
import com.silabs.ss.framework.uc.core.api.meta.SlccWriter;
import com.silabs.ss.framework.uc.core.api.meta.SourceFile;
import com.silabs.ss.framework.uc.core.api.meta.UcFactory;
import com.silabs.ss.framework.uc.core.api.sdkextension.IUcSdkExtensionId;
import com.silabs.ss.framework.uc.core.internal.api.comp.UcTemplateFile;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExtensionMixin;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.util.UcCliUtils;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.util.Map;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="clone", description={"Clones sdk components for developers who wish to use a component in a slightly modified form. Takes care of ensuring all referenced files and other data is copied so that the cloned components are truly self-contained. To use the resulting clone, place it in a new sdk extension."})
public class UcCliClone
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliExtensionMixin ifExt;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-t", "--target"}, description={"The component to be cloned. Referenced files will be copied along with the .slcc, and the project search paths will be updated and saved. Clone data is automatically added based on the current system's date."}, required=true, paramLabel="TARGET_COMPONENT_ID")
    private String target;
    @CommandLine.Option(names={"-d", "--destination"}, description={"The location that the component will be cloned into. The component's slcc and directly required files will be cloned to this location."})
    private String destination;
    @CommandLine.Option(names={"-a", "--author"}, description={"The author of this cloned component. A simple string naming the author(s)."}, paramLabel="AUTHOR_NAME")
    private String author;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk sdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
        boolean forceOperations = this.force.forceOperations();
        return this.runClone(sdk, feedback.resolve(this.destination), feedback, forceOperations);
    }

    public int runClone(IUcSdk sdk, Path finalCloneFolder, ICliOutput feedback, boolean force) {
        return UcCliUtils.findComponent(this.target, this.ifExt, sdk, null, feedback).map(found -> UcCliClone.cloneComponent(found.component(), sdk.framework(), found.extId(), this.author, finalCloneFolder, feedback)).orElseGet(() -> {
            feedback.out().println("Could not clone: component " + this.target + " does not exist.");
            return -1;
        });
    }

    public static int cloneComponent(IUcComponent component, IUcFramework framework, IUcSdkExtensionId extId, String author, Path finalCloneFolder, ICliOutput feedback) {
        if (component.customisation().map(custom -> custom.cloneInfo().isPresent()).orElse(false).booleanValue()) {
            feedback.out().println("Requested component " + component.id() + " already is a clone. Aborting.");
            return -1;
        }
        try {
            if (!Files.exists(finalCloneFolder, new LinkOption[0])) {
                Files.createDirectories(finalCloneFolder, new FileAttribute[0]);
            }
            UcComponent.Builder clonedComponent = UcComponent.builder((IUcComponent)component);
            SdkSemanticVersion frameworkVersion = framework.semVersion();
            UcSdkReference sdkRef = UcSdkReference.createWithSemver((String)framework.name(), (SdkSemanticVersion)frameworkVersion);
            Customisation.CloneInfo cloneInfo = Customisation.CloneInfo.cloneNow((UcSdkReference)sdkRef, (String)component.id(), (IUcSdkExtensionId)extId, (Clock)Clock.systemDefaultZone());
            clonedComponent.setCloneData(cloneInfo);
            if (author != null) {
                clonedComponent.setAuthor(author);
            }
            clonedComponent.setId(cloneInfo.sourceComponentId());
            Path commonRoot = framework.directory().toPath();
            clonedComponent.clearSourcePaths();
            component.sourceFiles().stream().map(cond -> cond.map(file -> UcCliClone.transferSourceFile(file, commonRoot, finalCloneFolder, feedback))).forEach(arg_0 -> ((UcComponent.Builder)clonedComponent).addSourcePaths(arg_0));
            clonedComponent.clearConfigFiles();
            component.configFiles().stream().map(cond -> cond.map(over -> over.map(file -> UcCliClone.transferConfigFile(file, commonRoot, finalCloneFolder, feedback)))).forEach(arg_0 -> ((UcComponent.Builder)clonedComponent).addOverrideableConfigFile(arg_0));
            clonedComponent.clearOverriderConfigFiles();
            component.overriderConfigFiles().stream().map(cond -> cond.map(file -> UcCliClone.transferOverrider((Overrider<ConfigFile>)file, commonRoot, finalCloneFolder, feedback))).forEach(arg_0 -> ((UcComponent.Builder)clonedComponent).addOverriderConfigFile(arg_0));
            clonedComponent.clearIncludePaths();
            component.includePaths().stream().map(cond -> cond.map(include -> UcCliClone.transferInclude(include, commonRoot, finalCloneFolder, feedback))).forEach(arg_0 -> ((UcComponent.Builder)clonedComponent).addIncludePath(arg_0));
            clonedComponent.clearValidationScripts();
            component.validationScripts().stream().map(cond -> cond.map(script -> UcCliClone.transferScript(script, commonRoot, finalCloneFolder, feedback))).forEach(arg_0 -> ((UcComponent.Builder)clonedComponent).addValidationScript(arg_0));
            clonedComponent.clearValidationLibraries();
            component.validationLibraries().stream().map(cond -> cond.map(library -> UcCliClone.transferScript(library, commonRoot, finalCloneFolder, feedback))).forEach(arg_0 -> ((UcComponent.Builder)clonedComponent).addValidationLibrary(arg_0));
            clonedComponent.clearTemplateFiles();
            component.templates().stream().map(cond -> cond.map(template -> UcCliClone.transferTemplate(UcCliClone.transferFile(template.templateFile(), commonRoot, finalCloneFolder, feedback), template))).forEach(arg_0 -> ((UcComponent.Builder)clonedComponent).addTemplateFile(arg_0));
            clonedComponent.clearLibraries();
            component.libraries().stream().map(cond -> cond.map(library -> UcCliClone.transferLibrary(library, commonRoot, finalCloneFolder, feedback))).forEach(arg_0 -> ((UcComponent.Builder)clonedComponent).addLibrary(arg_0));
            String filename = cloneInfo.sourceComponentId() + cloneInfo.sourceExtension().map(ref -> "_from_" + ref.name()).orElse("");
            Path slccWriteout = finalCloneFolder.resolve(filename + ".slcc");
            UcComponent theFinalClone = clonedComponent.build();
            Map cloneYaml = SlccWriter.convertToYamlModel((IUcComponent)theFinalClone, (Path)finalCloneFolder);
            StringWriter sw = new StringWriter();
            UcFactory.yamlWriter().writeMap(cloneYaml, new PrintWriter(sw), IUcBackingStore.SLCC);
            Files.createFile(slccWriteout, new FileAttribute[0]);
            Files.writeString(slccWriteout, (CharSequence)sw.toString(), new OpenOption[0]);
            feedback.out().println("Cloning Successful: cloned as " + theFinalClone.id() + " into " + finalCloneFolder.toAbsolutePath().toString());
            return 0;
        }
        catch (IOException e) {
            feedback.unifiedLogger().userError("Failed to clone component " + e.getMessage() + ": see log for details", (Throwable)e);
            return -1;
        }
    }

    private static IUcTemplateFile transferTemplate(Path newPath, IUcTemplateFile oldTemplate) {
        return new UcTemplateFile(newPath, oldTemplate.isExported());
    }

    private static Path transferFile(Path original, Path commonRoot, Path customsHome, ICliOutput feedback) {
        Path sdkFolderTree = commonRoot.relativize(original.getParent());
        Path newHome = customsHome.resolve(sdkFolderTree);
        Path newFile = newHome.resolve(original.getFileName());
        try {
            Files.createDirectories(newHome, new FileAttribute[0]);
            Files.copy(original, newFile, new CopyOption[0]);
        }
        catch (IOException e) {
            feedback.unifiedLogger().userError("Could not create directories for cloning file " + String.valueOf(original) + " to " + String.valueOf(newHome) + " because " + e.getMessage(), (Throwable)e);
        }
        return newFile;
    }

    private static ILibrary transferLibrary(ILibrary library, Path commonRoot, Path customsHome, ICliOutput feedback) {
        if (library.isSystem()) {
            return library;
        }
        if (library instanceof LibrarySdk) {
            LibrarySdk sdkLib = (LibrarySdk)library;
            return new LibrarySdk(UcCliClone.transferSourceFile(sdkLib.resolvedLibrary(), commonRoot, customsHome, feedback));
        }
        throw new RuntimeException("Clone failure due to missing instanceof check for new library type " + library.getClass().getCanonicalName());
    }

    private static ValidationScript transferScript(ValidationScript script, Path commonRoot, Path customsHome, ICliOutput feedback) {
        Path newScript = UcCliClone.transferFile(script.script(), commonRoot, customsHome, feedback);
        return ValidationScript.fromNamedFile((Path)newScript, (String)script.name());
    }

    private static ResolvedInclude transferInclude(ResolvedInclude include, Path commonRoot, Path customsHome, ICliOutput feedback) {
        ImmutableList.Builder headerFiles = new ImmutableList.Builder();
        include.headerFiles().filter(cond -> ((SourceFile)cond.data()).physicalFile().isPresent()).map(cond -> cond.map(file -> UcCliClone.transferSourceFile(file, commonRoot, customsHome, feedback))).forEach(arg_0 -> ((ImmutableList.Builder)headerFiles).add(arg_0));
        Path newIncludeDirectory = customsHome.resolve(commonRoot.relativize(include.includeDirectory()));
        return new ResolvedInclude(headerFiles.build(), newIncludeDirectory);
    }

    private static SourceFile transferSourceFile(SourceFile source, Path commonRoot, Path customsHome, ICliOutput feedback) {
        assert (source.physicalFile().isPresent()) : "Component sources should have physical locations resolved";
        Path original = (Path)source.physicalFile().get();
        Path newFile = UcCliClone.transferFile(original, commonRoot, customsHome, feedback);
        return SourceFile.from((String)newFile.getFileName().toString(), (ImmutableList)source.category(), (Path)newFile);
    }

    private static ConfigFile.Builder transferConfigFile(ConfigFile config, Path commonRoot, Path customsHome, ICliOutput feedback) {
        Path original = config.sourceFile();
        Path newFile = UcCliClone.transferFile(original, commonRoot, customsHome, feedback);
        return ConfigFile.builder((ConfigFile)config).setParent(newFile.getParent()).setFileName(config.configFileName());
    }

    private static Overrider<ConfigFile> transferOverrider(Overrider<ConfigFile> over, Path commonRoot, Path customsHome, ICliOutput feedback) {
        return over.map(file -> UcCliClone.transferConfigFile(file, commonRoot, customsHome, feedback).build());
    }
}

