/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.silabs.java.utils.StreamUtils;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentConfiguration;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentContainer;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.rule.ApiId;
import com.silabs.ss.framework.uc.core.api.validate.ApiChoice;
import com.silabs.ss.framework.uc.core.api.validate.ApiChoiceResult;
import com.silabs.ss.framework.uc.core.api.validate.ApiValidationIssue;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import com.silabs.ss.framework.uc.core.api.validate.UcApiValidator;
import com.silabs.ss.framework.uc.core.api.validate.UnfulfilledIssue;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.ProjectRequiredException;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProjectImplicit;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.CliUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="choices", description={"Shows what components could be added to the project to satisfy outstanding dependencies. Marks which choices, if any, are considered recommended."})
public class UcCliPossibilities
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliProjectImplicit projectBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-max", "--max"}, description={"Maximum number of choices to show. By default this is ${DEFAULT-VALUE}. Set to 0 or negative values to impose no limit."}, defaultValue="20", paramLabel="NUMBER_OF_CHOICES")
    private int max;
    private static final CliColour recommendsColour = CliColour.GREEN;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk sdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
        return this.projectBase.loadProject((IUcSdkContent)sdk, feedback, SltSdkFeatures.fromMixin(this.sdkBase, feedback), true, true, this.force.forceOperations()).map(p -> UcCliPossibilities.checkPossibilities((IUcProject)p, feedback, this.max)).orElseThrow(ProjectRequiredException::new);
    }

    public static int checkPossibilities(IUcProject project, ICliOutput feedback, int max) {
        boolean atLeastSomething;
        ArrayList<UnfulfilledIssue> needsHelp = new ArrayList<UnfulfilledIssue>();
        HashSet<String> missingApis = new HashSet<String>();
        ArrayList<ApiValidationIssue> nonChoiceIssues = new ArrayList<ApiValidationIssue>();
        for (ApiValidationIssue issue2 : StreamUtils.iterableOf((Stream)UcApiValidator.validate((IUcComponentContainer)project.ucFramework(), (IUcComponentConfiguration)project))) {
            missingApis.add(issue2.failedId().id());
            if (issue2 instanceof UnfulfilledIssue) {
                UnfulfilledIssue unfulfilledIssue = (UnfulfilledIssue)issue2;
                needsHelp.add(unfulfilledIssue);
                continue;
            }
            nonChoiceIssues.add(issue2);
        }
        if (needsHelp.isEmpty() && nonChoiceIssues.isEmpty()) {
            feedback.out().println("Project is already viable -- no choices need be made.");
            return IApplication.EXIT_OK;
        }
        if (needsHelp.isEmpty()) {
            feedback.out().println("The only issues are exclusivity ones. Use 'validate_project' and deselect competing components.");
            return IApplication.EXIT_OK;
        }
        ApiChoiceResult choiceResult = UcApiUtils.findChoices(needsHelp.stream().filter(UnfulfilledIssue.class::isInstance).map(issue -> issue).toList(), (IUcProject)project);
        CliSessionData session = feedback.session();
        feedback.out().println("All Required Apis (Missing Apis " + session.colourBasedFeedback("are red", "have '*'") + "): ");
        CliUtility.printStringsNicely(choiceResult.requiredApis().keySet().stream().map(ApiId::id).sorted().toList(), feedback.out(), s -> missingApis.contains(s) ? session.colourBasedFeedback(session.colourIfNeeded((String)s, CliColour.RED), s + "*") : session.colourIfNeeded((String)s, CliColour.MAGENTA), session.consoleWidth(), "");
        boolean bl = atLeastSomething = !choiceResult.choices().isEmpty();
        if (atLeastSomething) {
            feedback.out().println("Components acceptable to add to this project to solve validation issues are listed below. Recommended choices (choices with at least)  one recommended component) are " + (session.isColour() ? "shown in green." : "marked with '*'Each '-' represents one group of components that must be selected together."));
            ImmutableMultimap choices = choiceResult.choices();
            Stream<UnfulfilledIssue> sortedIssues = choices.keySet().stream().sorted((left, right) -> left.message().compareTo(right.message()));
            sortedIssues.forEach(issue -> {
                feedback.out().println(session.colourIfNeeded(issue.message(), CliColour.RED));
                ImmutableCollection issueFixes = choices.get(issue);
                if (!issueFixes.isEmpty()) {
                    if (max > 0 && issueFixes.size() > max) {
                        feedback.out().println("There are " + issueFixes.size() + " potential choices. Only showing first " + max + ".");
                    }
                    Stream<ApiChoice> issueStream = issueFixes.stream().sorted();
                    issueStream = max > 0 ? issueStream.limit(max) : issueStream;
                    issueStream.forEach(issueFix -> feedback.out().println(" - " + issueFix.selections().stream().map(comp -> issueFix.recommended() ? UcCliPossibilities.formatRecommended(comp.displayableId(), session.isColour()) : comp.displayableId()).collect(Collectors.joining(" & "))));
                } else {
                    feedback.out().println("No acceptable choices found that fix this issue for this project.");
                }
            });
            feedback.out().println("Choose which ones to add to the .slcp file, and re-run this/run validate_project again. For deep dependency hierarchies with multiple conditionals, this may take a few iterations.");
        }
        return IApplication.EXIT_OK;
    }

    private static String formatRecommended(String s, boolean useColour) {
        if (useColour) {
            return recommendsColour.applyColourANSI(s);
        }
        return "*" + s;
    }
}

