/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.comp.ComponentQuality;
import com.silabs.ss.framework.uc.core.api.comp.ComponentQualityUtils;
import com.silabs.ss.framework.uc.core.api.comp.UcComponent;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.meta.DefaultMetaPathResolver;
import com.silabs.ss.framework.uc.core.api.meta.IMetaParseEngine;
import com.silabs.ss.framework.uc.core.api.meta.IMetaPathResolver;
import com.silabs.ss.framework.uc.core.api.meta.UcFactory;
import com.silabs.ss.framework.uc.core.api.meta.exception.UcParsingException;
import com.silabs.ss.framework.uc.core.internal.api.parse.SlccParser;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.UcCliValidateProject;
import com.silabs.uc.cli.internal.command.UcCliValidateSdk;
import com.silabs.uc.cli.internal.command.UcCliValidateUpgrade;
import com.silabs.uc.cli.internal.command.UcCliWorkspaceVerify;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExtensionMixin;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.mixin.CliWithinWithout;
import com.silabs.uc.cli.internal.command.model.ICliValidateLogic;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="validate", description={"Validates an SLC metadata file of any type. Not all options are relevant to all metadata types, but cause no issues if specified anyway."})
public class UcCliValidate
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliExternalTools extTools;
    @CommandLine.Mixin
    private CliExtensionMixin cliExtensionMixin;
    @CommandLine.Mixin
    private CliWithinWithout withinWithout;
    @CommandLine.Option(names={"--report-junit"}, description={"Define where an XML file should be output with the errors listed in JUnit XML format. This can be archived by the Jenkins Junit plugin. When specified, SLC will return a passing exit code unless there are fatal errors. Not every validation type supports generating reports. As of this version of SLC, only sdk validation will generate reports."})
    private String xmlReportDestination;
    @CommandLine.Option(names={"-d", "--export-destination"}, paramLabel="DESTINATION", description={"Destination of an expected project export. For project validation, this allows generated or user modified configuration specific to the project to also have their CMSIS configuration run against applicable validation scripts defined by the SLC metadata. This should point to the base folder, not to the 'config' folder directly."})
    private String destination;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Parameters(index="0", description={"Path to metadata to validate. May be any valid metadata file as part of the SLC specification."}, paramLabel="SLCC_PATH")
    private String metadataPath;

    @Override
    public Integer call() throws Exception {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        String metaExtension = FileUtils.getExtension((String)this.metadataPath);
        if (metaExtension == null) {
            feedback.err().println("Cannot validate " + this.metadataPath + " as it has no extension.");
            return -8;
        }
        String extLowercase = metaExtension.toLowerCase();
        ShowSdkWarnings showSdkLoadWarnings = ShowSdkWarnings.DO_NOT_SHOW_WARNINGS;
        switch (extLowercase) {
            case "slcs": {
                showSdkLoadWarnings = ShowSdkWarnings.SHOW_ALL_WARNINGS_AND_VERIFY_RELEASE;
                this.sdkBase.overrideLoadedSdk(this.metadataPath, "When using 'slc validate' with an .slcs file, the --sdk is ignored, as only one sdk can be loaded at a time and we are assuming you want to load the .slcs directly referred to.", feedback);
                break;
            }
            case "slce": {
                showSdkLoadWarnings = ShowSdkWarnings.SHOW_ALL_WARNINGS_AND_VERIFY_RELEASE;
                this.sdkBase.addExtensionIf(this.metadataPath, "Adding extension to validate implicitly to list of extensions to load for this command.", feedback);
                this.cliExtensionMixin.overrideExtensionPath(this.metadataPath, "When using 'slc validate' with an .slce file, any arguments that refer to pinpointing a single, specific extension are ignored.", feedback);
                break;
            }
        }
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, showSdkLoadWarnings).map(sdk -> this.switchboard((IUcSdk)sdk, this.metadataPath, extLowercase, feedback)).orElseThrow(SdkRequiredException::new);
    }

    private Integer switchboard(IUcSdk sdk, String metadataRawPath, String extLower, ICliOutput feedback) {
        SltSdkFeatures sltFeatures = SltSdkFeatures.fromMixin(this.sdkBase, feedback);
        return switch (extLower) {
            case "slcc" -> this.runSlccValidate(sdk, feedback);
            case "slcs" -> this.runSdkValidate(sdk, feedback);
            case "slce" -> this.runExtensionValidate(sdk, feedback);
            case "slcw" -> this.runWorkspaceValidate(sdk, sltFeatures, metadataRawPath, feedback);
            case "slcp" -> this.runProjectValidate(sdk, sltFeatures, metadataRawPath, feedback);
            case "slcu" -> this.runUpgradeValidate(sdk, metadataRawPath, feedback);
            default -> {
                Path metadataUnderValidation = feedback.resolve(metadataRawPath);
                feedback.err().println("Cannot validate " + String.valueOf(metadataUnderValidation) + " as the extension " + extLower + " is not a known SLC metadata type.");
                yield -8;
            }
        };
    }

    private Integer runSdkValidate(IUcSdk sdk, ICliOutput feedback) {
        return UcCliValidateSdk.runValidateSdkExternal((IUcSdkContent)sdk, ShowSdkWarnings.SHOW_ALL_WARNINGS_AND_VERIFY_RELEASE, this.cliExtensionMixin, this.xmlReportDestination, feedback);
    }

    private Integer runExtensionValidate(IUcSdk sdk, ICliOutput feedback) {
        return UcCliValidateSdk.runValidateSdkExternal((IUcSdkContent)sdk, ShowSdkWarnings.SHOW_ALL_WARNINGS_AND_VERIFY_RELEASE, this.cliExtensionMixin, this.xmlReportDestination, feedback);
    }

    private Integer runWorkspaceValidate(IUcSdk sdk, SltSdkFeatures sltFeatures, String workspace, ICliOutput feedback) {
        return UcCliWorkspaceVerify.runWorkspaceVerificationExternal(sdk, workspace, this.withinWithout, this.extTools, sltFeatures, feedback);
    }

    private Integer runProjectValidate(IUcSdk sdk, SltSdkFeatures sltFeatures, String project, ICliOutput feedback) {
        return UcCliValidateProject.runValidateProjectExternal(sdk, project, this.withinWithout, this.extTools, sltFeatures, this.destination, feedback);
    }

    private Integer runUpgradeValidate(IUcSdk sdk, String upgrade, ICliOutput feedback) {
        return UcCliValidateUpgrade.runValidateExternal(sdk, upgrade, this.cliExtensionMixin, feedback);
    }

    private int runSlccValidate(IUcSdk sdk, ICliOutput feedback) {
        Path resolverPath = this.cliExtensionMixin.resolverPath(sdk, feedback);
        Set validQualities = ComponentQualityUtils.getAllQualitiesFor((long)sdk.framework().specVersion());
        return ICliValidateLogic.subRunValidate(resolverPath, this.metadataPath, validQualities, this::slccValidate, feedback);
    }

    private final int slccValidate(Path resolverLocation, Path slccFile, Set<ComponentQuality> validQualities, ICliOutput feedback) {
        block5: {
            SlccParser parser = new SlccParser((IMetaPathResolver)DefaultMetaPathResolver.fromFile((Path)resolverLocation), validQualities, null);
            IMetaParseEngine slccOnlyEngine = UcFactory.parseEngine();
            slccOnlyEngine.setReportingLevel(IMetaParseEngine.ParseReportingLevel.RELEASE);
            try {
                UcComponent comp = parser.parse(slccOnlyEngine, UcFactory.source((Path)slccFile));
                feedback.out().println("--- Results for " + comp.displayableId() + " --- ");
                if (!slccOnlyEngine.hasError() && !slccOnlyEngine.hasWarnings()) break block5;
                if (slccOnlyEngine.hasError()) {
                    feedback.out().println(" - Errors");
                    slccOnlyEngine.errors().forEach(feedback.outPrintln());
                }
                if (slccOnlyEngine.hasWarnings()) {
                    feedback.out().println("- Warnings");
                    slccOnlyEngine.warnings().forEach(feedback.outPrintln());
                }
                return 1;
            }
            catch (UcParsingException e) {
                feedback.unifiedLogger().userError("Deeper issue with component file: " + e.getMessage(), (Throwable)e);
                return 2;
            }
        }
        feedback.out().println(" No issues detected");
        return IApplication.EXIT_OK;
    }
}

