/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.google.common.collect.ImmutableList;
import com.silabs.ss.framework.uc.core.internal.api.project.state.SessionApackManager;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.nio.file.Path;
import java.util.List;
import picocli.CommandLine;

public class CliExternalTools {
    @CommandLine.Option(names={"--tool-path", "--adapter-packs"}, paramLabel="ADAPTER_PACK_FOLDER_PATHS", split=",", description={"List of paths to folders containing valid packs (see documentation regarding adapter pack specifications for details). If this is provided in any fashion, even an empty list, then no adapter packs that are normally installed in the sdk, nor in any known installation paths (such as STUDIO_ADAPTER_PACK_PATH environment variable) are considered. This is intended to support SLT Configuration File based usage of SLC, which encourages slt configuration files to represent the full reproducibility of tasks such as this generation. Because this can be supplied by a shared variable --tool-path and that is the most likely usage of this for SLT, this will ignore adapter packs that it cannot load. Use the adapter-packs command to confirm what SLC actually sees."})
    private List<String> customAdapterPacks;

    public boolean customsDefined() {
        return this.customAdapterPacks != null;
    }

    public SessionApackManager apackManager() {
        return SessionApackManager.instance();
    }

    public ImmutableList<Path> customAdapterPacks(ICliOutput feedback) {
        if (this.customAdapterPacks == null) {
            return ImmutableList.of();
        }
        return (ImmutableList)this.customAdapterPacks.stream().map(feedback::resolve).collect(ImmutableList.toImmutableList());
    }
}

