/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.model.IUcProjectMutable;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliProject;
import com.silabs.uc.cli.internal.command.mixin.CliWithinWithout;
import com.silabs.uc.cli.internal.command.model.ProjectContainer;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import picocli.CommandLine;

public class CliProjectImplicit {
    @CommandLine.Mixin
    CliProject projectExplicit;
    @CommandLine.Parameters
    List<String> optionalParams = new ArrayList<String>();
    private String finalProjectLocation;

    public static CliProjectImplicit createDirectly(String projectLocation, CliWithinWithout withinWithout, CliExternalTools extTools) {
        CliProjectImplicit projectCli = new CliProjectImplicit();
        projectCli.projectExplicit = CliProject.createDirectly(projectLocation, withinWithout, extTools);
        return projectCli;
    }

    public String destination() {
        return this.projectExplicit.destination();
    }

    public String projectLocation() {
        return this.finalProjectLocation;
    }

    public List<String> withinComponents() {
        return this.projectExplicit.withinComponents();
    }

    public Optional<IUcProjectMutable> loadProject(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDirectory, boolean required, boolean force) {
        return this.loadProjectContainer(sdk, feedback, sltFeatures, forceReasonableGenDirectory, required, force).map(ProjectContainer::project);
    }

    public Optional<IUcProjectMutable> loadProject(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDirectory, boolean required, boolean failOnWarnings, boolean force) {
        return this.loadProjectContainer(sdk, feedback, sltFeatures, forceReasonableGenDirectory, required, failOnWarnings, force).map(ProjectContainer::project);
    }

    public Optional<ProjectContainer> loadProjectContainer(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean force) {
        return this.loadProjectContainer(sdk, feedback, sltFeatures, forceReasonableGenDestination, required, false, force);
    }

    public Optional<ProjectContainer> loadProjectContainer(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean failOnWarnings, boolean force) {
        return this.loadProjectContainer(sdk, feedback, sltFeatures, forceReasonableGenDestination, required, failOnWarnings, true, force);
    }

    public Optional<ProjectContainer> loadProjectContainer(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean failOnWarnings, boolean allowMissingComponents, boolean force) {
        return this.loadProjectContainer(sdk, feedback, sltFeatures, forceReasonableGenDestination, required, failOnWarnings, true, force, false);
    }

    public Optional<ProjectContainer> loadProjectContainer(IUcSdkContent sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean forceReasonableGenDestination, boolean required, boolean failOnWarnings, boolean allowMissingComponents, boolean force, boolean ignoreWarnings) {
        String projectLocation = this.projectExplicit.projectLocation();
        if (projectLocation != null && !this.optionalParams.isEmpty()) {
            feedback.out().println("Do not supply a project location as both a positional parameter and an option. Using " + projectLocation + " for this run.");
        }
        this.finalProjectLocation = projectLocation != null ? projectLocation : this.optionalParamOrNull();
        return this.projectExplicit.loadProjectContainerWithLocation(this.finalProjectLocation, sdk, feedback, sltFeatures, forceReasonableGenDestination, required, failOnWarnings, allowMissingComponents, false, force, ignoreWarnings);
    }

    private String optionalParamOrNull() {
        return !this.optionalParams.isEmpty() ? this.optionalParams.get(0) : null;
    }
}

