/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.StreamUtils;
import com.silabs.ss.framework.uc.api.sdk.UcSdk;
import com.silabs.ss.framework.uc.core.api.IUcAdditionalFramework;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.UcFramework;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.meta.IMetaParseEngine;
import com.silabs.ss.framework.uc.core.api.meta.IMetaSource;
import com.silabs.ss.framework.uc.core.api.meta.ParseIssue;
import com.silabs.ss.framework.uc.core.api.meta.UcFactory;
import com.silabs.ss.framework.uc.core.api.sdkextension.IUcSdkExtensionId;
import com.silabs.ss.framework.uc.core.internal.api.parse.SdkParser;
import com.silabs.ss.framework.uc.core.internal.persist.CorePersistables;
import com.silabs.ss.framework.uc.core.internal.persist.IPersistedCliConfig;
import com.silabs.ss.framework.uc.core.internal.persist.PersistEntry;
import com.silabs.ss.platform.api.descriptor.core.DescriptorUtils;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.descriptor.core.registry.RegistryUtils;
import com.silabs.ss.platform.api.descriptor.core.trust.DescriptorTrustUtils;
import com.silabs.ss.platform.api.descriptor.core.trust.IDescriptorTrustHandler;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.SDK;
import com.silabs.ss.platform.api.sdk.core.protocol.IProtocolDescriptor;
import com.silabs.ss.platform.api.sdk.core.protocol.Protocol;
import com.silabs.ss.platform.api.security.core.ISecurityCheckpoint;
import com.silabs.ss.platform.api.security.core.trust.ISignable;
import com.silabs.ss.platform.api.security.core.trust.ITrustedDescriptorStorage;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.SdkDescriptorWithPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import picocli.CommandLine;

public class CliSdk {
    public static final ImmutableList<String> SDK_NAMES = ImmutableList.of((Object)"-s", (Object)"--sdk");
    @CommandLine.Option(names={"-s", "--sdk"}, paramLabel="SDK_PATH", description={"Location of either sdk folder containing the .slcs file, or the file itself. This is only required if no default sdk is set -- use 'slc configuration -s SDK_PATH' to set it once for all future cli usages, or supply this method manually. If an sdk is supplied here and one is configured as default, the supplied one takes precedence."})
    private String sdkPath;
    @CommandLine.Option(names={"--sdk-extensions"}, paramLabel="EXTENSION_PATH_LIST", split=",", description={"Accepts a comma separated list of extension paths to be used in totality for the duration of this command, if the command requires it. This list supercedes anything defined in the .slcp if a project is provided -- this list will NOT combine with the .slcp's own list. In other words, once this argument is used, SLC will not use ANY .slcp metadata in the sdk_extension field for determining the current extension list, only this argument. The only exception is 'upgrade', where that information will be used to determine the last set of extensions a project was generated with. "})
    private List<String> extensionPaths;
    @CommandLine.Option(names={"--sdk-package-path"}, paramLabel="SDK_TOTALITY_LIST", split=",", description={"Accepts a comma separated list of paths that are interpreted automatically as either SDK Extensions or the SDK itself, allowing tools that see the SDK and its extensions as a more complex unit to better integrate with SLC. If this is defined, neither --sdk-extensions nor --sdk will be accepted, and this option will take total precedence. The operation will require that one and only one path is a real sdk (.slcs) and the rest be extensions. Anything else will produce an error and the command will not complete."})
    private List<String> sdkTotalityPaths;
    private static final String TRUST_TOTALITY_SHORT = "--tt";
    private static final String TRUST_TOTALITY_LONG = "--trust-totality";
    @CommandLine.Option(names={"--tt", "--trust-totality"}, description={"Trusts every sdk and extension in that sdk used for the duration of this command. This command is ONLY intended for CI/CD flows. The recommended flow for most everyone is to trust each sdk and extension directly, as that can trust at a path, id, and version level. Local developers can use the development trust argument. Only CI/CD flows where the sdk contents are already known to be from trusted sources should use this, as this eliminates additional CI/CD script complexity in terms of SLC setup. Be aware that when using --sdk-extensions or --sdk-package-path, whether via SLT Configuration Files or directly, SLC will treat those as explicit opt-ins and `--trust-totality` will be considered honoured by default."})
    private boolean totalTrust;
    private static final String RELOAD_SDK = "--reload-sdk";
    @CommandLine.Option(names={"--reload-sdk"}, description={"Reload the SDK from the input location from disk. Users should call this if the SDK has changed on disk and SLC is currently running in Daemon mode. This will also force a refresh of sdk extensions that aren't in the sdk that may have been referred to by past calls to any commands that allow directly setting unrelated extensions on the system to be 'part of the sdk' for the duration of the command"})
    private boolean reloadSdk;
    private static final String SDK_INFO = "--sdk-info";
    @CommandLine.Option(names={"--sdk-info"}, hidden=true, description={"Print the state of the loaded SDK"})
    private boolean printSdkInfo;

    private boolean verifyArguments(ICliOutput feedback) {
        if (this.sdkTotalityPaths != null && (this.sdkPath != null || this.extensionPaths != null)) {
            feedback.err().println("When using --sdk-package-path, neither --sdk nor --sdk-extensions may be specified.");
            return false;
        }
        return true;
    }

    public String sdkPath() {
        if (this.sdkPath == null) {
            return null;
        }
        return this.sdkPath.trim();
    }

    public void overrideLoadedSdk(String cliLocalPathSdk, String reason, ICliOutput feedback) {
        if (this.sdkTotalityPaths != null) {
            ListIterator<String> iter = this.sdkTotalityPaths.listIterator();
            while (iter.hasNext()) {
                String next = iter.next();
                if (!next.endsWith(".slcs")) continue;
                feedback.out().println(reason);
                iter.remove();
                break;
            }
            this.sdkTotalityPaths.add(cliLocalPathSdk);
        } else {
            if (this.sdkPath != null) {
                feedback.out().println(reason);
            }
            this.sdkPath = cliLocalPathSdk;
        }
    }

    public void addExtensionIf(String extLocal, String reason, ICliOutput feedback) {
        Path extLocalPath = feedback.resolve(extLocal);
        if (this.sdkTotalityPaths != null) {
            this.addExtensionIfSdkTotality(extLocalPath, extLocal, reason, feedback);
        } else if (this.extensionPaths != null) {
            this.addExtensionIfSdkExtensionsList(extLocalPath, extLocal, reason, feedback);
        } else {
            this.addExtensionIfCompletelyNew(extLocalPath, extLocal, reason, feedback);
        }
    }

    private void addExtensionIfSdkTotality(Path extLocalPath, String extLocal, String reason, ICliOutput feedback) {
        for (String ext : this.sdkTotalityPaths) {
            if (ext.endsWith(".slcs") || !FileUtils.isSameFile((Path)extLocalPath, (Path)feedback.resolve(ext))) continue;
            return;
        }
        feedback.out().println(reason);
        this.sdkTotalityPaths.add(extLocal);
    }

    private void addExtensionIfSdkExtensionsList(Path extLocalPath, String extLocal, String reason, ICliOutput feedback) {
        for (String ext : this.extensionPaths) {
            if (!FileUtils.isSameFile((Path)extLocalPath, (Path)feedback.resolve(ext))) continue;
            return;
        }
        feedback.out().println(reason);
        this.extensionPaths.add(extLocal);
    }

    private void addExtensionIfCompletelyNew(Path extLocalPath, String extLocal, String reason, ICliOutput feedback) {
        feedback.out().println(reason);
        feedback.out().println("Neither --sdk-package-path was used, nor were there existing extensions in --sdk-extensions. Be aware that usage of this command requires SLT-style conventions, so if you define extensions in your .slcp file, they will not be considered.");
        this.extensionPaths = new ArrayList<String>();
        this.extensionPaths.add(extLocal);
    }

    public Optional<Path> calculatedSdkLocation(ICliOutput feedback) {
        String decidedPath;
        if (!this.verifyArguments(feedback)) {
            return Optional.empty();
        }
        if (this.sdkTotalityPaths != null) {
            return Optional.ofNullable(this.findFromTotality(feedback));
        }
        String string = decidedPath = this.sdkPath() == null ? CliSdk.loadPathFromConfig(feedback.config()) : this.sdkPath();
        if (decidedPath == null) {
            return Optional.empty();
        }
        return Optional.of(feedback.resolve(decidedPath));
    }

    private Optional<Path> resolveIfTrueSdkNoException(Path potential, ICliOutput feedback) {
        try {
            return CliSlcSdk.resolveIfTrueSdk(potential, feedback);
        }
        catch (IOException e) {
            feedback.unifiedLogger().userError("Error reading location " + String.valueOf(potential) + " to determine viability as sdk or extension: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public ImmutableList<Path> calculatedExtensionLocations(ICliOutput feedback) {
        try {
            if (this.sdkTotalityPaths != null) {
                ImmutableList.Builder builder = new ImmutableList.Builder();
                for (String pkgPath : this.sdkTotalityPaths) {
                    Path resolvedPkgPath = feedback.resolve(pkgPath);
                    CliSlcSdk.resolveIfSlce(resolvedPkgPath, feedback).or(() -> this.resolveIfTrueSdkNoException(resolvedPkgPath, feedback).isPresent() ? Optional.empty() : Optional.of(resolvedPkgPath)).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                }
                return builder.build();
            }
            return this.extensionPaths != null ? (ImmutableList)this.extensionPaths.stream().map(feedback::resolve).collect(ImmutableList.toImmutableList()) : ImmutableList.of();
        }
        catch (IOException e) {
            feedback.err().println("Could not find extensions due to I/O issue searching: " + e.getMessage());
            feedback.unifiedLogger().userError("See logs for additional information.", (Throwable)e);
            return ImmutableList.of();
        }
    }

    public static Path checkForExtension(Path possible, ICliOutput feedback) {
        Path actualSlce = null;
        if (CliSdk.isSlce(possible)) {
            actualSlce = possible;
        } else if (Files.isDirectory(possible, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Stream<Path> files = Files.list(possible);){
                    for (Path f : StreamUtils.iterableOf(files)) {
                        if (!CliSdk.isSlce(f)) continue;
                        actualSlce = f;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                feedback.unifiedLogger().userError("Failure to find extension at " + String.valueOf(possible) + " due to " + e.getMessage(), (Throwable)e);
            }
        }
        return actualSlce != null ? actualSlce.normalize() : null;
    }

    public static boolean isSlce(Path p) {
        return "slce".equals(FileUtils.getExtension((File)p.toFile()));
    }

    public static Optional<RequestedSdkExtension> loadSlce(Path slce, IUcFramework existingSearch, ExecutorService pool, ICliOutput feedback) throws IOException {
        IMetaSource extParseInput;
        Path extParent = slce.getParent();
        IMetaParseEngine smallEngine = UcFactory.parseEngine((ExecutorService)pool, (int)1);
        Optional refMaybe = SdkParser.parseFrameworkId((IMetaParseEngine)smallEngine, (IMetaSource)(extParseInput = UcFactory.source((Path)slce)), (boolean)true, (IUnifiedLogger)feedback.unifiedLogger());
        if (refMaybe.isEmpty()) {
            feedback.out().println("One of the requested sdk extensions, " + String.valueOf(slce) + ", could not be parsed for identification and version information.");
            feedback.out().println("Parsing issues encountered: ");
            smallEngine.warnings().map(ParseIssue::message).forEach(warn -> feedback.out().println((String)warn));
            smallEngine.errors().map(ParseIssue::message).forEach(error -> feedback.out().println((String)error));
            return Optional.empty();
        }
        IUcSdkExtensionId ref = (IUcSdkExtensionId)refMaybe.get();
        Optional<IUcAdditionalFramework> additionalFrameworkToUse = existingSearch.findSdkExtension(ref).filter(additional -> FileUtils.isSameFile((Path)additional.directory().toPath(), (Path)extParent)).or(() -> CliSdk.getOrParseExtension(slce, feedback));
        return additionalFrameworkToUse.map(extFrwk -> new RequestedSdkExtension((IUcAdditionalFramework)extFrwk, ref));
    }

    private static Optional<IUcAdditionalFramework> getOrParseExtension(Path slce, ICliOutput feedback) {
        UcFramework.UcFrameworkExtContainer result = UcSdk.extensionManager().frameworkFor(slce);
        if (result.framework() != null && result.errors().isEmpty()) {
            return Optional.of(result.framework());
        }
        feedback.out().println("Errors loading extension from " + String.valueOf(slce) + ": " + result.errors().stream().map(ParseIssue::message).collect(Collectors.joining(System.lineSeparator())));
        return Optional.empty();
    }

    public boolean isSltEnabled() {
        return this.extensionPaths != null || this.sdkTotalityPaths != null;
    }

    private Path findFromTotality(ICliOutput feedback) {
        assert (this.sdkTotalityPaths != null) : "Should not be calling helper method without checking null status of variable.";
        Path theSdk = null;
        for (String potential : this.sdkTotalityPaths) {
            Optional<Path> foundPotential;
            block6: {
                Path loc = feedback.resolve(potential);
                try {
                    foundPotential = CliSlcSdk.resolveIfTrueSdk(loc, feedback);
                    if (!foundPotential.isPresent()) continue;
                    if (theSdk == null) break block6;
                    feedback.err().println("Multiple .slcs files found in --sdk-package-path listing. Only one is allowed: First was " + String.valueOf(theSdk) + " but also found " + String.valueOf(foundPotential.get()));
                    return null;
                }
                catch (IOException e) {
                    feedback.err().println("Error attempting to find sdk at location " + String.valueOf(loc) + ". Got: " + e.getMessage());
                    feedback.unifiedLogger().userError("Cannot read potential location.", (Throwable)e);
                    return null;
                }
            }
            theSdk = foundPotential.get();
        }
        if (theSdk == null) {
            feedback.err().println("No sdk provided. Operation cancelled. Remember --sdk is ignored if using --sdk-package-path.");
        }
        return theSdk;
    }

    public Optional<SdkDescriptorWithPath> loadSdkDescriptor(ICliOutput feedback) {
        Path sdkLocation = this.calculatedSdkLocation(feedback).orElse(null);
        if (sdkLocation == null) {
            return Optional.empty();
        }
        return this.loadSdkDescriptorInternal(sdkLocation).map(desc -> new SdkDescriptorWithPath(sdkLocation, (ISDKDescriptor)desc));
    }

    private Optional<ISDKDescriptor> loadSdkDescriptorInternal(Path sdkLocation) {
        assert (sdkLocation != null) : "Callers should return an empty SdkDescriptorWithPath to make it clear the sdk location is empty vs the descriptor is unavailable.";
        Path parentSdkLocation = Files.isRegularFile(sdkLocation, new LinkOption[0]) ? sdkLocation.getParent() : sdkLocation;
        ISDKDescriptor[] sdks = (ISDKDescriptor[])RegistryUtils.detectInDirectory((IRegistry)SDK.manager(), (File)parentSdkLocation.toFile(), (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        Optional<ISDKDescriptor> sdk = sdks != null && sdks.length > 0 ? Optional.of(sdks[0]) : Optional.empty();
        return sdk;
    }

    public Optional<SdkDescriptorWithPath> loadSdk(ICliOutput feedback) {
        return this.loadSdk(feedback, true);
    }

    /*
     * Exception decompiling
     */
    public Optional<SdkDescriptorWithPath> loadSdk(ICliOutput feedback, boolean allowReload) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean ensureTotallyTrusted(ISDKDescriptor sdkDesc, Path sdkLocation, ICliOutput feedback) {
        if (this.sdkPath() == null && this.sdkTotalityPaths == null) {
            feedback.out().println("Refusing to continue: opting into total trust requires being explicit in the passed sdk. Sdk loaded via previous calls to 'slc configuration' at " + String.valueOf(sdkLocation) + " is not acceptable for this argument. For full transparency, totality trusting requires explicitly opting into the sdk in question.");
            return false;
        }
        IDescriptorTrustHandler checkpointAdapter = (IDescriptorTrustHandler)SDK.manager().getAdapter(IDescriptorTrustHandler.class);
        ISecurityCheckpoint checkpoint = checkpointAdapter != null ? checkpointAdapter.securityCheckpoint() : ISecurityCheckpoint.instance();
        ITrustedDescriptorStorage checkpointStorage = (checkpoint = checkpoint != null ? checkpoint : ISecurityCheckpoint.instance()).trustedStorage();
        boolean trustSdk = checkpointStorage.trust((ISignable)sdkDesc);
        if (trustSdk) {
            DescriptorTrustUtils.setupTrustState((IDescriptor)sdkDesc, (IAdaptable)SDK.manager(), null);
            feedback.out().println("The sdk " + sdkDesc.getId() + " has now been trusted. ");
        }
        if (SDK.manager().findDescriptor(sdkDesc.getId()) == null) {
            SDK.manager().registerDescriptor((IDescriptor)sdkDesc);
        }
        File[] sdkExtPaths = DescriptorUtils.getInstallPath((IDescriptor)sdkDesc).map(p -> p.append("extension").toFile()).map(File::listFiles).orElse(new File[0]);
        ArrayList<IProtocolDescriptor> prots = new ArrayList<IProtocolDescriptor>();
        File[] fileArray = sdkExtPaths;
        int n = sdkExtPaths.length;
        int n2 = 0;
        while (n2 < n) {
            File extPath = fileArray[n2];
            IProtocolDescriptor[] prot = (IProtocolDescriptor[])RegistryUtils.detectInDirectory((IRegistry)Protocol.registry(), (File)extPath, (boolean)false, null);
            prots.addAll(Arrays.asList(prot));
            ++n2;
        }
        boolean newTrust = prots.stream().map(arg_0 -> ((ITrustedDescriptorStorage)checkpointStorage).trust(arg_0)).reduce((b1, b2) -> b1 != false || b2 != false).orElse(false);
        if (newTrust) {
            Protocol.registry().resetSync();
        }
        return true;
    }

    private static String loadPathFromConfig(IPersistedCliConfig config) {
        Optional configSdk = config.get((PersistEntry)CorePersistables.SDK);
        return configSdk.orElse(null);
    }

    public record RequestedSdkExtension(IUcAdditionalFramework extFramework, IUcSdkExtensionId id) {
    }
}

