/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin.security;

import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.SortedSet;
import picocli.CommandLine;

public final class FileSummaryOutputMixin {
    @CommandLine.Option(names={"--summary-output"}, description={"Name (or path) to a summary file that will have included in it a list, in sorted order, of all files used during either signing or verification. You may use this to confirm if certain files are becoming part of a signature when they shouldn't, or if important files are being missed. If the file already exists, it is overwritten."}, paramLabel="SUMMARY_FILE")
    private String summaryFileOutput;

    public void writeSummaryIfRequested(SortedSet<Path> summary, ICliOutput feedback) throws IOException {
        if (this.summaryFileOutput != null) {
            Path outputFile = feedback.resolve(this.summaryFileOutput);
            if (Files.isDirectory(outputFile, new LinkOption[0])) {
                feedback.err().println("Cannot print summary to " + this.summaryFileOutput + ": is a directory.");
                return;
            }
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            if (Files.exists(outputFile, new LinkOption[0])) {
                feedback.out().println("Summary file already exists -- overwriting.");
            } else {
                Files.createFile(outputFile, new FileAttribute[0]);
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(outputFile, new OpenOption[0]);){
                for (Path sum : summary) {
                    writer.write(sum.toAbsolutePath().toString());
                    writer.newLine();
                }
                feedback.out().println("Wrote out summary of files into " + String.valueOf(outputFile));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

