/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.model;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.uc.core.api.comp.ComponentQuality;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;

public interface ICliValidateLogic {
    public int validateFile(Path var1, Path var2, Set<ComponentQuality> var3, ICliOutput var4);

    public static int subRunValidate(Path resolverLocation, String pathToFile, Set<ComponentQuality> validQualities, ICliValidateLogic validateLogic, ICliOutput feedback) {
        Path fileLocation = feedback.resolve(pathToFile);
        if (!Files.isRegularFile(fileLocation, new LinkOption[0])) {
            feedback.out().println("Could not resolve " + String.valueOf(fileLocation) + " in current directory. Attempting to resolve against sdk root");
            fileLocation = FileUtils.resolve((Path)resolverLocation, (String)pathToFile);
        }
        feedback.out().println("Validating " + String.valueOf(fileLocation.getFileName()) + " using sdk " + String.valueOf(resolverLocation));
        if (!Files.exists(fileLocation, new LinkOption[0])) {
            feedback.err().println(String.valueOf(fileLocation) + " not found.");
            return 1;
        }
        if (Files.isDirectory(fileLocation, new LinkOption[0])) {
            feedback.err().println(String.valueOf(fileLocation) + " not a file.");
            return 1;
        }
        int result = validateLogic.validateFile(resolverLocation, fileLocation, validQualities, feedback);
        return result;
    }
}

