/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.pyvalidate;

import com.google.common.collect.ImmutableSet;
import com.silabs.ss.framework.uc.api.python.validator.ConfigValidationIssue;
import com.silabs.ss.framework.uc.api.python.validator.PyTarget;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.IUcSharedMetadata;
import com.silabs.ss.framework.uc.internal.api.python.validator.PyProjectValidation;
import com.silabs.ss.framework.uc.internal.api.python.validator.PyQuickFix;
import com.silabs.uc.cli.internal.command.pyvalidate.PyComponentIdDryRun;
import com.silabs.uc.cli.internal.command.pyvalidate.PyConfigurableDryRun;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public final class PyValidationProjectDryRun
implements PyProjectValidation {
    private final Map<String, PyConfigurableDryRun> defineIdToDefine = new HashMap<String, PyConfigurableDryRun>();
    private final Set<String> selectedComponents = new HashSet<String>();
    private final Map<String, PyComponentIdDryRun> compIdToComponent = new HashMap<String, PyComponentIdDryRun>();
    private final List<ConfigValidationIssue> issues = new ArrayList<ConfigValidationIssue>();
    private Set<String> provided = ImmutableSet.of();
    private final IUcFramework framework;

    public PyValidationProjectDryRun(IUcFramework framework) {
        this.framework = framework;
    }

    public Map<String, PyConfigurableDryRun> defineIdToDefine() {
        return this.defineIdToDefine;
    }

    public PyConfigurableDryRun addConfigurable(String name, String value) {
        PyConfigurableDryRun config = new PyConfigurableDryRun(name, value);
        this.defineIdToDefine.put(name, config);
        return config;
    }

    public void setProvided(Set<String> provided) {
        this.provided = provided;
    }

    public PyComponentIdDryRun selectComponent(String name) {
        this.selectedComponents.add(name);
        return this.registerComponentToSdk(name);
    }

    public PyComponentIdDryRun registerComponentToSdk(String name) {
        PyComponentIdDryRun pyIdObject = this.compIdToComponent.get(name);
        if (pyIdObject == null) {
            String label = this.framework != null ? this.framework.findComponent(name).map(IUcSharedMetadata::label).orElse(name) : name;
            pyIdObject = new PyComponentIdDryRun(name, label);
            this.compIdToComponent.put(name, pyIdObject);
        }
        return pyIdObject;
    }

    public PyComponentIdDryRun tieConfigurableToComponent(String defineId, String compId, String defaultValue) {
        PyConfigurableDryRun configurable = this.defineIdToDefine.get(defineId);
        if (configurable == null) {
            configurable = new PyConfigurableDryRun(defineId, defaultValue);
            this.defineIdToDefine.put(defineId, configurable);
        }
        PyComponentIdDryRun pyIdObject = this.registerComponentToSdk(compId);
        configurable.tieToComponent(pyIdObject);
        return pyIdObject;
    }

    public PyConfigurableDryRun config(String id) {
        return this.defineIdToDefine.get(id);
    }

    public PyComponentIdDryRun component(String id) {
        return this.compIdToComponent.get(id);
    }

    public boolean is_selected(String id) {
        return this.selectedComponents.contains(id);
    }

    public boolean is_provided(String id) {
        return this.provided.contains(id);
    }

    public void warning(String problem, PyTarget target, String desc, PyQuickFix quickfix) {
        this.issues.add(new ConfigValidationIssue(ConfigValidationIssue.ErrorType.STANDARD, problem, target, desc, quickfix, ConfigValidationIssue.Severity.WARNING));
    }

    public void error(String problem, PyTarget target, String desc, PyQuickFix quickfix) {
        this.issues.add(new ConfigValidationIssue(ConfigValidationIssue.ErrorType.STANDARD, problem, target, desc, quickfix, ConfigValidationIssue.Severity.ERROR));
    }

    public Stream<ConfigValidationIssue> getIssues() {
        return this.issues.stream();
    }

    public void genericError(ConfigValidationIssue issue) {
        this.issues.add(issue);
    }
}

