/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.trust;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.silabs.ss.framework.uc.internal.api.sdk.UcSdkProtocolDetector;
import com.silabs.ss.platform.api.descriptor.core.DescriptorUtils;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IVersionedDescriptor;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.descriptor.core.registry.RegistryUtils;
import com.silabs.ss.platform.api.rcp.core.CommonSplitters;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.SDK;
import com.silabs.ss.platform.api.sdk.core.SDKUtils;
import com.silabs.ss.platform.api.sdk.core.protocol.IProtocolDescriptor;
import com.silabs.ss.platform.api.sdk.core.protocol.Protocol;
import com.silabs.ss.platform.api.security.core.ISecurityCheckpoint;
import com.silabs.ss.platform.api.security.core.trust.ISignable;
import com.silabs.ss.platform.api.security.core.trust.ITrustedDescriptorStorage;
import com.silabs.uc.cli.internal.command.mixin.UcCliTrustMixin;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.equinox.app.IApplication;
import org.osgi.framework.Version;

public final class SignatureTrustOrDisavow {
    private static final Splitter UC_EXTENSION_SPLITTER = Splitter.on((String)"uc.extension.");
    private final boolean devTrust;
    private final boolean extensionUsed;
    private final String extensionId;
    private final String extensionPath;
    private final ICliOutput feedback;
    private final ITrustedDescriptorStorage storage;
    private final ISDKDescriptor descriptor;

    public SignatureTrustOrDisavow(UcCliTrustMixin trustMixin, ISDKDescriptor descriptor, ICliOutput feedback) {
        this.devTrust = trustMixin.devTrust();
        this.extensionId = trustMixin.extensionId();
        this.extensionPath = trustMixin.extensionPath();
        this.extensionUsed = this.extensionId != null || this.extensionPath != null;
        this.storage = ISecurityCheckpoint.instance().trustedStorage();
        this.feedback = feedback;
        this.descriptor = descriptor;
    }

    public int doTrust() {
        return this.doTrustOrDisavow(true);
    }

    public int doDisavow() {
        return this.doTrustOrDisavow(false);
    }

    private int doTrustOrDisavow(boolean trust) {
        return this.extensionUsed ? this.trustOrDisavowExtension(this.descriptor, this.storage, trust, this.feedback) : this.trustOrDisavowSdk(this.descriptor, this.storage, trust, this.feedback);
    }

    private int trustOrDisavowSdk(ISDKDescriptor descriptor, ITrustedDescriptorStorage storage, boolean trust, ICliOutput feedback) {
        boolean wasHandled;
        boolean bl = wasHandled = trust ? this.trust(storage, (ISignable)descriptor) : this.disavow(storage, (ISignable)descriptor);
        if (wasHandled) {
            if (this.devTrust) {
                try {
                    feedback.out().println(SignatureTrustOrDisavow.successMessageDev((IVersionedDescriptor)descriptor, trust));
                }
                catch (IOException e) {
                    feedback.err().println("Could not fetch installation path: " + e.getMessage());
                    return 2;
                }
            } else {
                feedback.out().println(SignatureTrustOrDisavow.successMessageSingle((IVersionedDescriptor)descriptor, trust));
            }
        } else {
            feedback.out().println(SignatureTrustOrDisavow.alreadyHandled((IVersionedDescriptor)descriptor, trust));
        }
        return IApplication.EXIT_OK;
    }

    private int trustOrDisavowExtension(ISDKDescriptor sdkDesc, ITrustedDescriptorStorage storage, boolean trust, ICliOutput feedback) {
        assert (this.extensionId != null || this.extensionPath != null);
        Path sdkInstallPath = DescriptorUtils.getInstallPath((IDescriptor)sdkDesc).map(p -> p.toFile().toPath()).orElse(null);
        if (sdkInstallPath == null) {
            feedback.out().println("Failed to load SDK installation path.");
            return 1;
        }
        ImmutableList<IProtocolDescriptor> toHandle = this.loadExtensionProtocol(sdkInstallPath);
        if (toHandle.isEmpty()) {
            return 1;
        }
        for (IProtocolDescriptor proto : toHandle) {
            boolean handled;
            boolean bl = handled = trust ? storage.trust((ISignable)proto) : storage.disavow((ISignable)proto);
            if (handled) {
                feedback.out().println(SignatureTrustOrDisavow.successMessageExt((IVersionedDescriptor)proto, trust));
                continue;
            }
            feedback.out().println(SignatureTrustOrDisavow.alreadyHandledExt((IVersionedDescriptor)proto, trust));
        }
        return IApplication.EXIT_OK;
    }

    private ImmutableList<IProtocolDescriptor> loadExtensionProtocol(Path sdkInstallPath) {
        SDK.manager().registerDescriptor((IDescriptor)this.descriptor);
        if (this.extensionId != null) {
            return this.loadExtensionProtocolFromId(sdkInstallPath);
        }
        return this.loadExtensionProtocolFromPath(sdkInstallPath);
    }

    private ImmutableList<IProtocolDescriptor> loadExtensionProtocolFromPath(Path sdkInstallPath) {
        Optional<Object> sdkRoot;
        Path extDir = this.findExtFile(this.feedback.resolve(this.extensionPath));
        if (extDir == null && (extDir = this.findExtFile(sdkInstallPath.resolve(this.extensionPath))) == null) {
            this.feedback.out().println("Input extension path " + this.extensionPath + " does not exist!");
            return ImmutableList.of();
        }
        try {
            sdkRoot = UcSdkProtocolDetector.getSdkExtensionPaths((Path)sdkInstallPath).filter(extDir::equals).findAny();
        }
        catch (IOException iOException) {
            sdkRoot = Optional.empty();
        }
        if (!sdkRoot.isPresent()) {
            this.feedback.out().println("Input extension path " + this.extensionPath + " is not valid for the requested SDK at " + String.valueOf(sdkInstallPath));
            return ImmutableList.of();
        }
        Object[] protos = (IProtocolDescriptor[])RegistryUtils.detectInDirectory((IRegistry)Protocol.registry(), (File)extDir.toFile(), (boolean)false, null);
        ImmutableList protosList = ImmutableList.copyOf((Object[])protos);
        if (protosList.isEmpty()) {
            this.feedback.out().println("No extension of that id and version exists.");
        }
        return protosList;
    }

    private Path findExtFile(Path extDir) {
        if (Files.isRegularFile(extDir, new LinkOption[0])) {
            return extDir.getParent();
        }
        if (!Files.isDirectory(extDir, new LinkOption[0])) {
            return null;
        }
        return extDir;
    }

    private ImmutableList<IProtocolDescriptor> loadExtensionProtocolFromId(Path sdkInstallPath) {
        ImmutableList toHandle;
        Version customerExtVersion;
        List customerRequested = CommonSplitters.COLON.splitToList((CharSequence)this.extensionId);
        if (customerRequested.size() != 2) {
            this.feedback.err().println("Provided extension, " + this.extensionId + ", is not in the right format. Please use the id of the the extension, a single colon, and the version number.");
            return ImmutableList.of();
        }
        String customerExtId = (String)customerRequested.get(0);
        try {
            customerExtVersion = new Version((String)customerRequested.get(1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.feedback.err().println("Provided extension, " + this.extensionId + " uses a version format that is unknown. Please use MAJOR.MINOR.PATCH form.");
            return ImmutableList.of();
        }
        try {
            Optional<IProtocolDescriptor> found = UcSdkProtocolDetector.getSdkExtensionPaths((Path)sdkInstallPath).map(p -> (IProtocolDescriptor[])RegistryUtils.detectInDirectory((IRegistry)Protocol.registry(), (File)p.toFile(), (boolean)false, null)).flatMap(Arrays::stream).filter(desc -> this.isDescriptorRequested((IProtocolDescriptor)desc, customerExtId, customerExtVersion)).findFirst();
            toHandle = found.map(ImmutableList::of).orElse(ImmutableList.of());
        }
        catch (IOException iOException) {
            toHandle = ImmutableList.of();
        }
        if (toHandle.isEmpty()) {
            this.feedback.out().println("No extension of that id and version exists.");
        }
        return toHandle;
    }

    private boolean isDescriptorRequested(IProtocolDescriptor desc, String reqId, Version reqVersion) {
        List unversionedId = UC_EXTENSION_SPLITTER.splitToList((CharSequence)desc.getUnversionedId());
        String descId = unversionedId.size() == 2 ? (String)unversionedId.get(1) : desc.getUnversionedId();
        Version descVersion = desc.getVersion();
        return descId.equals(reqId) && descVersion.getMajor() == reqVersion.getMajor() && descVersion.getMinor() == reqVersion.getMinor() && descVersion.getMicro() == reqVersion.getMicro();
    }

    private boolean trust(ITrustedDescriptorStorage storage, ISignable desc) {
        return this.devTrust ? storage.trustExtended(desc) : storage.trust(desc);
    }

    private boolean disavow(ITrustedDescriptorStorage storage, ISignable desc) {
        return this.devTrust ? storage.disavowExtended(desc) : storage.disavow(desc);
    }

    private static String successMessageDev(IVersionedDescriptor desc, boolean trust) throws IOException {
        return trust ? "Any sdks at " + SignatureTrustOrDisavow.descriptorLabel(desc) + " are now trusted." : "Disavowed any knowledge that all sdks located in " + SignatureTrustOrDisavow.descriptorLabel(desc) + " are trusted.";
    }

    private static String successMessageSingle(IVersionedDescriptor desc, boolean trust) {
        return trust ? "The sdk " + SignatureTrustOrDisavow.descriptorLabel(desc) + " is now trusted. " : "Disavowed any knowledge that " + SignatureTrustOrDisavow.descriptorLabel(desc) + " is trusted.";
    }

    private static String alreadyHandled(IVersionedDescriptor desc, boolean trust) {
        return "The sdk " + SignatureTrustOrDisavow.descriptorLabel(desc) + " is already " + (trust ? "trusted" : "not trusted") + " at the requested level. Nothing to do.";
    }

    private static String successMessageExt(IVersionedDescriptor desc, boolean trust) {
        return trust ? "The extension " + SignatureTrustOrDisavow.descriptorLabel(desc) + " is now trusted." : "Disavowed any knowledge that " + SignatureTrustOrDisavow.descriptorLabel(desc) + " is trusted.";
    }

    private static String alreadyHandledExt(IVersionedDescriptor desc, boolean trust) {
        return "The extension " + SignatureTrustOrDisavow.descriptorLabel(desc) + " is already " + (trust ? "trusted" : "not trusted") + " at the requested level. Nothing to do.";
    }

    private static String descriptorLabel(IVersionedDescriptor desc) {
        return DescriptorUtils.getInstallPath((IDescriptor)desc).map(String::valueOf).orElse(SDKUtils.labelWithVersion((IVersionedDescriptor)desc)) + " ( " + desc.getId() + " ) ";
    }
}

