/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.util;

import com.google.common.base.Splitter;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.comp.ApiPartaker;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcProjectComponent;
import com.silabs.ss.framework.uc.core.api.comp.UcInstancedComponent;
import com.silabs.ss.framework.uc.core.api.comp.UcProjectComponent;
import com.silabs.ss.framework.uc.core.api.exception.UcConfigurationException;
import com.silabs.ss.framework.uc.core.api.sdkextension.IUcSdkExtensionSoftReference;
import com.silabs.ss.framework.uc.core.api.sdkextension.ImmutableSdkExtensionSoftReference;
import com.silabs.ss.framework.uc.core.internal.api.UcAdditionalFrameworkUtils;
import com.silabs.ss.platform.api.rcp.core.CommonSplitters;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class CliProjectUtils {
    private static final Splitter EXT_SPLITTER = Splitter.on((char)';').omitEmptyStrings().trimResults();

    private CliProjectUtils() {
    }

    public static Set<IUcProjectComponent> computeComponentList(List<String> arg, boolean allowInstanceOmit, boolean force, IUcFramework framework, ICliOutput feedback) throws UcConfigurationException {
        if (arg.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IUcProjectComponent> computedList = new HashSet<IUcProjectComponent>();
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<String> handledComponentIds = new HashSet<String>();
        for (String idInstanceCombo : arg) {
            String id;
            List instanceSplit = CommonSplitters.COLON.splitToList((CharSequence)idInstanceCombo);
            if (instanceSplit.isEmpty()) {
                feedback.out().println("Encountered an empty component:instance reference. Ensure there is only one comma between component ids in a 'with' or 'without' statement.");
                continue;
            }
            String displayableId = id = (String)instanceSplit.get(0);
            Optional<String> displayableExtension = Optional.empty();
            List idExt = EXT_SPLITTER.splitToList((CharSequence)id);
            if (idExt.size() > 1) {
                id = UcAdditionalFrameworkUtils.mangleIdIfNeeded((String)((String)idExt.get(0)), (IUcSdkExtensionSoftReference)ImmutableSdkExtensionSoftReference.make((String)((String)idExt.get(1))));
                displayableId = (String)idExt.get(0);
                displayableExtension = Optional.of((String)idExt.get(1));
            }
            if (handledComponentIds.contains(id)) {
                feedback.out().println("Duplicate component id " + ApiPartaker.calculateDisplayableId((String)displayableId, displayableExtension) + ": ignoring " + idInstanceCombo);
                continue;
            }
            handledComponentIds.add(id);
            Optional found = framework.findComponent(id);
            if (found.isPresent()) {
                IUcComponent component = (IUcComponent)found.get();
                boolean isInstantiable = component.instantiability().isInstantiable();
                if (instanceSplit.size() > 1) {
                    if (isInstantiable) {
                        List instances = instanceSplit.subList(1, instanceSplit.size());
                        List<String> uniqueInstances = instances.stream().distinct().collect(Collectors.toList());
                        if (instances.size() != uniqueInstances.size()) {
                            feedback.out().println("Duplicated instance names in argument -- duplicates will be ignored. " + String.valueOf(arg));
                        }
                        uniqueInstances.forEach(n -> {
                            boolean bl = computedList.add((IUcProjectComponent)UcInstancedComponent.create((IUcComponent)component, (String)n));
                        });
                        continue;
                    }
                    errors.add(CliProjectUtils.componentErrorStr(displayableId, displayableExtension, " is not instantiable, yet instance list given. " + String.valueOf(arg)));
                    continue;
                }
                if (!isInstantiable || allowInstanceOmit) {
                    computedList.add((IUcProjectComponent)UcProjectComponent.create((IUcComponent)component));
                    continue;
                }
                errors.add(CliProjectUtils.componentErrorStr(displayableId, displayableExtension, " is instantiable, yet no instance list was provided. Please use ':' after the component id to separate each unique instance name."));
                continue;
            }
            errors.add(CliProjectUtils.componentErrorStr(displayableId, displayableExtension, " does not exist."));
        }
        CliProjectUtils.handleErrors(feedback, force, errors);
        return computedList;
    }

    private static String componentErrorStr(String displayableId, Optional<String> displayableExtension, String errorMsg) {
        return "Component " + ApiPartaker.calculateDisplayableId((String)displayableId, displayableExtension) + errorMsg;
    }

    private static void handleErrors(ICliOutput feedback, boolean allowFailures, List<String> errStrs) throws UcConfigurationException {
        if (errStrs.isEmpty()) {
            return;
        }
        errStrs.forEach(feedback.errPrintln());
        if (!allowFailures) {
            feedback.err().println("Refusing to continue. Either fix issues or use '--force' to force generation.");
            throw new UcConfigurationException(TextUtils.catenateStrings(errStrs, (String)","));
        }
    }
}

