/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.util;

import com.google.common.collect.ImmutableList;
import java.util.Optional;

public final class OptionExtraction {
    private OptionExtraction() {
    }

    public static Optional<String> argValue(String[] args, ImmutableList<String> names) {
        int i = 0;
        while (i < args.length) {
            String possibleValue = OptionExtraction.checkAndGetArg(args, i, names);
            if (possibleValue != null) {
                return Optional.of(possibleValue);
            }
            ++i;
        }
        return Optional.empty();
    }

    public static boolean argToggle(String[] args, ImmutableList<String> names) {
        int i = 0;
        while (i < args.length) {
            for (String name : names) {
                if (!args[i].equals(name)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String checkAndGetArg(String[] args, int index, ImmutableList<String> names) {
        if (args.length - 1 == index) {
            return null;
        }
        for (String a : names) {
            if (a.equals(args[index])) {
                return args[index + 1];
            }
            if (!args[index].startsWith(a + "=")) continue;
            return args[index].replace(a + "=", "");
        }
        return null;
    }
}

