/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.daemon.creator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.uc.cli.internal.daemon.creator.ISlcDaemonCreator;
import com.silabs.uc.cli.internal.daemon.creator.OSGiDaemonVersionInfo;
import com.silabs.uc.cli.internal.daemon.creator.SlcCliDaemonLogger;
import com.silabs.uc.cli.internal.daemon.shared.DaemonSearchResult;
import com.silabs.uc.cli.internal.daemon.shared.DaemonUtils;
import com.silabs.uc.cli.internal.daemon.shared.DaemonVersionInfo;
import com.silabs.uc.cli.internal.daemon.shared.DataDirectoryStatus;
import com.silabs.uc.cli.internal.daemon.shared.ISlcDaemon;
import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public final class SlcDaemonSharedDataCreator {
    private static final Multimap<ISlcDaemon, SlcDaemonSharedData> onceAndFutureCreators = HashMultimap.create();

    private SlcDaemonSharedDataCreator() {
    }

    public static Optional<SlcDaemonSharedData> findExistingOrFillAwaiting(ISlcDaemonCreator creator, int portNumber, IUnifiedLogger logger) throws IOException {
        SlcCliDaemonLogger daemonLogger;
        DaemonVersionInfo ourVersion = OSGiDaemonVersionInfo.create(creator);
        DaemonSearchResult result = DaemonUtils.searchForMatchingOrAwaiting(creator, ourVersion, daemonLogger = SlcCliDaemonLogger.fromUnifiedLogger(logger));
        if (result instanceof DaemonSearchResult.AcceptableDaemon) {
            return Optional.of(((DaemonSearchResult.AcceptableDaemon)result).daemon());
        }
        if (result instanceof DaemonSearchResult.AwaitingFiles) {
            List<DataDirectoryStatus> awaitingData = ((DaemonSearchResult.AwaitingFiles)result).awaiting();
            for (DataDirectoryStatus awaiting : awaitingData) {
                Path directory = awaiting.dataFolder();
                Optional<SlcDaemonSharedData> filledIn = DaemonUtils.fillInRunning(ourVersion, directory, creator, portNumber, daemonLogger);
                if (filledIn.isPresent()) {
                    onceAndFutureCreators.put((Object)creator, (Object)filledIn.get());
                    return filledIn;
                }
                Optional<DataDirectoryStatus> recheckStatus = DaemonUtils.checkDataDirectory(directory, ourVersion, true, daemonLogger);
                if (!recheckStatus.isPresent() || !recheckStatus.get().sharedData().isPresent()) continue;
                return recheckStatus.get().sharedData();
            }
        }
        return Optional.empty();
    }

    public static ImmutableMultimap<ISlcDaemon, SlcDaemonSharedData> whoCreatedFiles() {
        return ImmutableMultimap.copyOf(onceAndFutureCreators);
    }
}

