/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.silabs.ss.framework.uc.core.api.IUcAdditionalFramework;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.IUcProjectFramework;
import com.silabs.ss.framework.uc.core.api.comp.ComponentQuality;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.exception.MultiExceptionContainer;
import com.silabs.ss.framework.uc.core.api.meta.SourceFile;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.StudioModelFactory;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.IUcExampleResult;
import com.silabs.uc.cli.internal.model.UcExampleDefinition;
import com.silabs.uc.cli.internal.model.UcExampleProjectResult;
import com.silabs.uc.cli.internal.model.UcExampleWorkspaceResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class UcExampleResults {
    private static final Map<String, String> PACKAGE_VERSION_MAPPING = Map.of("simplicity_sdk", "simplicity-sdk", "wiseconnect3_sdk", "wiseconnect");
    private final Map<String, Set<IUcComponent>> pkgBoardComps = new ConcurrentHashMap<String, Set<IUcComponent>>();
    private final UcExampleDefinition exampleDef;
    private final boolean calcCompat;
    private final IUcSdkContent sdk;
    private final IUcFramework framework;
    private final Path sdkRoot;
    private final ICliOutput feedback;
    private final ExecutorService threadPool;
    private ImmutableMap<Path, IUcExampleResult> exampleMap;
    private Map<String, Multimap<ComponentQuality, IUcExampleResult>> exampleMapping;

    public UcExampleResults(IUcSdkContent sdk, IUcFramework framework, UcExampleDefinition exampleDef, boolean calcCompat, ICliOutput feedback, ExecutorService threadPool) {
        this.calcCompat = calcCompat;
        this.exampleDef = exampleDef;
        this.sdk = sdk;
        this.framework = framework;
        this.sdkRoot = sdk.framework().directory().toPath();
        this.feedback = feedback;
        this.exampleMap = ImmutableMap.of();
        this.threadPool = threadPool;
    }

    public UcExampleDefinition exampleDefinition() {
        return this.exampleDef;
    }

    public boolean calculateCompatibility() {
        return this.calcCompat;
    }

    public IUcSdkContent sdk() {
        return this.sdk;
    }

    public IUcFramework framework() {
        return this.framework;
    }

    public Map<String, Set<IUcComponent>> pkgBoardComps() {
        return this.pkgBoardComps;
    }

    public ImmutableMap<Path, IUcExampleResult> exampleMap() {
        return this.exampleMap;
    }

    public Map<String, Multimap<ComponentQuality, IUcExampleResult>> load(Set<Path> filterDirs, Set<String> filterPkgs, Set<String> filterQuals) {
        if (this.exampleMapping != null) {
            return this.exampleMapping;
        }
        try {
            ExamplesFileVisitor visitor = new ExamplesFileVisitor();
            Set<Path> scanDirs = filterDirs.isEmpty() ? Collections.singleton(this.sdkRoot) : filterDirs;
            for (Path scanDir : scanDirs) {
                if (!Files.exists(scanDir, new LinkOption[0])) continue;
                Files.walkFileTree(scanDir, Set.of(), Integer.MAX_VALUE, visitor);
            }
            this.exampleMap = (ImmutableMap)((Stream)visitor.fileStream().parallel()).map(p -> this.create(p.toFile(), this.threadPool)).collect(ImmutableMap.toImmutableMap(IUcExampleResult::path, p -> p));
            visitor.exceptions.ifExcept(e -> this.feedback.unifiedLogger().userError("Errors searching sdk directory: " + String.valueOf(this.sdkRoot), (Throwable)e));
        }
        catch (IOException e2) {
            this.feedback.unifiedLogger().userError("Errors searching sdk directory: " + e2.getMessage(), (Throwable)e2);
            this.exampleMapping = new HashMap<String, Multimap<ComponentQuality, IUcExampleResult>>();
            return this.exampleMapping;
        }
        this.exampleMapping = this.exampleMap.values().stream().filter(p -> filterPkgs.isEmpty() || filterPkgs.contains(p.packaged().toLowerCase(Locale.ROOT))).filter(p -> filterQuals.isEmpty() || filterQuals.contains(p.quality().toString().toLowerCase(Locale.ROOT))).collect(Collectors.toMap(IUcExampleResult::packaged, r -> {
            TreeMultimap map = TreeMultimap.create(this::compareQuality, this::compareExampleResult);
            map.put((Object)r.quality(), r);
            return map;
        }, (a, b) -> {
            a.putAll(b);
            return a;
        }, TreeMap::new));
        return this.exampleMapping;
    }

    private int compareQuality(ComponentQuality q1, ComponentQuality q2) {
        if (q1 == null) {
            return -1;
        }
        if (q2 == null) {
            return 1;
        }
        return Integer.compare(q1.ordinal(), q2.ordinal());
    }

    private int compareExampleResult(IUcExampleResult r1, IUcExampleResult r2) {
        if (Objects.equals(r1.getClass(), r2.getClass())) {
            return r1.file().compareTo(r2.file());
        }
        return r1 instanceof UcExampleWorkspaceResult ? -1 : 1;
    }

    public MDescriptor createTemplate(Path templFile, IUcExampleResult example) {
        MDescriptor mdesc = StudioModelFactory.eINSTANCE.createMDescriptor();
        mdesc.getProperties().put((Object)"namespace", (Object)"template.uc");
        mdesc.getProperties().put((Object)"keywords", (Object)CoreTypes.STRING_LIST.stringize(Arrays.asList("universal configurator")));
        mdesc.setDescription(example.description());
        String projectId = this.calculateProjectId(example.path());
        String projFilePath = UcExampleResults.formatPath(templFile.getParent(), example.path());
        IUcFramework pkgFwk = this.calculateSltPackage(templFile);
        String projPkgFilePath = UcExampleResults.formatPath(pkgFwk.directory().toPath(), example.path());
        String sltPkgIds = UcExampleResults.calculatePackageId(pkgFwk);
        List readmeFiles = example.readmeFiles().stream().map(SourceFile::physicalFile).filter(Optional::isPresent).map(Optional::get).map(p -> UcExampleResults.formatPath(templFile.getParent(), p)).collect(Collectors.toList());
        mdesc.getProperties().put((Object)"solutionReferenceId", (Object)projectId);
        mdesc.getProperties().put((Object)"projectFilePaths", (Object)projFilePath);
        mdesc.getProperties().put((Object)"readmeFiles", (Object)CoreTypes.STRING_LIST.stringize(readmeFiles));
        mdesc.getProperties().put((Object)"boardCompatibility", (Object)example.boardCompat());
        mdesc.getProperties().put((Object)"partCompatibility", (Object)example.partCompat());
        mdesc.getProperties().put((Object)"ideCompatibility", (Object)example.ideCompatibility());
        mdesc.getProperties().put((Object)"toolchainCompatibility", (Object)example.toolchainCompat());
        mdesc.getProperties().put((Object)"category", (Object)example.category());
        mdesc.getProperties().put((Object)"quality", (Object)example.quality().name());
        mdesc.getProperties().put((Object)"stockConfigCompatibility", (Object)"com.silabs.ss.framework.project.toolchain.core.default");
        mdesc.getProperties().put((Object)"sltPackageIds", (Object)sltPkgIds);
        mdesc.getProperties().put((Object)"sltPackagePath", (Object)projPkgFilePath);
        mdesc.getProperties().put((Object)"filters", (Object)example.projectFilters());
        return mdesc;
    }

    private static String calculatePackageId(IUcFramework framework) {
        String pkgId = framework.frameworkId().toString();
        pkgId = PACKAGE_VERSION_MAPPING.getOrDefault(pkgId, pkgId).trim();
        return CoreTypes.STRING_TO_STRING_MAP.stringize(Map.of(pkgId, "~" + framework.version().trim()));
    }

    private IUcFramework calculateSltPackage(Path templFile) {
        for (IUcAdditionalFramework extension : this.framework.sdkExtensions().values()) {
            if (!templFile.startsWith(extension.directory().toPath())) continue;
            return extension;
        }
        Iterator iterator = this.framework;
        if (iterator instanceof IUcProjectFramework) {
            IUcProjectFramework pfwk = (IUcProjectFramework)iterator;
            return pfwk.parentFramework();
        }
        return this.framework;
    }

    private static String formatPath(Path templFile, Path filePath) {
        return templFile.relativize(filePath).toString().replace("\\", "/");
    }

    public String calculateProjectId(Path examplePath) {
        return this.sdkRoot.relativize(examplePath).toString().replace("/", ".").replace("\\", ".");
    }

    public IUcExampleResult create(File slcFile, ExecutorService threadPool) {
        if (slcFile.getName().endsWith("slcp")) {
            return UcExampleProjectResult.create(this, slcFile, threadPool);
        }
        if (slcFile.getName().endsWith("slcw")) {
            return UcExampleWorkspaceResult.create(this, slcFile);
        }
        throw new IllegalArgumentException("Unknown file type: " + slcFile.getAbsolutePath());
    }

    private class ExamplesFileVisitor
    implements FileVisitor<Path> {
        private final Set<Path> paths = new LinkedHashSet<Path>();
        private final MultiExceptionContainer.Builder exceptions = MultiExceptionContainer.builder();

        private ExamplesFileVisitor() {
        }

        public Stream<Path> fileStream() {
            return this.paths.stream();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (dir.getFileName().toString().equals(".git")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toString().endsWith(".slcp") || file.toString().endsWith(".slcw")) {
                this.paths.add(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return this.postVisitDirectory(file, exc);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                this.exceptions.add((Throwable)exc);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

