/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.servlet;

import com.silabs.uc.cli.internal.command.exception.JsonSchemaException;
import java.util.Optional;
import org.json.JSONObject;

public final class JsonTypesUtil {
    public static Optional<String> getStringOptional(JSONObject object, String key) throws JsonSchemaException {
        return JsonTypesUtil.getStringInternal(object, key);
    }

    public static String getString(JSONObject object, String key) throws JsonSchemaException {
        return JsonTypesUtil.getStringInternal(object, key).orElseThrow(() -> JsonTypesUtil.missingKey(key));
    }

    public static Optional<Boolean> getBooleanOptional(JSONObject object, String key) throws JsonSchemaException {
        return JsonTypesUtil.getBooleanInternal(object, key);
    }

    public static boolean getBoolean(JSONObject object, String key) throws JsonSchemaException {
        return JsonTypesUtil.getBooleanInternal(object, key).orElseThrow(() -> JsonTypesUtil.missingKey(key));
    }

    public static Optional<Integer> getIntOptional(JSONObject object, String key) throws JsonSchemaException {
        return JsonTypesUtil.getIntInternal(object, key);
    }

    public static int getInt(JSONObject object, String key) throws JsonSchemaException {
        return JsonTypesUtil.getIntInternal(object, key).orElseThrow(() -> JsonTypesUtil.missingKey(key));
    }

    private static JsonSchemaException missingKey(String key) {
        return new JsonSchemaException("Required key " + key + " not part of json request.");
    }

    private static Optional<Integer> getIntInternal(JSONObject object, String key) throws JsonSchemaException {
        if (!object.has(key)) {
            return Optional.empty();
        }
        Object result = object.get(key);
        if (result instanceof Integer) {
            return Optional.of((Integer)result);
        }
        if (result instanceof String) {
            try {
                Integer intResult = Integer.parseInt((String)result);
                return Optional.of(intResult);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new JsonSchemaException("Expected Integer or translateable string but got " + result.getClass().getCanonicalName() + " for " + String.valueOf(result));
    }

    private static Optional<Boolean> getBooleanInternal(JSONObject object, String key) throws JsonSchemaException {
        if (!object.has(key)) {
            return Optional.empty();
        }
        Object result = object.get(key);
        if (result instanceof Boolean) {
            return Optional.of((Boolean)result);
        }
        if (result instanceof String) {
            if ("true".equalsIgnoreCase((String)result)) {
                return Optional.of(Boolean.TRUE);
            }
            if ("false".equalsIgnoreCase((String)result)) {
                return Optional.of(Boolean.FALSE);
            }
        }
        throw new JsonSchemaException("Expected boolean or translateable string but got " + result.getClass().getCanonicalName() + " for " + String.valueOf(result));
    }

    private static Optional<String> getStringInternal(JSONObject object, String key) throws JsonSchemaException {
        if (!object.has(key)) {
            return Optional.empty();
        }
        Object result = object.get(key);
        if (result instanceof String) {
            return Optional.of((String)result);
        }
        throw new JsonSchemaException("Expected String but got " + result.getClass().getCanonicalName() + " for " + String.valueOf(result));
    }
}

