/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.templates.scripting;

import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.Template;
import com.silabs.ss.framework.project.api.templates.scripting.ISLSTemplateModule;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.platform.api.content.board.core.Board;
import com.silabs.ss.platform.api.content.board.core.BoardCompatibility;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.content.part.core.PartCompatibility;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.compatibility.Compatibility;
import com.silabs.ss.platform.api.descriptor.core.manager.IManager;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.scripting.core.BaseSLSManagerModule;
import com.silabs.ss.platform.api.scripting.core.ScriptEngineContext;
import com.silabs.ss.platform.api.sdk.core.SDK;
import com.silabs.ss.platform.api.sdk.core.SDKProperties;
import java.util.ArrayList;
import java.util.Collection;

public class SLSTemplateModule
extends BaseSLSManagerModule<ITemplateDescriptor, ITemplate>
implements ISLSTemplateModule {
    public SLSTemplateModule(ScriptEngineContext context) {
        super((IManager)Template.manager());
    }

    public String getName() {
        return "template";
    }

    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isCompatibleWithBoard(Object template, Object board) {
        if (board == null) {
            return true;
        }
        return BoardCompatibility.from((IDescriptor)this.formatToDescriptor(template)).isCompatibleWith(this.formatDescriptorToString(board));
    }

    @Override
    public boolean isCompatibleWithPart(Object template, Object part) {
        if (part == null) {
            return true;
        }
        return PartCompatibility.from((IDescriptor)this.formatToDescriptor(template)).isCompatibleWith(this.formatDescriptorToString(part));
    }

    @Override
    public boolean isCompatibleWithSDK(Object template, Object sdk) {
        if (sdk == null) {
            return true;
        }
        return Compatibility.fromProperty((IDescriptor)this.formatToDescriptor(template), (PropertyReference)SDKProperties.CONTRIBUTING_SDK, (IRegistry)SDK.manager()).isCompatibleWith(Compatibility.fromGrammarString((IRegistry)SDK.manager(), (String)this.formatDescriptorToString(sdk)));
    }

    @Override
    public boolean isCompatibleWithToolchain(Object template, Object toolchain) {
        if (toolchain == null) {
            return true;
        }
        return Compatibility.fromProperty((IDescriptor)this.formatToDescriptor(template), (PropertyReference)ToolchainProperties.TOOLCHAIN_COMPATIBILITY, (IRegistry)Toolchain.manager()).isCompatibleWith(Compatibility.fromGrammarString((IRegistry)Toolchain.manager(), (String)this.formatDescriptorToString(toolchain)));
    }

    @Override
    public Collection<ITemplateDescriptor> findAllCompatibleTemplates(Object board, Object part, Object sdk, Object toolchain) {
        IDescriptor boardDesc = this.formatToDescriptor((IRegistry)Board.manager(), board);
        IDescriptor partDesc = this.formatToDescriptor((IRegistry)Part.manager(), part);
        IDescriptor sdkDesc = this.formatToDescriptor((IRegistry)SDK.manager(), sdk);
        IDescriptor tcDesc = this.formatToDescriptor((IRegistry)Toolchain.manager(), toolchain);
        ArrayList<ITemplateDescriptor> allowedTemplates = new ArrayList<ITemplateDescriptor>();
        ITemplateDescriptor[] iTemplateDescriptorArray = (ITemplateDescriptor[])this.manager.getAllDescriptors();
        int n = iTemplateDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITemplateDescriptor template = iTemplateDescriptorArray[n2];
            if (this.isCompatibleWithBoard(template, boardDesc) && this.isCompatibleWithPart(template, partDesc) && this.isCompatibleWithSDK(template, sdkDesc) && this.isCompatibleWithToolchain(template, tcDesc)) {
                allowedTemplates.add(template);
            }
            ++n2;
        }
        return allowedTemplates;
    }
}

