/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.model.impl;

import com.silabs.ss.framework.project.api.core.model.IResourceFilterInfo;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MGenericOption;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelPackage;
import com.silabs.ss.framework.project.api.core.model.impl.MEntryToMSettingsSiteMapImpl;
import com.silabs.ss.framework.project.api.core.model.impl.MFolderEntryImpl;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelLoading;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelSwitchRecurser;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MDescribable;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptorProperties;
import com.silabs.ss.platform.api.descriptor.core.model.StudioModelPackage;
import com.silabs.ss.platform.api.descriptor.core.model.impl.StringToStringMapImpl;
import com.silabs.ss.platform.api.descriptor.core.model.util.EcoreIdentityCopier;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

public class MProjectImpl
extends MFolderEntryImpl
implements MProject {
    protected EList<String> sourceFolders;
    protected EList<String> excludedPaths;
    protected static final String OUTPUT_FILE_BASE_EDEFAULT = null;
    protected String outputFileBase = OUTPUT_FILE_BASE_EDEFAULT;
    protected EMap<MEntry, MSettingsSite> entrySettings;
    protected EList<MModule> modules;
    protected static final String PREBUILD_STEP_EDEFAULT = null;
    protected String prebuildStep = PREBUILD_STEP_EDEFAULT;
    protected static final String POSTBUILD_STEP_EDEFAULT = null;
    protected String postbuildStep = POSTBUILD_STEP_EDEFAULT;
    protected EMap<String, String> properties;
    protected static final String PROPERTY_SCOPE_EDEFAULT = "";
    private Map<IPath, List<IResourceFilterInfo>> filterInfos;
    private String propertyScope;
    protected static final String CONTENT_ROOT_EDEFAULT = null;
    protected String contentRoot = CONTENT_ROOT_EDEFAULT;
    protected EList<MConfiguration> configurations;
    protected EList<MProject> projectDefinedModules;

    protected MProjectImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ProjectModelPackage.Literals.MPROJECT;
    }

    @Override
    public String getPdmId() {
        return this.getName();
    }

    @Override
    public void setPdmId(String pdmId) {
        this.setId(pdmId);
        this.setName(pdmId);
    }

    public String getPropertyScope() {
        if (this.propertyScope == null) {
            this.propertyScope = "project";
        }
        return this.propertyScope;
    }

    public void setPropertyScope(String newPropertyScope) {
        String oldPropertyScope = this.propertyScope;
        this.propertyScope = newPropertyScope;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldPropertyScope, (Object)this.propertyScope));
        }
    }

    @Override
    public String getContentRoot() {
        return this.contentRoot;
    }

    @Override
    public void setContentRoot(String newContentRoot) {
        String oldContentRoot = this.contentRoot;
        this.contentRoot = newContentRoot;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 27, (Object)oldContentRoot, (Object)this.contentRoot));
        }
    }

    @Override
    public String getOutputFileBase() {
        return this.outputFileBase;
    }

    @Override
    public void setOutputFileBase(String newOutputFileBase) {
        String oldOutputFileBase = this.outputFileBase;
        this.outputFileBase = newOutputFileBase;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldOutputFileBase, (Object)this.outputFileBase));
        }
    }

    @Override
    public EMap<MEntry, MSettingsSite> getEntrySettings() {
        if (this.entrySettings == null) {
            this.entrySettings = new EcoreEMap(ProjectModelPackage.Literals.MENTRY_TO_MSETTINGS_SITE_MAP, MEntryToMSettingsSiteMapImpl.class, (InternalEObject)this, 21);
        }
        return this.entrySettings;
    }

    @Override
    public EList<MModule> getModules() {
        if (this.modules == null) {
            this.modules = new EObjectContainmentEList(MModule.class, (InternalEObject)this, 22);
        }
        return this.modules;
    }

    @Override
    public String getPrebuildStep() {
        return this.prebuildStep;
    }

    @Override
    public void setPrebuildStep(String newPrebuildStep) {
        String oldPrebuildStep = this.prebuildStep;
        this.prebuildStep = newPrebuildStep;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldPrebuildStep, (Object)this.prebuildStep));
        }
    }

    @Override
    public String getPostbuildStep() {
        return this.postbuildStep;
    }

    @Override
    public void setPostbuildStep(String newPostbuildStep) {
        String oldPostbuildStep = this.postbuildStep;
        this.postbuildStep = newPostbuildStep;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldPostbuildStep, (Object)this.postbuildStep));
        }
    }

    @Override
    public EList<String> getSourceFolders() {
        if (this.sourceFolders == null) {
            this.sourceFolders = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 18);
        }
        return this.sourceFolders;
    }

    @Override
    public EList<String> getExcludedPaths() {
        if (this.excludedPaths == null) {
            this.excludedPaths = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 19);
        }
        return this.excludedPaths;
    }

    @Override
    public EList<MConfiguration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new EObjectContainmentEList(MConfiguration.class, (InternalEObject)this, 28);
        }
        return this.configurations;
    }

    @Override
    public EList<MProject> getProjectDefinedModules() {
        if (this.projectDefinedModules == null) {
            this.projectDefinedModules = new EObjectContainmentEList(MProject.class, (InternalEObject)this, 29);
        }
        return this.projectDefinedModules;
    }

    @Override
    public String registerProjectDefinedModule(String moduleId, MProject moduleModel) {
        if (moduleId == null) {
            throw new IllegalArgumentException("Module id should not be null!");
        }
        if (!moduleId.equals(moduleModel.getName()) && moduleModel.getLabel() != null) {
            moduleModel.setLabel(moduleModel.getName());
        }
        moduleModel.setName(moduleId);
        this.getProjectDefinedModules().add((Object)moduleModel);
        return moduleId;
    }

    public EMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new EcoreEMap(StudioModelPackage.Literals.STRING_TO_STRING_MAP, StringToStringMapImpl.class, (InternalEObject)this, 25);
        }
        return this.properties;
    }

    public java.net.URI getContentRootURI() {
        Object dirContentRoot;
        block6: {
            try {
                dirContentRoot = this.getContentRoot();
                if (dirContentRoot != null) break block6;
                return null;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("could not form content root URI", e);
            }
        }
        if (!((String)dirContentRoot).endsWith("/")) {
            dirContentRoot = (String)dirContentRoot + "/";
        }
        java.net.URI contentRoot = new java.net.URI((String)dirContentRoot);
        if (this.eResource() == null || contentRoot.isAbsolute()) {
            return contentRoot;
        }
        URI eUri = this.eResource().getURI();
        java.net.URI modelRoot = eUri != null ? new java.net.URI(eUri.toString()) : new java.net.URI("./");
        java.net.URI modelBase = modelRoot;
        if (!modelBase.getPath().endsWith("/")) {
            modelBase = URIUtil.append((java.net.URI)modelRoot, (String)"../");
        }
        return URIUtil.append((java.net.URI)modelBase, (String)dirContentRoot);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 21: {
                return ((InternalEList)this.getEntrySettings()).basicRemove((Object)otherEnd, msgs);
            }
            case 22: {
                return ((InternalEList)this.getModules()).basicRemove((Object)otherEnd, msgs);
            }
            case 25: {
                return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
            }
            case 28: {
                return ((InternalEList)this.getConfigurations()).basicRemove((Object)otherEnd, msgs);
            }
            case 29: {
                return ((InternalEList)this.getProjectDefinedModules()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 18: {
                return this.getSourceFolders();
            }
            case 19: {
                return this.getExcludedPaths();
            }
            case 20: {
                return this.getOutputFileBase();
            }
            case 21: {
                if (coreType) {
                    return this.getEntrySettings();
                }
                return this.getEntrySettings().map();
            }
            case 22: {
                return this.getModules();
            }
            case 23: {
                return this.getPrebuildStep();
            }
            case 24: {
                return this.getPostbuildStep();
            }
            case 25: {
                if (coreType) {
                    return this.getProperties();
                }
                return this.getProperties().map();
            }
            case 26: {
                return this.getPropertyScope();
            }
            case 27: {
                return this.getContentRoot();
            }
            case 28: {
                return this.getConfigurations();
            }
            case 29: {
                return this.getProjectDefinedModules();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 18: {
                this.getSourceFolders().clear();
                this.getSourceFolders().addAll((Collection)newValue);
                return;
            }
            case 19: {
                this.getExcludedPaths().clear();
                this.getExcludedPaths().addAll((Collection)newValue);
                return;
            }
            case 20: {
                this.setOutputFileBase((String)newValue);
                return;
            }
            case 21: {
                ((EStructuralFeature.Setting)this.getEntrySettings()).set(newValue);
                return;
            }
            case 22: {
                this.getModules().clear();
                this.getModules().addAll((Collection)newValue);
                return;
            }
            case 23: {
                this.setPrebuildStep((String)newValue);
                return;
            }
            case 24: {
                this.setPostbuildStep((String)newValue);
                return;
            }
            case 25: {
                ((EStructuralFeature.Setting)this.getProperties()).set(newValue);
                return;
            }
            case 26: {
                this.setPropertyScope((String)newValue);
                return;
            }
            case 27: {
                this.setContentRoot((String)newValue);
                return;
            }
            case 28: {
                this.getConfigurations().clear();
                this.getConfigurations().addAll((Collection)newValue);
                return;
            }
            case 29: {
                this.getProjectDefinedModules().clear();
                this.getProjectDefinedModules().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 18: {
                this.getSourceFolders().clear();
                return;
            }
            case 19: {
                this.getExcludedPaths().clear();
                return;
            }
            case 20: {
                this.setOutputFileBase(OUTPUT_FILE_BASE_EDEFAULT);
                return;
            }
            case 21: {
                this.getEntrySettings().clear();
                return;
            }
            case 22: {
                this.getModules().clear();
                return;
            }
            case 23: {
                this.setPrebuildStep(PREBUILD_STEP_EDEFAULT);
                return;
            }
            case 24: {
                this.setPostbuildStep(POSTBUILD_STEP_EDEFAULT);
                return;
            }
            case 25: {
                this.getProperties().clear();
                return;
            }
            case 26: {
                this.setPropertyScope(PROPERTY_SCOPE_EDEFAULT);
                return;
            }
            case 27: {
                this.setContentRoot(CONTENT_ROOT_EDEFAULT);
                return;
            }
            case 28: {
                this.getConfigurations().clear();
                return;
            }
            case 29: {
                this.getProjectDefinedModules().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 18: {
                return this.sourceFolders != null && !this.sourceFolders.isEmpty();
            }
            case 19: {
                return this.excludedPaths != null && !this.excludedPaths.isEmpty();
            }
            case 20: {
                return OUTPUT_FILE_BASE_EDEFAULT == null ? this.outputFileBase != null : !OUTPUT_FILE_BASE_EDEFAULT.equals(this.outputFileBase);
            }
            case 21: {
                return this.entrySettings != null && !this.entrySettings.isEmpty();
            }
            case 22: {
                return this.modules != null && !this.modules.isEmpty();
            }
            case 23: {
                return PREBUILD_STEP_EDEFAULT == null ? this.prebuildStep != null : !PREBUILD_STEP_EDEFAULT.equals(this.prebuildStep);
            }
            case 24: {
                return POSTBUILD_STEP_EDEFAULT == null ? this.postbuildStep != null : !POSTBUILD_STEP_EDEFAULT.equals(this.postbuildStep);
            }
            case 25: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 26: {
                return PROPERTY_SCOPE_EDEFAULT == null ? this.propertyScope != null : !PROPERTY_SCOPE_EDEFAULT.equals(this.propertyScope);
            }
            case 27: {
                return CONTENT_ROOT_EDEFAULT == null ? this.contentRoot != null : !CONTENT_ROOT_EDEFAULT.equals(this.contentRoot);
            }
            case 28: {
                return this.configurations != null && !this.configurations.isEmpty();
            }
            case 29: {
                return this.projectDefinedModules != null && !this.projectDefinedModules.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == MConfigSettings.class) {
            switch (derivedFeatureID) {
                case 18: {
                    return 6;
                }
                case 19: {
                    return 7;
                }
                case 20: {
                    return 8;
                }
                case 21: {
                    return 9;
                }
                case 22: {
                    return 10;
                }
                case 23: {
                    return 11;
                }
                case 24: {
                    return 12;
                }
            }
            return -1;
        }
        if (baseClass == MDescriptorProperties.class) {
            switch (derivedFeatureID) {
                case 25: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == MDescriptor.class) {
            switch (derivedFeatureID) {
                case 26: {
                    return 5;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == MConfigSettings.class) {
            switch (baseFeatureID) {
                case 6: {
                    return 18;
                }
                case 7: {
                    return 19;
                }
                case 8: {
                    return 20;
                }
                case 9: {
                    return 21;
                }
                case 10: {
                    return 22;
                }
                case 11: {
                    return 23;
                }
                case 12: {
                    return 24;
                }
            }
            return -1;
        }
        if (baseClass == MDescriptorProperties.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 25;
                }
            }
            return -1;
        }
        if (baseClass == MDescriptor.class) {
            switch (baseFeatureID) {
                case 5: {
                    return 26;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        try {
            String storeMProjectModel = ProjectModelLoading.storeMProjectModel(this.copy());
            if (storeMProjectModel != null) {
                return storeMProjectModel;
            }
        }
        catch (CoreException coreException) {}
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sourceFolders: ");
        result.append(this.sourceFolders);
        result.append(", excludedPaths: ");
        result.append(this.excludedPaths);
        result.append(", outputFileBase: ");
        result.append(this.outputFileBase);
        result.append(", prebuildStep: ");
        result.append(this.prebuildStep);
        result.append(", postbuildStep: ");
        result.append(this.postbuildStep);
        result.append(", propertyScope: ");
        result.append(this.propertyScope);
        result.append(", contentRoot: ");
        result.append(this.contentRoot);
        result.append(')');
        return result.toString();
    }

    @Override
    public Map<IPath, List<IResourceFilterInfo>> getFilterInfoMap() {
        if (this.filterInfos == null) {
            this.filterInfos = new LinkedHashMap<IPath, List<IResourceFilterInfo>>();
        }
        return this.filterInfos;
    }

    @Override
    public void mergeFrom(MProject project, boolean mergeConfigs) {
        if (mergeConfigs) {
            for (MConfiguration conf : project.getConfigurations()) {
                MConfiguration exist = this.findConfigurationByName(conf.getName());
                if (exist == null) {
                    this.getConfigurations().add((Object)conf);
                    continue;
                }
                this.mergeSettings(exist, conf);
                this.mergeConfigSettings(exist, conf);
            }
        }
        this.mergeFolder(this, project);
        this.mergeSettings(this, project);
        this.mergeConfigSettings(this, project);
    }

    private void mergeConfigSettings(MConfigSettings toConfig, MConfigSettings fromConfig) {
        toConfig.getEntrySettings().putAll(fromConfig.getEntrySettings());
        toConfig.getExcludedPaths().addAll(fromConfig.getExcludedPaths());
        toConfig.getSourceFolders().addAll(fromConfig.getSourceFolders());
    }

    private void mergeSettings(MSettingsSite toConfig, MSettingsSite fromConfig) {
        toConfig.getIncludePaths().addAll(fromConfig.getIncludePaths());
        toConfig.getMacroDefinitions().addAll(fromConfig.getMacroDefinitions());
        toConfig.getLibraryPaths().addAll(fromConfig.getLibraryPaths());
        toConfig.getLibraryFiles().addAll(fromConfig.getLibraryFiles());
        toConfig.getConvertedOptions().addAll(fromConfig.getConvertedOptions());
        toConfig.getToolOptions().addAll(fromConfig.getToolOptions());
    }

    private void mergeFolder(MFolderEntry toEntry, MFolderEntry fromFolder) {
        for (MFileEntry file : fromFolder.getFiles()) {
            String uniq = this.getUniqueName((Collection<? extends MDescribable>)toEntry.getFiles(), file.getName());
            file.setName(uniq);
            toEntry.getFiles().add((Object)file);
        }
        for (MFolderEntry folder : fromFolder.getFolders()) {
            MFolderEntry exist = null;
            for (MFolderEntry ex : toEntry.getFolders()) {
                if (!ex.getName().equals(folder.getName())) continue;
                if (folder instanceof MFolderContent && (!(ex instanceof MFolderContent) || !((MFolderContent)ex).getUri().equals(((MFolderContent)folder).getUri()))) break;
                exist = ex;
                break;
            }
            if (exist == null) {
                String uniq = this.getUniqueName((Collection<? extends MDescribable>)toEntry.getFolders(), folder.getName());
                folder.setName(uniq);
                toEntry.getFolders().add((Object)folder);
            }
            this.mergeFolder(exist, folder);
        }
    }

    private String getUniqueName(Collection<? extends MDescribable> descs, String name) {
        boolean found;
        Object uniq = name;
        int count = 1;
        block0: do {
            found = false;
            for (MDescribable mDescribable : descs) {
                if (!mDescribable.getName().equals(uniq)) continue;
                found = true;
                uniq = name + "_" + ++count;
                continue block0;
            }
        } while (found);
        return uniq;
    }

    @Override
    public MProject copy() {
        EcoreIdentityCopier copier = new EcoreIdentityCopier();
        MProject copy = (MProject)copier.copy((EObject)this);
        copier.copyReferences();
        new ProjectModelSwitchRecurser<Object>(){

            @Override
            public Object caseMSpecificOption(MSpecificOption opt) {
                return this.doCopy((Collection)opt.getGenericMappings());
            }

            @Override
            public Object caseMGenericOption(MGenericOption opt) {
                return this.doCopy((Collection)opt.getSpecificMappings());
            }

            private <T extends EObject> Object doCopy(Collection<T> optList) {
                List copiedOpts = optList.stream().map(EcoreTypeUtils::copy).collect(Collectors.toList());
                optList.clear();
                optList.addAll(copiedOpts);
                return optList;
            }
        }.doSwitch(copy);
        return copy;
    }

    @Override
    public MConfiguration findConfigurationByName(String name) {
        for (MConfiguration c : this.getConfigurations()) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    @Override
    public MConfiguration findConfigurationById(String id) {
        for (MConfiguration mconf : this.getConfigurations()) {
            if (!mconf.getId().equals(id)) continue;
            return mconf;
        }
        return null;
    }

    @Override
    public MConfiguration findConfiguration(IDescriptor desc) {
        MConfiguration mconfig = this.findConfigurationByName(desc.getName());
        if (mconfig != null) {
            return mconfig;
        }
        mconfig = this.findConfigurationById(desc.getName());
        return mconfig;
    }
}

