/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.model.util.manual;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.ProjectModelPackage;
import com.silabs.ss.framework.project.api.core.model.migrate.ProjectFeatureMigrator;
import com.silabs.ss.framework.project.internal.core.model.Activator;
import com.silabs.ss.platform.api.descriptor.core.model.StudioModelPackage;
import com.silabs.ss.platform.api.descriptor.core.model.impl.StringToStringMapImpl;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;

public class ProjectXMLHandler
extends SAXXMLHandler {
    public ProjectXMLHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
        super(xmiResource, helper, options);
    }

    protected EObject createObjectFromFeatureType(EObject peekObject, EStructuralFeature feature) {
        MContent result = null;
        if (peekObject instanceof MFolderEntry && feature == ProjectModelPackage.eINSTANCE.getMFolderEntry_Files()) {
            result = ProjectModelFactory.eINSTANCE.createMFileContent();
        } else if (peekObject instanceof MFolderEntry && feature == ProjectModelPackage.eINSTANCE.getMFolderEntry_Folders() && (this.attribs.getValue("uri") != null || this.attribs.getValue("includeAllFiles") != null || this.attribs.getValue("includeAllFolders") != null)) {
            result = ProjectModelFactory.eINSTANCE.createMFolderContent();
        }
        if (result != null) {
            this.setFeatureValue(peekObject, feature, result);
            this.handleObjectAttribs(result);
            this.processObject(result);
        } else {
            result = super.createObjectFromFeatureType(peekObject, feature);
        }
        return result;
    }

    protected void setAttribValue(EObject object, String name, String value) {
        if ("kitCompatibility".equals(name)) {
            name = "boardCompatibility";
            StringBuilder sb = new StringBuilder();
            String[] stringArray = value.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                if (!TextUtils.isEmpty((String)val)) {
                    String boardId = ProjectFeatureMigrator.instance().migrateBoardId(val);
                    if (!TextUtils.isEmpty((String)boardId)) {
                        sb.append(boardId).append(" ");
                    } else {
                        Activator.reporter.logError("Failed to properly convert kit compatibility " + val + " to board compatibility for file " + this.getLocation());
                    }
                }
                ++n2;
            }
            value = sb.toString().trim();
        }
        super.setAttribValue(object, name, value);
    }

    public void characters(char[] ch, int start, int length) {
        super.characters(ch, start, length);
        if (this.objects.peek() instanceof StringToStringMapImpl) {
            StringToStringMapImpl result = (StringToStringMapImpl)this.objects.peek();
            String text = new String(ch, start, length);
            result.setValue(text);
        }
    }

    protected EStructuralFeature getFeature(EObject object, String prefix, String name, boolean isElement) {
        EReference result = null;
        if (isElement) {
            if ("folder".equals(name)) {
                result = ProjectModelPackage.eINSTANCE.getMFolderEntry_Folders();
            } else if ("file".equals(name)) {
                result = ProjectModelPackage.eINSTANCE.getMFolderEntry_Files();
            } else if ("sourceFolder".equals(name)) {
                result = ProjectModelPackage.eINSTANCE.getMConfigSettings_SourceFolders();
            } else if ("excludedPath".equals(name)) {
                result = ProjectModelPackage.eINSTANCE.getMConfigSettings_ExcludedPaths();
            } else if ("entrySetting".equals(name)) {
                result = ProjectModelPackage.eINSTANCE.getMConfigSettings_EntrySettings();
            } else if ("property".equals(name)) {
                result = StudioModelPackage.eINSTANCE.getMDescriptor_Properties();
            }
        }
        if (result == null) {
            result = super.getFeature(object, prefix, name, isElement);
        }
        return result;
    }

    protected String getXSIType() {
        if ("folder".equals(this.elements.peek()) && this.attribs.getValue("uri") != null) {
            return "folderContent";
        }
        if ("file".equals(this.elements.peek()) && this.attribs.getValue("uri") != null) {
            return "fileContent";
        }
        return super.getXSIType();
    }

    public void error(XMIException e) {
        if (e instanceof FeatureNotFoundException || e instanceof ClassNotFoundException) {
            Activator.reporter.logWarning("Unknown content in *.slsproj file -- please update Simplicity Studio", (Throwable)e);
            super.warning(e);
            return;
        }
        super.error(e);
    }
}

