/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.solution.model.util.manual;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionProject;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutions;
import com.silabs.ss.framework.project.api.core.solution.model.SolutionModelFactory;
import com.silabs.ss.framework.project.api.core.solution.model.util.SolutionModelResourceFactoryImpl;
import com.silabs.ss.framework.project.internal.core.model.Activator;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.descriptor.core.type.TypeReference;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public final class SolutionModelLoading {
    public static final String PROPERTY_SCOPE = "solution";

    private SolutionModelLoading() {
    }

    public static Stream<MSolution> loadFrom(Path file) {
        try {
            return SolutionModelLoading.loadMSolutionsFromFile(file.toFile()).stream();
        }
        catch (Throwable e) {
            Activator.reporter.logError("Failed to load solution from " + String.valueOf(file), e);
            return Stream.empty();
        }
    }

    public static List<MSolution> loadMSolutionsFromFile(File file) throws IOException {
        if (!file.exists()) {
            return Collections.emptyList();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            return SolutionModelLoading.loadMSolution(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<MSolution> loadMSolutionsFromString(String descsStr) throws IOException {
        if (TextUtils.isEmpty((String)descsStr)) {
            return Collections.emptyList();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(descsStr.getBytes(StandardCharsets.UTF_8));){
            return SolutionModelLoading.loadMSolution(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<MSolution> loadMSolution(InputStream stream) throws IOException {
        ArrayList<MSolution> descs = new ArrayList<MSolution>();
        Resource rsrc = new SolutionModelResourceFactoryImpl().createResource(null);
        rsrc.load(stream, null);
        if (!rsrc.getContents().isEmpty()) {
            EObject obj = (EObject)rsrc.getContents().get(0);
            if (obj instanceof MSolutions) {
                EList<MSolution> descList = ((MSolutions)rsrc.getContents().get(0)).getSolutions();
                descs.addAll((Collection<MSolution>)descList);
                descList.clear();
            } else if (obj instanceof MSolution) {
                descs.add((MSolution)rsrc.getContents().get(0));
            }
        }
        SolutionModelLoading.migrateProjects(descs);
        return descs;
    }

    private static void migrateProjects(List<MSolution> descs) {
        for (MSolution solution : descs) {
            List projects = Stream.of("slssolution.projects", "solution.projects", "projects").map(arg_0 -> ((EMap)solution.getProperties()).removeKey(arg_0)).filter(Objects::nonNull).map(arg_0 -> ((TypeReference)CoreTypes.STRING_LIST).convert(arg_0)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            if (projects.isEmpty()) continue;
            Set existingProjects = solution.getProjects().stream().map(MSolutionProject::getName).collect(Collectors.toSet());
            projects.stream().filter(p -> !existingProjects.contains(p)).forEach(p -> {
                MSolutionProject mproj = SolutionModelFactory.eINSTANCE.createMSolutionProject();
                mproj.setName((String)p);
                solution.getProjects().add((Object)mproj);
            });
        }
    }

    public static void saveSolution(MSolution solution, File saveLoc) {
        try {
            Files.createDirectories(saveLoc.toPath().getParent(), new FileAttribute[0]);
            SolutionModelLoading.storeMSolutionsToFile(saveLoc, Arrays.asList(solution));
        }
        catch (IOException e) {
            Activator.reporter.logError("Failed to save solution " + solution.getName(), (Throwable)e);
        }
    }

    public static String storeMSolutionsToString(MSolution ... solutions) throws IOException {
        return SolutionModelLoading.storeMSolutionsToString(Arrays.asList(solutions));
    }

    public static String storeMSolutionsToString(Collection<MSolution> descs) throws IOException {
        String descsStr;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            SolutionModelLoading.storeMSolutions(bos, descs);
            descsStr = new String(bos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return descsStr;
    }

    public static void storeMSolutionsToFile(File file, Collection<MSolution> descs) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            SolutionModelLoading.storeMSolutions(stream, descs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void storeMSolutions(OutputStream stream, Collection<MSolution> descs) throws IOException {
        MSolutions descsOut = SolutionModelFactory.eINSTANCE.createMSolutions();
        descsOut.getSolutions().addAll(descs);
        Resource rsrc = new SolutionModelResourceFactoryImpl().createResource(null);
        rsrc.getContents().add((Object)descsOut);
        rsrc.save(stream, null);
    }
}

