/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.model.options;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.silabs.java.utils.ArrayUtils;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.MGenericOption;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.MToolchainOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMapping;
import com.silabs.ss.framework.project.api.core.model.options.OptionMappingAtom;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.PropertyConversionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class BaseOptionMapping<OutgoingOption extends MConvertedOption>
implements IOptionMapping<OutgoingOption> {
    protected EMappingStatus status;
    protected IProperty incomingOption;
    protected Map<String, List<OptionMappingAtom>> incomingToOutgoingMap;
    protected Object incomingValue;
    private Class<OutgoingOption> outgoingClass;

    public BaseOptionMapping(Class<OutgoingOption> outgoingClass, IProperty incomingOption, Object incomingValue, EMappingStatus status, Map<String, List<OptionMappingAtom>> incomingToOutgoingMap) {
        this.outgoingClass = outgoingClass;
        this.incomingValue = incomingValue;
        this.status = status;
        if (incomingOption == null) {
            throw new IllegalArgumentException();
        }
        if (incomingOption.getParent() == null) {
            throw new IllegalArgumentException("option must live in a parent (tool)");
        }
        this.incomingOption = incomingOption;
        this.incomingToOutgoingMap = incomingToOutgoingMap;
    }

    @Override
    public IProperty getIncomingOption() {
        return this.incomingOption;
    }

    @Override
    public IProperty[] getOutgoingOptions() {
        HashSet<IProperty> outOpts = new HashSet<IProperty>();
        for (List<OptionMappingAtom> outList : this.incomingToOutgoingMap.values()) {
            for (OptionMappingAtom out : outList) {
                outOpts.add(out.getOutgoingOption());
            }
        }
        return outOpts.toArray(new IProperty[outOpts.size()]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [incomingOption=" + String.valueOf(this.incomingOption) + ", incomingToOutgoingMap=" + String.valueOf(this.incomingToOutgoingMap) + "]";
    }

    @Override
    public OutgoingOption[] mapToOutgoing(MSpecificOption specific) {
        Object value = specific.getValue();
        if (this.incomingValue != null && !this.incomingValue.equals(value)) {
            return null;
        }
        String valueStr = PropertyConversionUtils.stringizeValue((IProperty)this.incomingOption, (Object)value);
        MConvertedOption[] outgoing = (MConvertedOption[])Stream.of("<<any value>>", valueStr).map(this.incomingToOutgoingMap::get).filter(Objects::nonNull).flatMap(Collection::stream).map(atom -> this.createAndSetOutgoing(specific, value, (OptionMappingAtom)atom)).toArray(ArrayUtils.toArray(this.outgoingClass));
        specific.setMappingStatus(this.status);
        return outgoing.length == 0 ? null : outgoing;
    }

    private OutgoingOption createAndSetOutgoing(MSpecificOption specific, Object value, OptionMappingAtom atom) {
        OutgoingOption out = this.createOutgoingOption(atom.getOutgoingOption(), specific);
        out.setValue(atom.computeOutgoingValue(out.getValue(), this.incomingOption, value));
        return out;
    }

    protected abstract OutgoingOption createOutgoingOption(IProperty var1, MSpecificOption var2);

    @Override
    public MSpecificOption mapToIncoming(OutgoingOption[] outgoneOptions) {
        MSpecificOption specific = ProjectModelFactory.eINSTANCE.createMSpecificOption();
        specific.setMappingStatus(this.status);
        Multimap outMap = (Multimap)Stream.of(outgoneOptions).collect(Multimaps.toMultimap(MToolchainOption::getOptionId, o -> o, LinkedHashMultimap::create));
        ArrayList<MGenericOption> anyValueOptionList = new ArrayList<MGenericOption>();
        MSpecificOption anyValueSpecific = null;
        for (Map.Entry<String, List<OptionMappingAtom>> ent : this.incomingToOutgoingMap.entrySet()) {
            specific.setValue(null);
            for (MConvertedOption out2 : outMap.values()) {
                if (!(out2 instanceof MGenericOption)) continue;
                ((MGenericOption)out2).getSpecificMappings().clear();
            }
            boolean allMatch = true;
            boolean anyValue = false;
            for (OptionMappingAtom atom : ent.getValue()) {
                IProperty gen = atom.getOutgoingOption();
                Collection outSet = outMap.get((Object)gen.getId());
                if (outSet.isEmpty()) {
                    allMatch = false;
                    continue;
                }
                boolean anyMatched = false;
                for (MConvertedOption out3 : outSet) {
                    Object incoming = atom.computeIncomingValue(out3.getValue(), this.incomingOption);
                    if (incoming == null) continue;
                    anyMatched = true;
                    if (out3 instanceof MGenericOption) {
                        ((MGenericOption)out3).getSpecificMappings().add((Object)specific);
                        if (anyValueSpecific == null) {
                            anyValueOptionList.add((MGenericOption)out3);
                        }
                    }
                    anyValue = true;
                    if (this.incomingValue != null && ent.getKey() != "<<any value>>") break;
                    if (incoming != "<<any value>>") {
                        specific.updateFrom(this.incomingOption, incoming);
                        break;
                    }
                    if (specific.getValue() != null || !this.incomingOption.getType().isCompatibleWith(out3.getValue())) break;
                    Object newVal = ent.getKey() != "<<any value>>" ? ent.getKey() : out3.getValue();
                    specific.updateFrom(this.incomingOption, newVal);
                    break;
                }
                if (anyMatched) continue;
                allMatch = false;
            }
            if (allMatch || anyValue) {
                if (this.incomingValue != null) {
                    specific.updateFrom(this.incomingOption, this.incomingValue);
                } else if (ent.getKey() != "<<any value>>") {
                    specific.updateFrom(this.incomingOption, PropertyConversionUtils.createValue((IProperty)this.incomingOption, (String)ent.getKey()));
                }
            }
            if (allMatch && anyValue) {
                return specific;
            }
            if (!anyValue || anyValueSpecific != null) continue;
            anyValueSpecific = (MSpecificOption)EcoreUtil.copy((EObject)specific);
        }
        if (anyValueSpecific != null) {
            MSpecificOption finalSpecific = anyValueSpecific;
            anyValueOptionList.forEach(out -> {
                boolean bl = out.getSpecificMappings().add((Object)finalSpecific);
            });
            return anyValueSpecific;
        }
        return null;
    }
}

