/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti;

import com.silabs.pti.Main;
import com.silabs.pti.adapter.AdapterPort;
import com.silabs.pti.adapter.IConnectivityLogger;
import com.silabs.pti.filter.CliDebugMessageFilter;
import com.silabs.pti.format.FileFormat;
import com.silabs.pti.log.PtiSeverity;
import com.silabs.pti.util.MiscUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class CommandLine
implements IConnectivityLogger {
    private static final String DISCOVER = "-discover";
    private static final String IP = "-ip=";
    private static final String OUT = "-out=";
    private static final String TIME_LIMIT = "-time=";
    private static final String ADMIN = "-admin";
    private static final String SERIAL0 = "-serial0";
    private static final String SERIAL1 = "-serial1";
    private static final String FORMAT = "-format=";
    private static final String DELAY = "-delay=";
    private static final String INTERACTIVE = "-i";
    private static final String VERSION = "-v";
    private static final String SN = "-sn=";
    private static final String DRIFT_CORRECTION = "-driftCorrection=";
    private static final String DRIFT_CORRECTION_THRESHOLD = "-driftCorrectionThreshold=";
    private static final String ZERO_TIME_THRESHOLD = "-zeroTimeThreshold=";
    private static final String DISCRETE_NODE_CAPTURE = "-discreteNodeCapture";
    private static final String TEST_PORT = "-testPort=";
    private static final String FILTER = "-filter=";
    private static final String FILTER_OR = "-orFilter=";
    private static final String FILTER_AND = "-andFilter=";
    private List<String> hostnames = new ArrayList<String>();
    private String output = null;
    private FileFormat fileFormat = FileFormat.RAW;
    private AdapterPort port = AdapterPort.DEBUG;
    private final List<String> commands = new ArrayList<String>();
    private int timeLimitMs = Integer.MIN_VALUE;
    private int delayMs = 2000;
    private boolean interactive = false;
    private boolean discovery = false;
    protected String[] params = new String[5];
    private boolean driftCorrection = true;
    private int driftCorrectionThreshold = 5000000;
    private int zeroTimeThreshold = 2000000;
    private boolean discreteNodeCapture = false;
    private List<Integer> testPort = new ArrayList<Integer>();
    private boolean testMode = false;
    private CliDebugMessageFilter filter = null;
    private boolean shouldExit = false;
    private int exitCode = -1;

    public CommandLine(String[] args) {
        for (String arg : args) {
            if ("-?".equals(arg) || "--?".equals(arg) || "-help".equals(arg) || "--help".equals(arg)) {
                this.usage(0);
                return;
            }
            if (arg.startsWith(IP)) {
                String ipField = arg.substring(IP.length());
                List<String> ipAddresses = this.getIpAddresses(ipField);
                if (ipAddresses.size() > 0) {
                    this.hostnames = ipAddresses;
                    continue;
                }
                this.hostnames = new ArrayList<String>(Arrays.asList(ipField.replaceAll(" ", "").split(",")));
                continue;
            }
            if (arg.startsWith(SN)) {
                this.hostnames.add("127.0.0.1");
                continue;
            }
            if (arg.startsWith(OUT)) {
                this.output = arg.substring(OUT.length());
                continue;
            }
            if (arg.startsWith(TIME_LIMIT)) {
                try {
                    this.timeLimitMs = MiscUtil.parseInt(arg.substring(TIME_LIMIT.length()));
                    continue;
                }
                catch (NumberFormatException pe) {
                    this.usage(1);
                    return;
                }
            }
            if (arg.startsWith(DELAY)) {
                try {
                    this.delayMs = MiscUtil.parseInt(arg.substring(DELAY.length()));
                    continue;
                }
                catch (NumberFormatException pe) {
                    this.usage(1);
                    return;
                }
            }
            if (arg.startsWith(ADMIN)) {
                this.port = AdapterPort.ADMIN;
                continue;
            }
            if (arg.startsWith(SERIAL0)) {
                this.port = AdapterPort.SERIAL0;
                continue;
            }
            if (arg.startsWith(SERIAL1)) {
                this.port = AdapterPort.SERIAL1;
                continue;
            }
            if (arg.startsWith(FORMAT)) {
                String fmt = arg.substring(FORMAT.length());
                try {
                    this.fileFormat = FileFormat.valueOf(fmt.toUpperCase());
                    if (this.fileFormat != null) continue;
                    throw new Exception();
                }
                catch (Exception e) {
                    System.err.println("Invalid file format: " + fmt);
                    this.usage(1);
                    return;
                }
            }
            if (arg.equals(INTERACTIVE)) {
                this.interactive = true;
                continue;
            }
            if (arg.equals(VERSION)) {
                this.printVersionAndExit();
                continue;
            }
            if (arg.equals(DISCOVER)) {
                this.discovery = true;
                continue;
            }
            if (arg.startsWith(DRIFT_CORRECTION)) {
                this.driftCorrection = arg.substring(DRIFT_CORRECTION.length()).toLowerCase().indexOf("enable") >= 0;
                continue;
            }
            if (arg.startsWith(DRIFT_CORRECTION_THRESHOLD)) {
                try {
                    this.driftCorrectionThreshold = MiscUtil.parseInt(arg.substring(DRIFT_CORRECTION_THRESHOLD.length()));
                    continue;
                }
                catch (NumberFormatException pe) {
                    this.usage(1);
                    return;
                }
            }
            if (arg.startsWith(ZERO_TIME_THRESHOLD)) {
                try {
                    this.zeroTimeThreshold = MiscUtil.parseInt(arg.substring(ZERO_TIME_THRESHOLD.length()));
                    continue;
                }
                catch (NumberFormatException pe) {
                    this.usage(1);
                    return;
                }
            }
            if (arg.startsWith(DISCRETE_NODE_CAPTURE)) {
                this.discreteNodeCapture = true;
                continue;
            }
            if (arg.startsWith(TEST_PORT)) {
                this.testMode = true;
                this.port = AdapterPort.TEST;
                try {
                    String argStr = arg.substring(TEST_PORT.length());
                    String[] ports = argStr.replaceAll(" ", "").split(",");
                    this.testPort = Arrays.asList(ports).stream().map(x -> Integer.parseInt(x)).collect(Collectors.toList());
                }
                catch (Exception e) {
                    this.usage(1);
                }
                continue;
            }
            if (arg.startsWith(FILTER)) {
                try {
                    if (this.filter != null) {
                        throw new ParseException("Only one -filter= flag is allowed. Specify -andFilter= or -orFilter= for further expressions.", 0);
                    }
                    this.filter = new CliDebugMessageFilter(arg.substring(FILTER.length()));
                    continue;
                }
                catch (ParseException pe) {
                    System.err.println("Filter format error: " + pe.getMessage());
                    this.usage(1);
                    return;
                }
            }
            if (arg.startsWith(FILTER_AND)) {
                try {
                    if (this.filter == null) {
                        throw new ParseException("-andFilter= is allowed only after -filter=", 0);
                    }
                    this.filter.andFilter(arg.substring(FILTER_AND.length()));
                    continue;
                }
                catch (ParseException pe) {
                    System.err.println("Filter format error: " + pe.getMessage());
                    this.usage(1);
                    return;
                }
            }
            if (arg.startsWith(FILTER_OR)) {
                try {
                    if (this.filter == null) {
                        throw new ParseException("-orFilter= is allowed only after -filter=", 0);
                    }
                    this.filter.orFilter(arg.substring(FILTER_OR.length()));
                    continue;
                }
                catch (ParseException pe) {
                    System.err.println("Filter format error: " + pe.getMessage());
                    this.usage(1);
                    return;
                }
            }
            if (this.port == AdapterPort.DEBUG) continue;
            this.commands.add(arg);
        }
        if (!(this.interactive || this.discovery || this.testMode || this.testPort.size() < 0 || this.hostnames.size() != 0)) {
            this.usage(1);
        }
    }

    @Override
    public void log(PtiSeverity severity, String message, Throwable throwable) {
        System.out.println(severity.name() + ": " + message);
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    public boolean shouldExit() {
        return this.shouldExit;
    }

    public int exitCode() {
        return this.exitCode;
    }

    public CliDebugMessageFilter filter() {
        return this.filter;
    }

    @Override
    public int bpsRecordPeriodMs() {
        return 1000;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private List<String> getIpAddresses(String path) {
        ArrayList<String> ips = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim().replace("\n", "").replace("\r", "")).startsWith("#") || line.isEmpty()) {
                    line = reader.readLine();
                    continue;
                }
                ips.add(line.trim());
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ips;
    }

    public static String getVersionString() throws Exception {
        String date = "unknown";
        String hash = "unknown";
        String version = "unknown";
        StringBuilder versionString = new StringBuilder();
        URL u = CommandLine.class.getClassLoader().getResource("build_pti.stamp");
        if (u != null) {
            Properties p = new Properties();
            try {
                try (InputStream is = u.openStream();){
                    p.load(is);
                }
                date = p.getProperty("date");
                hash = p.getProperty("hash");
                version = p.getProperty("version");
            }
            catch (Exception e) {
                throw new Exception("Error reading build information.");
            }
        }
        versionString.append("Library information:");
        versionString.append("\n  - version: " + version);
        versionString.append("\n  - date: " + date);
        versionString.append("\n  - hash: " + hash + "\n");
        return versionString.toString();
    }

    private void printVersionAndExit() {
        try {
            System.out.println(CommandLine.getVersionString());
        }
        catch (Exception e) {
            System.err.println("Error reading build information.");
        }
        System.exit(0);
    }

    private String filename() {
        try {
            URL location = Main.class.getProtectionDomain().getCodeSource().getLocation();
            String file = location.getFile();
            file = file.substring(0, file.lastIndexOf(33));
            String[] split = file.split("[//\\\\]");
            return split[split.length - 1];
        }
        catch (Exception e) {
            return "";
        }
    }

    public void usage(int returnedExitCode) {
        String filename = this.filename();
        System.out.println("Usage: java -jar " + filename + " [ARGUMENTS] [COMMANDS]");
        System.out.println("\nMandatory arguments:\n");
        System.out.println("  -ip=<HOSTNAMES> - specify adapter names or IP addresses to connect to (may be ommited in case of -discover).");
        System.out.println("\nOptional arguments:\n");
        System.out.println("  -i - drop into interactive mode after connecting to adapter. Type 'help' once in interactive mode.");
        System.out.println("  -time=<TIME_IN_MS> - how long to capture, before connection is closed and program shuts down. Default is 1 year.");
        System.out.println("  -delay=<TIME_IN_MS> - how much delay is put after each command when running commands over admin port. Default is 2 seconds.");
        System.out.println("  -out=<FILENAME> - specify filename where to capture to.");
        System.out.println("  -admin - connect to admin port and execute COMMANDS one after another");
        System.out.println("  -serial0 - connect to serial0 port and execute COMMANDS one after another");
        System.out.println("  -serial1 - connect to serial1 port and execute COMMANDS one after another");
        System.out.println("  -format=[" + FileFormat.displayOptionsAsString() + "] - specify a format for output.");
        System.out.println("  -filter=FILTER - apply FILTER to the debug message capturing.");
        System.out.println("  -andFilter=FILTER - add FILTER to the capturing with AND. May specify multiple ones, but only after -filter, and they are right-to-left associative.");
        System.out.println("  -orFilter=FILTER - add FILTER to the capturing with OR. May specify multiple ones, but only after -filter, and they are right-to-left associative.");
        System.out.println("  -v - print version and exit.");
        System.out.println("  -discover - run UDP discovery and print results.");
        System.out.println("  -driftCorrection=[enable, disable] - perform drift time correction for incoming packets. Default is enabled.");
        System.out.println("  -driftCorrectionThreshold= - drift time correction threshold (micro-sec).");
        System.out.println("  -zeroTimeThreshold= - zero time threshold (micro-sec).");
        System.out.println("  -discreteNodeCapture - each node stream gets its own log file. Each filename is \"-out\" option combined with \"_$ip\" suffix. Time Sync is disabled. ");
        System.out.println("  -properties=<FILE> - specify path to file, where each line in file has a single entry in format of argument=value. On Windows, path separators need to be escaped.");
        System.out.println("\nFile formats:\n");
        for (FileFormat ff : FileFormat.values()) {
            System.out.println("  " + ff.name().toLowerCase() + " - " + ff.format().description());
        }
        System.out.println("\nFiltering expressions:\n");
        System.out.println(CliDebugMessageFilter.helpText());
        System.out.println("\nExamples:\n");
        System.out.println("  'java -jar " + filename + " -ip=10.4.186.138'                                                     => capture from given device and print raw events to stdout.");
        System.out.println("  'java -jar " + filename + " -ip=10.4.186.138,10.4.186.139'                                        => capture from given devices and print raw events to stdout.");
        System.out.println("  'java -jar " + filename + " -ip=10.4.186.138,10.4.186.139 -discreteNodeCapture -out=capture.log'  => capture from given devices and stream events are captured in");
        System.out.println("                                                                                                     capture_10.4.186.138.log, capture_10.4.186.139.log.");
        System.out.println("  'java -jar " + filename + " -ip=10.4.186.138 -admin discovery'                                    => connect to admin port and print discovery information.");
        System.out.println("  'java -jar " + filename + " -ip=10.4.186.138 -format=log -time=5000 -out=capture.log'             => capture for 5 seconds into capture.log, using network analyzer format.");
        this.shouldExit = true;
        this.exitCode = returnedExitCode;
    }

    public boolean hasTimeLimit() {
        return this.timeLimitMs != Integer.MIN_VALUE;
    }

    public int timeLimitMs() {
        return this.timeLimitMs;
    }

    public int delayMs() {
        return this.delayMs;
    }

    public String[] hostnames() {
        return this.hostnames.toArray(new String[0]);
    }

    public String output() {
        return this.output;
    }

    public AdapterPort port() {
        return this.port;
    }

    public List<String> commands() {
        return this.commands;
    }

    public FileFormat fileFormat() {
        return this.fileFormat;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean isDiscovery() {
        return this.discovery;
    }

    public boolean driftCorrection() {
        return this.driftCorrection;
    }

    public int driftCorrectionThreshold() {
        return this.driftCorrectionThreshold;
    }

    public int zeroTimeThreshold() {
        return this.zeroTimeThreshold;
    }

    public boolean discreteNodeCapture() {
        return this.discreteNodeCapture;
    }

    public List<Integer> testPort() {
        return this.testPort;
    }

    public boolean testMode() {
        return this.testMode;
    }
}

