/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti;

import com.silabs.pti.CommandLine;
import com.silabs.pti.Interactive;
import com.silabs.pti.OutputMap;
import com.silabs.pti.adapter.Adapter;
import com.silabs.pti.adapter.AdapterPort;
import com.silabs.pti.adapter.AdapterSocketConnector;
import com.silabs.pti.adapter.AsciiFramer;
import com.silabs.pti.adapter.CharacterCollector;
import com.silabs.pti.adapter.DebugChannelFramer;
import com.silabs.pti.adapter.IConnection;
import com.silabs.pti.adapter.TimeSync;
import com.silabs.pti.adapter.TimeSynchronizer;
import com.silabs.pti.adapter.UnframedConnectionListener;
import com.silabs.pti.debugchannel.DebugMessageConnectionListener;
import com.silabs.pti.debugchannel.TextConnectionListener;
import com.silabs.pti.discovery.DiscoveryUtil;
import com.silabs.pti.discovery.PrintingDiscoveryListener;
import com.silabs.pti.extcap.Extcap;
import com.silabs.pti.format.IDebugChannelExportFormat;
import com.silabs.pti.format.IDebugChannelExportOutput;
import com.silabs.pti.log.PtiLog;
import com.silabs.pti.util.LineTerminator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;

public class Main {
    private static final int ADMIN_PORT_OFFSET = 2;
    private static final int DEBUG_PORT_OFFSET = 5;
    public static final String PROPERTIES = "-properties=";
    private final AdapterSocketConnector adapterConnector;
    private final TimeSynchronizer timeSync;
    private final CommandLine cli;

    public static void main(String[] args) {
        if (args.length > 0 && "extcap".equals(args[0])) {
            int errorCode = Extcap.run(args);
            System.exit(errorCode);
        } else {
            Main m = new Main(args);
            if (m.cli.shouldExit()) {
                System.exit(m.cli().exitCode());
            }
            int code = m.run();
            m.closeConnections();
            System.exit(code);
        }
    }

    public Main(String[] args) {
        int propertiesIndex = this.getPropertiesArgIndex(args);
        if (propertiesIndex >= 0) {
            String[] argsFromProps = this.convertPropsToArgs(args, propertiesIndex);
            this.cli = new CommandLine(argsFromProps);
        } else {
            this.cli = new CommandLine(args);
        }
        this.timeSync = new TimeSynchronizer(TimeSynchronizer.DEFAULT_PC_TIME_SUPPLIER, this.cli.driftCorrection(), this.cli.driftCorrectionThreshold(), this.cli.zeroTimeThreshold());
        this.adapterConnector = new AdapterSocketConnector();
    }

    private int getPropertiesArgIndex(String[] args) {
        if (args != null && args.length > 0) {
            for (int index = 0; index < args.length; ++index) {
                if (!args[index].startsWith(PROPERTIES)) continue;
                return index;
            }
        }
        return -1;
    }

    public CommandLine cli() {
        return this.cli;
    }

    public int run() {
        try {
            if (this.cli.isInteractive()) {
                return Interactive.runInteractive(this.cli, this.timeSync);
            }
            if (this.cli.isDiscovery()) {
                return DiscoveryUtil.runDiscovery(new PrintingDiscoveryListener());
            }
            switch (this.cli.port()) {
                case TEST: 
                case DEBUG: {
                    return this.runCapture(this.cli.fileFormat().format(), this.timeSync);
                }
                case ADMIN: 
                case SERIAL0: 
                case SERIAL1: {
                    return this.runCommandSequence();
                }
            }
            PtiLog.error("Unknown port: " + this.cli.port());
            return 1;
        }
        catch (IOException ioe) {
            PtiLog.error("Failed to communicate to adapters: " + String.join((CharSequence)", ", this.cli.hostnames()), ioe);
            return 1;
        }
    }

    private <T> int runCapture(IDebugChannelExportFormat<T> format, TimeSynchronizer timeSynchronizer) throws IOException {
        String outputFilename = this.cli.output();
        UnframedConnectionListener dl = null;
        HashMap<String, List<IConnection>> connections = new HashMap<String, List<IConnection>>();
        OutputMap<T> output = null;
        if (!this.cli.fileFormat().format().isUsingDebugMessages()) {
            if (outputFilename == null) {
                throw new IOException("Need to specify a file with DUMP file format.");
            }
            dl = new UnframedConnectionListener(new File(outputFilename), this.cli.fileFormat().format());
            for (String host : this.cli.hostnames()) {
                IConnection c = this.adapterConnector.createConnection(host, AdapterPort.DEBUG.defaultPort(), this.cli);
                c.addCharacterListener(dl);
                c.connect();
            }
        } else {
            output = this.configOutputFiles(format, outputFilename);
            String timeServer = null;
            ArrayList<IConnection> adminConnections = new ArrayList<IConnection>();
            if (this.cli.testMode()) {
                for (Integer port : this.cli.testPort()) {
                    String originator = "localhost:" + port;
                    ArrayList<IConnection> debugConnections = new ArrayList<IConnection>();
                    connections.put(originator, debugConnections);
                    IConnection testPortConnection = this.adapterConnector.createConnection("localhost", port, this.cli);
                    AsciiFramer asciiFramer = new AsciiFramer();
                    testPortConnection.connect();
                    testPortConnection.setFramers(asciiFramer, asciiFramer);
                    testPortConnection.addConnectionListener(new TextConnectionListener(originator, output));
                    debugConnections.add(testPortConnection);
                }
            } else {
                for (int i = 0; i < this.cli.hostnames().length; ++i) {
                    String ip = this.cli.hostnames()[i];
                    ArrayList<IConnection> debugConnections = new ArrayList<IConnection>();
                    connections.put(ip, debugConnections);
                    AddressAndPort addrPort = this.parseIpAddrAndPort(ip, AdapterPort.DEBUG.defaultPort(), 5);
                    IConnection debug = this.adapterConnector.createConnection(addrPort.getAddress(), addrPort.getPort(), this.cli);
                    DebugChannelFramer debugChannelFramer = new DebugChannelFramer(true);
                    debug.setFramers(debugChannelFramer, debugChannelFramer);
                    DebugMessageConnectionListener dml = new DebugMessageConnectionListener(this.cli.fileFormat().format(), ip, output, timeSynchronizer);
                    if (this.cli.filter() != null) {
                        dml.setFilter(this.cli.filter());
                    }
                    debug.addConnectionListener(dml);
                    debug.connect();
                    debugConnections.add(debug);
                    if (!this.cli.testMode() && !this.cli.discreteNodeCapture() && this.cli.hostnames().length > 1) {
                        addrPort = this.parseIpAddrAndPort(ip, AdapterPort.ADMIN.defaultPort(), 2);
                        IConnection admin = this.adapterConnector.createConnection(addrPort.getAddress(), addrPort.getPort(), this.cli);
                        AsciiFramer asciiFramer = new AsciiFramer();
                        admin.setFramers(asciiFramer, asciiFramer);
                        admin.connect();
                        TimeSync.synchronizeTime(admin, debug.isConnected(), ip, ".*switched to mode: server.*", true, timeServer != null, timeServer);
                        adminConnections.add(admin);
                    }
                    if (i != 0) continue;
                    timeServer = this.cli.hostnames()[0];
                }
            }
            for (IConnection c : adminConnections) {
                c.close();
            }
            adminConnections.clear();
            adminConnections = null;
        }
        try {
            if (this.cli.hasTimeLimit()) {
                Thread.sleep(this.cli.timeLimitMs());
            } else {
                Thread.sleep(1471228928L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dl != null) {
            dl.close();
        }
        if (output != null) {
            output.closeAndClear();
        }
        this.closeConnections(connections);
        return 0;
    }

    private AddressAndPort parseIpAddrAndPort(String ip, int defaultPort, int basePortOffset) {
        AddressAndPort addrAndPort = new AddressAndPort(ip, defaultPort);
        if (ip != null && !ip.isBlank() && ip.indexOf(":") > 0) {
            int index = ip.indexOf(":");
            String hostName = ip.substring(0, index);
            Integer basePort = Integer.valueOf(ip.substring(index + 1));
            addrAndPort = new AddressAndPort(hostName, basePort + basePortOffset);
        }
        return addrAndPort;
    }

    private <T> OutputMap<T> configOutputFiles(IDebugChannelExportFormat<T> format, String outFilename) throws IOException {
        OutputMap<T> output = new OutputMap<T>();
        if (outFilename != null && !outFilename.isEmpty()) {
            if (this.cli.testMode()) {
                for (Integer port : this.cli.testPort()) {
                    String f = this.makeCaptureFilenames(outFilename, port.toString());
                    output.put("localhost:" + port, format.createOutput(new File(f), false));
                }
            } else if (this.cli.discreteNodeCapture()) {
                for (String ip : this.cli.hostnames()) {
                    String f = this.makeCaptureFilenames(outFilename, ip.toString());
                    output.put(ip, format.createOutput(new File(f), false));
                }
            } else {
                IDebugChannelExportOutput<T> printStream = format.createOutput(new File(this.cli.output()), false);
                for (String ip : this.cli.hostnames()) {
                    output.put(ip, printStream);
                }
            }
        } else {
            for (String name : this.cli.hostnames()) {
                output.put(name, format.createStdoutOutput());
            }
        }
        return output;
    }

    public String makeCaptureFilenames(String filename, String filename_suffix) {
        Object out = filename.substring(0, filename.lastIndexOf("."));
        out = (String)out + "_";
        out = (String)out + filename_suffix.replace(':', '_');
        out = (String)out + filename.substring(filename.lastIndexOf("."));
        return out;
    }

    public void closeConnections() {
        this.closeConnections(null);
    }

    public void closeConnections(HashMap<String, List<IConnection>> connections) {
        if (connections != null) {
            for (String ip : connections.keySet()) {
                List<IConnection> list = connections.get(ip);
                for (IConnection c : list) {
                    c.close();
                }
                list.clear();
            }
        }
        if (this.adapterConnector != null) {
            this.adapterConnector.dispose();
        }
    }

    private int runCommandSequence() throws IOException {
        String hostname = this.cli.hostnames()[0];
        IConnection c = Adapter.createConnection(hostname, this.cli.port().defaultPort(), this.cli);
        c.connect();
        CharacterCollector cc = new CharacterCollector();
        c.addCharacterListener(cc);
        for (String cmd : this.cli.commands()) {
            c.send(cmd + LineTerminator.CRLF);
            System.out.println(cmd);
            try {
                Thread.sleep(this.cli.delayMs());
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println(cc.textAndClean());
        }
        c.close();
        return 0;
    }

    private String[] convertPropsToArgs(String[] progArgs, int propertiesIndex) {
        ArrayList args = new ArrayList();
        if (progArgs.length > 0 && propertiesIndex >= 0) {
            String propsFile = progArgs[propertiesIndex].substring(PROPERTIES.length()).trim();
            if (propsFile.startsWith("\"")) {
                propsFile = propsFile.substring(1);
            }
            if (propsFile.endsWith("\"")) {
                propsFile = propsFile.substring(0, propsFile.length() - 1);
            }
            propsFile = propsFile.replaceFirst("^~", System.getProperty("user.home"));
            Properties props = new Properties();
            try (BufferedReader propsReader = new BufferedReader(new FileReader(new File(propsFile)));){
                props.load(propsReader);
                props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (v instanceof String && !((String)v).isBlank()) {
                        args.add(k.toString().trim() + "=" + v.toString().trim());
                    } else {
                        args.add(k.toString());
                    }
                }));
            }
            catch (IOException e2) {
                e2.printStackTrace(System.out);
            }
        }
        if (progArgs.length > 0) {
            Arrays.stream(progArgs).forEach(e -> {
                if (e.startsWith(PROPERTIES)) {
                    return;
                }
                args.add(e);
            });
        }
        return args.toArray(new String[0]);
    }

    private class AddressAndPort {
        private final String addr;
        private final int port;

        public AddressAndPort(String addr, int port) {
            this.addr = addr;
            this.port = port;
        }

        public String getAddress() {
            return this.addr;
        }

        public int getPort() {
            return this.port;
        }
    }
}

