/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.Adapter;
import com.silabs.pti.adapter.AdapterPort;
import com.silabs.pti.adapter.ConnectionType;
import com.silabs.pti.adapter.DebugChannelFramer;
import com.silabs.pti.adapter.IBackchannel;
import com.silabs.pti.adapter.IBackchannelPortMapper;
import com.silabs.pti.adapter.IConnection;
import com.silabs.pti.adapter.IConnectionEnabler;
import com.silabs.pti.adapter.IConnectionProblemListener;
import com.silabs.pti.adapter.IConnectivityLogger;
import com.silabs.pti.adapter.IDebugConnection;
import com.silabs.pti.adapter.IDebugMessageListener;
import com.silabs.pti.debugchannel.DebugMessageCollector;
import com.silabs.pti.log.IPtiLogger;
import com.silabs.pti.log.PtiSeverity;
import java.io.IOException;

public class Backchannel
implements IBackchannel {
    private final IConnection[] connections = new IConnection[AdapterPort.values().length];
    private final IBackchannelPortMapper portMapper;
    private final IConnectionEnabler enabler;
    private final IPtiLogger logger;
    private final DebugMessageCollector debugMessageCollector;

    Backchannel(String originatorId, String host, IBackchannelPortMapper portmapper, IConnectionEnabler enabler, IConnectivityLogger logger, ConnectionType debugConnectionType) {
        this.portMapper = portmapper;
        this.enabler = enabler;
        this.logger = logger;
        this.debugMessageCollector = new DebugMessageCollector(originatorId);
        for (AdapterPort p : AdapterPort.values()) {
            int port = this.portMapper.port(p);
            if (port == -1) {
                this.connections[p.ordinal()] = null;
                continue;
            }
            IConnection con = p == AdapterPort.DEBUG ? Adapter.createConnection(debugConnectionType, host, port, logger) : Adapter.createConnection(host, port, logger);
            this.connections[p.ordinal()] = con;
            if (enabler == null) continue;
            this.connections[p.ordinal()].setConnectionEnabler(enabler);
        }
    }

    @Override
    public IBackchannelPortMapper portMapper() {
        return this.portMapper;
    }

    @Override
    public IConnectionEnabler connectionEnabler() {
        return this.enabler;
    }

    @Override
    public void close() {
        for (AdapterPort p : AdapterPort.values()) {
            if (this.connections[p.ordinal()] == null) continue;
            this.connections[p.ordinal()].close();
        }
    }

    public boolean close(AdapterPort port) {
        if (this.getConnection(port) == null) {
            return false;
        }
        this.getConnection(port).close();
        return true;
    }

    @Override
    public IDebugConnection debugConnection() {
        IConnection con = this.connections[AdapterPort.DEBUG.ordinal()];
        if (con instanceof IDebugConnection) {
            return (IDebugConnection)con;
        }
        return null;
    }

    @Override
    public boolean disableDebugChannelCapture() {
        IDebugConnection debugConn = this.debugConnection();
        if (debugConn == null) {
            throw new IllegalArgumentException("Debug connection not found.");
        }
        debugConn.setConnectionProblemListener(null);
        this.debugMessageCollector.setDebugMessageListener(null);
        debugConn.removeConnectionListener(this.debugMessageCollector);
        this.logger.log(PtiSeverity.INFO, "Disable capture.", null);
        return true;
    }

    @Override
    public boolean enableDebugChannelCapture(IDebugMessageListener debugMessageListener, IConnectionProblemListener problemListener) {
        IDebugConnection debugConn = this.debugConnection();
        if (debugConn == null) {
            throw new IllegalArgumentException("Debug connection not found.");
        }
        if (!debugConn.isConnected()) {
            boolean connected = false;
            int connectTrys = 0;
            while (!connected && connectTrys < 3) {
                try {
                    debugConn.connect();
                    connected = true;
                }
                catch (IOException ioe) {
                    ++connectTrys;
                }
            }
            if (!connected) {
                return false;
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception connected) {
            // empty catch block
        }
        DebugChannelFramer f = new DebugChannelFramer(true);
        debugConn.setFramers(f, f);
        if (debugMessageListener != null) {
            this.debugMessageCollector.setDebugMessageListener(debugMessageListener);
            debugConn.addConnectionListener(this.debugMessageCollector);
        }
        if (problemListener != null) {
            debugConn.setConnectionProblemListener(problemListener);
        }
        this.logger.log(PtiSeverity.INFO, "Enable capture.", null);
        return true;
    }

    @Override
    public IConnection getConnection(AdapterPort port) {
        if (port == null) {
            return null;
        }
        return this.connections[port.ordinal()];
    }
}

