/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.AdapterSocketConnector;
import com.silabs.pti.adapter.AsciiFramer;
import com.silabs.pti.adapter.BaseConnection;
import com.silabs.pti.adapter.ConnectionSessionHandler;
import com.silabs.pti.adapter.IConnectivityLogger;
import com.silabs.pti.adapter.PtiCodecFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class Connection
extends BaseConnection {
    private static final String CONNECTION = "connection";
    private static final String CHARSET = "charset";
    private final int framingTimeout = 2000;
    private final Charset defaultCharset = Charset.forName("UTF-8");
    private IoConnector connector;
    private IoSession session;
    private IoHandler handler;

    Connection(AdapterSocketConnector connector, String host, int port, IConnectivityLogger logger) {
        super(host, port, logger);
        this.connector = connector.ioConnector();
        this.handler = connector.ioConnector().getHandler();
    }

    Connection(String host, int port, IConnectivityLogger logger) {
        super(host, port, logger);
    }

    @Override
    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        if (this.connectionEnabler != null) {
            this.connectionEnabler.prepareConnection(this.host + ":" + this.port);
        }
        if (this.connector == null) {
            this.connector = new NioSocketConnector();
            this.connector.setConnectTimeoutMillis(2000L);
            this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new PtiCodecFactory(this.defaultCharset)));
            if (this.handler == null) {
                this.handler = new ConnectionSessionHandler();
            }
            this.connector.setHandler(this.handler);
        }
        ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
        future.awaitUninterruptibly();
        this.session = future.getSession();
        this.session.setAttribute((Object)CONNECTION, (Object)this);
        this.session.setAttribute((Object)CHARSET, (Object)this.defaultCharset);
        this.logInfo("Connect.");
        this.initFramers();
        this.informListenersOfState(true);
    }

    @Override
    public void close() {
        if (this.isConnected()) {
            try {
                this.logInfo("Disconnect.");
                this.session.closeNow();
            }
            catch (Exception e) {
                this.reportProblem("Close socket.", e);
                this.logError("Disconnect error.", e);
            }
        }
        this.session = null;
        if (this.connectionEnabler != null) {
            this.connectionEnabler.releaseConnection(this.host + ":" + this.port);
        }
        this.informListenersOfState(false);
    }

    @Override
    public void send(byte[] message) throws IOException {
        byte[] outgoing;
        IoSession out = this.getOutputSession();
        Charset charset = (Charset)out.getAttribute((Object)CHARSET);
        if (out == null || message == null || charset == null) {
            return;
        }
        byte[] byArray = outgoing = this.frameOutgoing ? this.outgoingFramer.frame(message) : message;
        if (outgoing == null) {
            return;
        }
        IoBuffer buf = IoBuffer.allocate((int)outgoing.length).setAutoExpand(true);
        buf.put(outgoing);
        buf.flip();
        out.write((Object)buf);
        this.logInfo("Write " + outgoing.length + " bytes.");
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isConnected() && !this.session.isClosing();
    }

    public IoSession getInputSession() {
        return this.isConnected() ? this.session : null;
    }

    public IoSession getOutputSession() {
        return this.isConnected() ? this.session : null;
    }

    public IoSession getIoSession() {
        return this.isConnected() ? this.session : null;
    }

    public void initFramers() {
        if (this.incomingFramer == null) {
            this.incomingFramer = new AsciiFramer();
        }
        if (this.outgoingFramer == null) {
            this.outgoingFramer = new AsciiFramer();
        }
    }

    @Override
    public void repair() throws IOException {
        if (this.connectionEnabler != null) {
            this.connectionEnabler.repairConnection(this.host + ":" + this.port);
        }
    }
}

