/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.AsciiFramer;
import com.silabs.pti.adapter.BaseConnection;
import com.silabs.pti.adapter.DataBuffer;
import com.silabs.pti.adapter.IConnectivityLogger;
import com.silabs.pti.log.PtiLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class DualThreadBufferedConnection
extends BaseConnection {
    private final int framingTimeout = 2000;
    private Socket socket;
    private Thread listenThread;
    private volatile boolean threadStopRequest = false;
    private volatile boolean threadRunning = false;
    private static ThreadGroup listenGroup = new ThreadGroup("Connection Listeners");
    private static final int INCOMING_BUFFER = 131072;
    private final DataBuffer<DataChunk> buffer = new DataBuffer<DataChunk>(listenGroup, "Deframer", t -> this.processIncomingData(t.time(), t.count(), t.data()));

    DualThreadBufferedConnection(String host, int port, IConnectivityLogger logger) {
        super(host, port, logger);
    }

    @Override
    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.socket = new Socket();
        if (this.connectionEnabler != null) {
            this.connectionEnabler.prepareConnection(this.host + ":" + this.port);
        }
        this.socket.connect(new InetSocketAddress(this.host, this.port), 2000);
        this.logInfo("Connect.");
        this.startListenThread();
        this.informListenersOfState(true);
    }

    @Override
    public void close() {
        this.stopListenThread();
        if (this.isConnected()) {
            try {
                this.logInfo("Disconnect.");
                this.socket.shutdownOutput();
                this.socket.shutdownInput();
                this.socket.close();
            }
            catch (Exception e) {
                this.reportProblem("Close socket.", e);
                this.logError("Disconnect error.", e);
            }
        }
        this.socket = null;
        if (this.connectionEnabler != null) {
            this.connectionEnabler.releaseConnection(this.host + ":" + this.port);
        }
        this.informListenersOfState(false);
    }

    private void run() {
        this.logInfo("Reading thread start.");
        this.buffer.startThread();
        InputStream in = null;
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.setSoTimeout(10);
            in = this.socket.getInputStream();
        }
        catch (SocketException e) {
            this.logError("Set timeout failed.", e);
            return;
        }
        catch (IOException e) {
            this.logError("No input stream.", e);
            return;
        }
        this.threadRunning = true;
        boolean socketClosedByPeer = false;
        long lastReadTime = System.currentTimeMillis();
        byte[] readBytes = new byte[131072];
        while (!this.threadStopRequest) {
            int readCount = -1;
            try {
                readCount = in.read(readBytes);
            }
            catch (InterruptedIOException e) {
                if (!this.timedOut(lastReadTime)) continue;
                this.incomingFramer.flushMessage();
                continue;
            }
            catch (IOException e) {
                this.reportProblem("Error reading data", e);
                this.logError("Data read error.", e);
            }
            lastReadTime = System.currentTimeMillis();
            if (readCount > -1) {
                this.buffer.addObject(new DataChunk(lastReadTime, readCount, readBytes));
                continue;
            }
            if (readCount != -1) continue;
            socketClosedByPeer = true;
            this.threadStopRequest = true;
        }
        this.threadRunning = false;
        if (socketClosedByPeer) {
            this.close();
        }
        this.buffer.stopThread();
        this.logInfo("Reading thread stop.");
    }

    @Override
    public void send(byte[] message) throws IOException {
        byte[] outgoing;
        OutputStream out = this.getOutputStream();
        if (out == null || message == null) {
            return;
        }
        byte[] byArray = outgoing = this.frameOutgoing ? this.outgoingFramer.frame(message) : message;
        if (outgoing == null) {
            return;
        }
        this.logInfo("Write " + outgoing.length + " bytes.");
        out.write(outgoing);
        out.flush();
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public InputStream getInputStream() {
        if (this.isConnected()) {
            try {
                return this.socket.getInputStream();
            }
            catch (Exception e) {
                PtiLog.error("Exception getting input stream, closing socket", e);
                this.close();
            }
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isConnected()) {
            try {
                return this.socket.getOutputStream();
            }
            catch (Exception e) {
                this.logError("Exception getting output stream, reconnecting", e);
                this.connect();
            }
        }
        return null;
    }

    public void startListenThread() {
        this.threadStopRequest = false;
        if (this.incomingFramer == null) {
            this.incomingFramer = new AsciiFramer();
        }
        if (this.outgoingFramer == null) {
            this.outgoingFramer = new AsciiFramer();
        }
        this.listenThread = new Thread(listenGroup, () -> this.run());
        this.listenThread.start();
    }

    public void stopListenThread() {
        this.threadStopRequest = true;
        while (this.threadRunning) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 2000L;
    }

    private static class DataChunk {
        private final long t;
        private final int count;
        private final byte[] data;

        public DataChunk(long t, int count, byte[] data) {
            this.t = t;
            this.count = count;
            this.data = new byte[count];
            System.arraycopy(data, 0, this.data, 0, count);
        }

        public long time() {
            return this.t;
        }

        public int count() {
            return this.count;
        }

        public byte[] data() {
            return this.data;
        }
    }
}

