/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.AdapterPort;
import com.silabs.pti.adapter.IBackchannelPortMapper;
import com.silabs.pti.adapter.IConnection;
import com.silabs.pti.adapter.IConnectionEnabler;
import com.silabs.pti.adapter.IConnectionProblemListener;
import com.silabs.pti.adapter.IDebugConnection;
import com.silabs.pti.adapter.IDebugMessageListener;
import java.io.IOException;

public interface IBackchannel {
    public IBackchannelPortMapper portMapper();

    public IConnectionEnabler connectionEnabler();

    public void close();

    public IConnection getConnection(AdapterPort var1);

    default public IConnection admin() {
        return this.getConnection(AdapterPort.ADMIN);
    }

    public IDebugConnection debugConnection();

    default public void connect(AdapterPort port) throws IOException {
        IConnection connection = this.getConnection(port);
        if (connection == null) {
            throw new IOException("No connection declared for port: " + port.name());
        }
        connection.connect();
    }

    default public boolean isConnected(AdapterPort port) {
        if (this.getConnection(port) == null) {
            return false;
        }
        return this.getConnection(port).isConnected();
    }

    default public IConnection serial0() {
        return this.getConnection(AdapterPort.SERIAL0);
    }

    default public IConnection serial1() {
        return this.getConnection(AdapterPort.SERIAL1);
    }

    public boolean enableDebugChannelCapture(IDebugMessageListener var1, IConnectionProblemListener var2);

    public boolean disableDebugChannelCapture();
}

