/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.debugchannel;

import com.silabs.pti.adapter.IConnectionListener;
import com.silabs.pti.adapter.IDebugMessageListener;
import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.log.PtiLog;

public class DebugMessageCollector
implements IConnectionListener {
    private IDebugMessageListener listener = null;
    private final String originatorId;
    private int count;

    public DebugMessageCollector(String originatorId) {
        this.originatorId = originatorId;
        this.count = 0;
    }

    @Override
    public void messageReceived(byte[] message, long pcTime) {
        DebugMessage debugMessage = DebugMessage.make(this.originatorId, message, pcTime);
        if (debugMessage != null && this.listener != null) {
            ++this.count;
            try {
                this.listener.processMessage(debugMessage);
            }
            catch (Exception e) {
                PtiLog.warning("Connection listener error", e);
            }
        }
    }

    @Override
    public void connectionStateChanged(boolean isConnected) {
    }

    public void setDebugMessageListener(IDebugMessageListener l) {
        this.listener = l;
    }

    @Override
    public int count() {
        return this.count;
    }
}

