/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.decode;

import com.silabs.pti.decode.IAemCurrentSample;

public class AemSample
implements IAemCurrentSample {
    private final long timestamp;
    private final float current;
    private final float voltage;

    public AemSample(long timestamp, float current, float voltage) {
        this.timestamp = timestamp;
        this.current = current;
        this.voltage = voltage;
    }

    public String toString() {
        return "[TimeStamp: " + this.timestamp + "  Current: " + this.current + "]";
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public float current() {
        return this.current;
    }

    @Override
    public float voltage() {
        return this.voltage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.current);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + Float.floatToIntBits(this.voltage);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AemSample other = (AemSample)obj;
        if (Float.floatToIntBits(this.current) != Float.floatToIntBits(other.current)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return Float.floatToIntBits(this.voltage) == Float.floatToIntBits(other.voltage);
    }
}

