/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.extcap;

import com.silabs.pti.discovery.DiscoveryKey;
import com.silabs.pti.discovery.DiscoveryUtil;
import com.silabs.pti.extcap.ExtcapCapture;
import com.silabs.pti.extcap.IExtcapInterface;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Extcap
implements IExtcapInterface {
    public static final String EXTCAP = "extcap";
    private static final String EC_INTERFACES = "--extcap-interfaces";
    private static final String EC_CONFIG = "--extcap-config";
    private static final String EC_CAPTURE = "--capture";
    private static final String EC_DLTS = "--extcap-dlts";
    private static final String EC_INTERFACE = "--extcap-interface";
    private static final String EC_FIFO = "--fifo";
    private static final String EC_CAPTURE_FILTER = "--extcap-capture-filter";
    private File logFile = null;
    private PrintWriter logWriter;
    private final PrintStream extcapOut;
    private final List<String> extcapArgs = new ArrayList<String>();

    public static final int run(String[] args) {
        return new Extcap(args).run();
    }

    private Extcap(String[] args) {
        String extcapLocation = System.getenv("EXTCAP_LOC");
        if (extcapLocation != null) {
            this.logFile = new File(extcapLocation, "silabs-pti.log");
        }
        this.extcapOut = System.out;
        for (int i = 0; i < args.length; ++i) {
            if (i <= 0) continue;
            this.extcapArgs.add(args[i]);
        }
    }

    @Override
    public void log(String s) {
        String d = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
        this.logWriter.println(d + ": " + s);
    }

    @Override
    public void extcapPrintln(String s) {
        this.log("extcap <           " + s);
        this.extcapOut.println(s);
    }

    private String extractCommandFromArgs() {
        Iterator<String> iterator = this.extcapArgs.iterator();
        while (iterator.hasNext()) {
            String extcapArg;
            switch (extcapArg = iterator.next()) {
                case "--extcap-interfaces": {
                    return EC_INTERFACES;
                }
                case "--extcap-dlts": {
                    return EC_DLTS;
                }
                case "--extcap-config": {
                    return EC_CONFIG;
                }
                case "--capture": {
                    return EC_CAPTURE;
                }
            }
        }
        return null;
    }

    private String extractValueFromArg(String arg) {
        for (int i = 0; i < this.extcapArgs.size(); ++i) {
            if (!this.extcapArgs.get(i).equals(arg) || i + 1 >= this.extcapArgs.size()) continue;
            return this.extcapArgs.get(i + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int run() {
        try (PrintWriter l = this.logFile != null ? new PrintWriter((Writer)new FileWriter(this.logFile, true), true) : new PrintWriter(System.out);){
            this.logWriter = l;
            StringBuilder sb = new StringBuilder("extcap > ");
            for (String s : this.extcapArgs) {
                sb.append(" ").append(s);
            }
            this.log(sb.toString());
            String cmd = this.extractCommandFromArgs();
            if (cmd != null) {
                switch (cmd) {
                    case "--extcap-interfaces": {
                        int n = this.extcapInterfaces();
                        return n;
                    }
                    case "--extcap-dlts": {
                        int n = this.extcapDlts(this.extractValueFromArg(EC_INTERFACE));
                        return n;
                    }
                    case "--extcap-config": {
                        int n = this.extcapConfig(this.extractValueFromArg(EC_INTERFACE));
                        return n;
                    }
                    case "--capture": {
                        int n = this.extcapCapture(this.extractValueFromArg(EC_INTERFACE));
                        return n;
                    }
                }
                return 0;
            }
            int n = 1;
            return n;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
        return 0;
    }

    private int extcapInterfaces() {
        this.extcapPrintln("extcap {version=1.0}{help=http://silabs.com}");
        DiscoveryUtil.runDiscovery(packet -> {
            Map<DiscoveryKey, String> data = DiscoveryUtil.parseDiscoveryMap(packet);
            Object name = "Silicon Labs WSTK adapter";
            String ip = packet.getAddress().getHostAddress();
            if (data.containsKey((Object)DiscoveryKey.ADAPTER_NETIF)) {
                ip = data.get((Object)DiscoveryKey.ADAPTER_NETIF);
            }
            if (data.containsKey((Object)DiscoveryKey.ADAPTER_NICKNAME)) {
                name = data.get((Object)DiscoveryKey.ADAPTER_NICKNAME) + " (Silicon Labs WSTK adapter)";
            }
            this.extcapPrintln("interface {value=" + ip + "}{display=" + (String)name + "}");
        });
        return 0;
    }

    private int extcapDlts(String ifc) {
        if (ifc == null) {
            return 1;
        }
        this.extcapPrintln("dlt {number=147}{name=USER1}{display=WSTK Silicon Labs DLT}");
        return 0;
    }

    private int extcapCapture(String ifc) {
        if (ifc == null) {
            return 1;
        }
        String fifo = this.extractValueFromArg(EC_FIFO);
        String filter = this.extractValueFromArg(EC_CAPTURE_FILTER);
        this.log("capture: from " + ifc + " into " + fifo + (String)(filter == null ? " with no filter" : " with filter " + filter));
        ExtcapCapture capture = new ExtcapCapture(ifc, fifo);
        try {
            capture.capture(this);
            return 0;
        }
        catch (IOException ioe) {
            this.log("error during capture: " + ioe.getMessage());
            return 1;
        }
    }

    private int extcapConfig(String ifc) {
        if (ifc == null) {
            return 1;
        }
        return 0;
    }
}

