/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.filter;

import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.filter.DebugMessageFilterExpression;
import com.silabs.pti.filter.FilterExpression;
import com.silabs.pti.filter.IDebugMessageFilter;
import java.text.ParseException;

public class CliDebugMessageFilter
implements IDebugMessageFilter {
    private final DebugMessageFilterExpression filterChain;

    public CliDebugMessageFilter(String expression) throws ParseException {
        this.filterChain = new DebugMessageFilterExpression(0, expression);
    }

    public void andFilter(String expression) throws ParseException {
        this.filterChain.and(expression);
    }

    public void orFilter(String expression) throws ParseException {
        this.filterChain.or(expression);
    }

    @Override
    public boolean isMessageKept(DebugMessage message) {
        return this.filterChain.isMessageKept(message);
    }

    public static String helpText() {
        StringBuilder sb = new StringBuilder();
        sb.append("  " + FilterExpression.TYPE_IN.functionName() + "(x,y,z,...)       - type matches one of the values specified as numbers or text\n");
        sb.append("  " + FilterExpression.ORIGINATOR_IN.functionName() + "(x,y,z,...) - originator matches one of the values\n");
        sb.append("  " + FilterExpression.CONTAINS.functionName() + "(x)             - payload contains specified string or hexblob\n");
        sb.append("  " + FilterExpression.SIZE_WITHIN.functionName() + "(x,y)         - payload size must be within x and y, inclusive\n");
        sb.append("  " + FilterExpression.TIME_WITHIN.functionName() + "(x,y)         - network time must be within x and y, inclusive\n");
        sb.append("(Expression can be prefixed with '!' for negation.)\n");
        return sb.toString();
    }
}

