/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.format;

import com.silabs.pti.format.AemFileFormat;
import com.silabs.pti.format.DumpFileFormat;
import com.silabs.pti.format.IDebugChannelExportFormat;
import com.silabs.pti.format.LogFileFormat;
import com.silabs.pti.format.PcapngFormat;
import com.silabs.pti.format.RawFileFormat;
import com.silabs.pti.format.TextFileFormat;

public enum FileFormat {
    DUMP(new DumpFileFormat()),
    RAW(new RawFileFormat()),
    LOG(new LogFileFormat()),
    AEM(new AemFileFormat()),
    TEXT(new TextFileFormat()),
    PCAPNG(new PcapngFormat(PcapngFormat.Mode.DCH)),
    PCAPNG_MATTER(new PcapngFormat(PcapngFormat.Mode.MATTER)),
    PCAPNG_ZIGBEE(new PcapngFormat(PcapngFormat.Mode.ZIGBEE)),
    PCAPNG_WISUN(new PcapngFormat(PcapngFormat.Mode.WISUN)),
    PCAPNG_BLE(new PcapngFormat(PcapngFormat.Mode.BLUETOOTH));

    private IDebugChannelExportFormat<?> format;

    private FileFormat(IDebugChannelExportFormat<?> format) {
        this.format = format;
    }

    public IDebugChannelExportFormat<?> format() {
        return this.format;
    }

    public static String displayOptionsAsString() {
        StringBuilder formats = new StringBuilder();
        String sep = "";
        for (FileFormat ff : FileFormat.values()) {
            formats.append(sep).append(ff.name().toLowerCase());
            sep = "|";
        }
        return formats.toString();
    }
}

